/* Copyright (c) 2023 Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

package com.oracle.truffle.espresso.substitutions;

import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import com.oracle.truffle.espresso.runtime.EspressoContext;
import com.oracle.truffle.espresso.EspressoLanguage;
import com.oracle.truffle.espresso.meta.Meta;

/**
 * Generated by: {@link Target_sun_misc_Unsafe#defineClass(StaticObject, StaticObject, StaticObject, int, int, StaticObject, StaticObject, EspressoLanguage, Meta)}
 */
public final class Target_sun_misc_Unsafe_defineClass__LLLIILL extends JavaSubstitution {

    @Collect(value = com.oracle.truffle.espresso.substitutions.Substitution.class) public static final class Factory extends JavaSubstitution.Factory {

        public Factory() {
            super(
                "defineClass",
                "Target_sun_misc_Unsafe",
                "Ljava/lang/Class;",
                new String[]{
                    "Lsun/misc/Unsafe;",
                    "Ljava/lang/String;",
                    "[B",
                    "I",
                    "I",
                    "Ljava/lang/ClassLoader;",
                    "Ljava/security/ProtectionDomain;",
                },
                true
            );
        }

        @Override
        public final String[] getMethodNames() {
            return Target_sun_misc_Unsafe.SharedUnsafeAppend0.INSTANCE.getMethodNames("defineClass");
        }

        @Override
        public final String[] substitutionClassNames() {
            return Target_sun_misc_Unsafe.SharedUnsafeAppend0.INSTANCE.substitutionClassNames();
        }

        @Override
        public final JavaSubstitution create() {
            return new Target_sun_misc_Unsafe_defineClass__LLLIILL();
        }

    }

    @SuppressWarnings(value = "unused") private Target_sun_misc_Unsafe_defineClass__LLLIILL() {
    }

    @Override
    public final JavaSubstitution split() {
        return new Factory().create();
    }

    @Override
    public final Object invoke(Object[] args) {
        StaticObject arg0 = (StaticObject) args[0];
        StaticObject arg1 = (StaticObject) args[1];
        StaticObject arg2 = (StaticObject) args[2];
        int arg3 = (int) args[3];
        int arg4 = (int) args[4];
        StaticObject arg5 = (StaticObject) args[5];
        StaticObject arg6 = (StaticObject) args[6];
        EspressoContext context = getContext();
        return Target_sun_misc_Unsafe.defineClass(arg0, arg1, arg2, arg3, arg4, arg5, arg6, getLanguage(), context.getMeta());

    }

}

