// CheckStyle: start generated
package com.oracle.truffle.espresso.runtime.staticobject;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.nodes.NodeCost;

@GeneratedBy(StaticObject.class)
@SuppressWarnings("unused")
public final class StaticObjectGen {

    static  {
        LibraryExport.register(StaticObject.class, new DynamicDispatchLibraryExports());
    }

    private StaticObjectGen() {
    }

    @GeneratedBy(StaticObject.class)
    public static class DynamicDispatchLibraryExports extends LibraryExport<DynamicDispatchLibrary> {

        private DynamicDispatchLibraryExports() {
            super(DynamicDispatchLibrary.class, StaticObject.class, false, false, 0);
        }

        @Override
        protected DynamicDispatchLibrary createUncached(Object receiver) {
            assert receiver instanceof StaticObject;
            DynamicDispatchLibrary uncached = new Uncached(receiver);
            return uncached;
        }

        @Override
        protected DynamicDispatchLibrary createCached(Object receiver) {
            assert receiver instanceof StaticObject;
            return new Cached(receiver);
        }

        @GeneratedBy(StaticObject.class)
        public static class Cached extends DynamicDispatchLibrary {

            private final Class<? extends StaticObject> receiverClass_;

            protected Cached(Object receiver) {
                StaticObject castReceiver = ((StaticObject) receiver) ;
                this.receiverClass_ = castReceiver.getClass();
            }

            @Override
            public Object cast(Object receiver) {
                return CompilerDirectives.castExact(receiver, receiverClass_);
            }

            @Override
            public boolean accepts(Object receiver) {
                return CompilerDirectives.isExact(receiver, this.receiverClass_);
            }

            @Override
            public Class<?> dispatch(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return (CompilerDirectives.castExact(receiver, receiverClass_)).dispatch();
            }

        }
        @GeneratedBy(StaticObject.class)
        public static class Uncached extends DynamicDispatchLibrary {

            protected Uncached(Object receiver) {
            }

            @Override
            @TruffleBoundary
            public boolean accepts(Object receiver) {
                return receiver instanceof StaticObject;
            }

            @SuppressWarnings("cast")
            @TruffleBoundary
            @Override
            public Object cast(Object receiver) {
                return ((StaticObject) receiver);
            }

            @Override
            public final boolean isAdoptable() {
                return false;
            }

            @Override
            public final NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @TruffleBoundary
            @Override
            public Class<?> dispatch(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((StaticObject) receiver) .dispatch();
            }

        }
    }
}
