/* Copyright (c) 2023 Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

package com.oracle.truffle.espresso.runtime.dispatch.staticobject;

/**
 * Generated by: {@link com.oracle.truffle.espresso.runtime.dispatch.staticobject.MapEntryInterop}
 */
@com.oracle.truffle.espresso.substitutions.Collect(getter = "getInstance", value = com.oracle.truffle.espresso.runtime.dispatch.messages.InteropNodes.class)
public final class MapEntryInteropInteropNodes extends com.oracle.truffle.espresso.runtime.dispatch.messages.InteropNodes {

    private static final Factory factory = new Factory(com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessageFactories.dispatchToId(MapEntryInterop.class));

    private static final com.oracle.truffle.espresso.runtime.dispatch.messages.InteropNodes INSTANCE = new MapEntryInteropInteropNodes();

    private MapEntryInteropInteropNodes() {
        super(MapEntryInterop.class, EspressoInteropInteropNodes.getInstance());
    }

    public static com.oracle.truffle.espresso.runtime.dispatch.messages.InteropNodes getInstance() {
        return INSTANCE;
    }

    static final class Factory implements com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessageFactory {

        private final int sourceDispatch;

        Factory(int sourceDispatch) {
            this.sourceDispatch = sourceDispatch;
        }

        @Override
        public final int sourceDispatch() {
            return sourceDispatch;
        }

        @Override
        public final com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage create(com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.Message message){
            switch (message) {
                case HasArrayElements: return MapEntryInteropInteropNodesFactory.HasArrayElementsNodeGen.create();
                case GetArraySize: return MapEntryInteropInteropNodesFactory.GetArraySizeNodeGen.create();
                case IsArrayElementModifiable: return MapEntryInteropInteropNodesFactory.IsArrayElementModifiableNodeGen.create();
                case IsArrayElementReadable: return MapEntryInteropInteropNodesFactory.IsArrayElementReadableNodeGen.create();
                case WriteArrayElement: return MapEntryInteropInteropNodesFactory.WriteArrayElementNodeGen.create();
                case ReadArrayElement: return MapEntryInteropInteropNodesFactory.ReadArrayElementNodeGen.create();
                default: return null;
            }
        }

    }

    abstract static class HasArrayElementsNode extends com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.HasArrayElements {

        @com.oracle.truffle.api.dsl.Specialization
        static boolean hasArrayElements(com.oracle.truffle.espresso.runtime.staticobject.StaticObject receiver){
            return com.oracle.truffle.espresso.runtime.dispatch.staticobject.MapEntryInterop.hasArrayElements(receiver);
        }

    }

    abstract static class GetArraySizeNode extends com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.GetArraySize {

        @com.oracle.truffle.api.dsl.Specialization
        static long getArraySize(com.oracle.truffle.espresso.runtime.staticobject.StaticObject receiver){
            return com.oracle.truffle.espresso.runtime.dispatch.staticobject.MapEntryInterop.getArraySize(receiver);
        }

    }

    abstract static class IsArrayElementModifiableNode extends com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.IsArrayElementModifiable {

        @com.oracle.truffle.api.dsl.Specialization
        static boolean isArrayElementModifiable(com.oracle.truffle.espresso.runtime.staticobject.StaticObject receiver, long index){
            return com.oracle.truffle.espresso.runtime.dispatch.staticobject.MapEntryInterop.isArrayElementModifiable(receiver, index);
        }

    }

    abstract static class IsArrayElementReadableNode extends com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.IsArrayElementReadable {

        @com.oracle.truffle.api.dsl.Specialization
        static boolean isArrayElementReadable(com.oracle.truffle.espresso.runtime.staticobject.StaticObject receiver, long index){
            return com.oracle.truffle.espresso.runtime.dispatch.staticobject.MapEntryInterop.isArrayElementReadable(receiver, index);
        }

    }

    abstract static class WriteArrayElementNode extends com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.WriteArrayElement {

        @com.oracle.truffle.api.dsl.Specialization
        static void writeArrayElement(com.oracle.truffle.espresso.runtime.staticobject.StaticObject receiver, long index, java.lang.Object value, @com.oracle.truffle.api.dsl.Cached(value = "create($parameters)") com.oracle.truffle.espresso.nodes.interop.InvokeEspressoNode invoke) throws com.oracle.truffle.api.interop.InvalidArrayIndexException{
            com.oracle.truffle.espresso.runtime.dispatch.staticobject.MapEntryInterop.writeArrayElement(receiver, index, value, invoke);
        }

    }

    abstract static class ReadArrayElementNode extends com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.ReadArrayElement {

        @com.oracle.truffle.api.dsl.Specialization
        static java.lang.Object readArrayElement(com.oracle.truffle.espresso.runtime.staticobject.StaticObject receiver, long index, @com.oracle.truffle.api.dsl.Cached(value = "create($parameters)") com.oracle.truffle.espresso.nodes.interop.InvokeEspressoNode invoke) throws com.oracle.truffle.api.interop.InvalidArrayIndexException{
            return com.oracle.truffle.espresso.runtime.dispatch.staticobject.MapEntryInterop.readArrayElement(receiver, index, invoke);
        }

    }

    @Override
    protected void registerMessages(Class<?> cls) {
        com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessageFactories.register(cls, com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.Message.HasArrayElements, factory,true);
        com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessageFactories.register(cls, com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.Message.GetArraySize, factory,true);
        com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessageFactories.register(cls, com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.Message.IsArrayElementModifiable, factory,true);
        com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessageFactories.register(cls, com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.Message.IsArrayElementReadable, factory,true);
        com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessageFactories.register(cls, com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.Message.WriteArrayElement, factory,false);
        com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessageFactories.register(cls, com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.Message.ReadArrayElement, factory,false);
    }

}

