/* Copyright (c) 2023 Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

package com.oracle.truffle.espresso.runtime.dispatch.staticobject;

/**
 * Generated by: {@link com.oracle.truffle.espresso.runtime.dispatch.staticobject.IteratorInterop}
 */
@com.oracle.truffle.espresso.substitutions.Collect(getter = "getInstance", value = com.oracle.truffle.espresso.runtime.dispatch.messages.InteropNodes.class)
public final class IteratorInteropInteropNodes extends com.oracle.truffle.espresso.runtime.dispatch.messages.InteropNodes {

    private static final Factory factory = new Factory(com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessageFactories.dispatchToId(IteratorInterop.class));

    private static final com.oracle.truffle.espresso.runtime.dispatch.messages.InteropNodes INSTANCE = new IteratorInteropInteropNodes();

    private IteratorInteropInteropNodes() {
        super(IteratorInterop.class, EspressoInteropInteropNodes.getInstance());
    }

    public static com.oracle.truffle.espresso.runtime.dispatch.messages.InteropNodes getInstance() {
        return INSTANCE;
    }

    static final class Factory implements com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessageFactory {

        private final int sourceDispatch;

        Factory(int sourceDispatch) {
            this.sourceDispatch = sourceDispatch;
        }

        @Override
        public final int sourceDispatch() {
            return sourceDispatch;
        }

        @Override
        public final com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage create(com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.Message message){
            switch (message) {
                case IsIterator: return IteratorInteropInteropNodesFactory.IsIteratorNodeGen.create();
                case HasIteratorNextElement: return IteratorInteropInteropNodesFactory.HasIteratorNextElementNodeGen.create();
                case GetIteratorNextElement: return IteratorInteropInteropNodesFactory.GetIteratorNextElementNodeGen.create();
                default: return null;
            }
        }

    }

    abstract static class IsIteratorNode extends com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.IsIterator {

        @com.oracle.truffle.api.dsl.Specialization
        static boolean isIterator(com.oracle.truffle.espresso.runtime.staticobject.StaticObject receiver){
            return com.oracle.truffle.espresso.runtime.dispatch.staticobject.IteratorInterop.isIterator(receiver);
        }

    }

    abstract static class HasIteratorNextElementNode extends com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.HasIteratorNextElement {

        @com.oracle.truffle.api.dsl.Specialization
        static boolean hasIteratorNextElement(com.oracle.truffle.espresso.runtime.staticobject.StaticObject receiver, @com.oracle.truffle.api.dsl.Bind(value = "getMeta().java_util_Iterator_hasNext") com.oracle.truffle.espresso.impl.Method hasNext, @com.oracle.truffle.api.dsl.Cached(value = "create($parameters)") com.oracle.truffle.espresso.nodes.interop.LookupAndInvokeKnownMethodNode lookupAndInvoke){
            return com.oracle.truffle.espresso.runtime.dispatch.staticobject.IteratorInterop.hasIteratorNextElement(receiver, hasNext, lookupAndInvoke);
        }

    }

    abstract static class GetIteratorNextElementNode extends com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.GetIteratorNextElement {

        @com.oracle.truffle.api.dsl.Specialization
        static java.lang.Object getIteratorNextElement(com.oracle.truffle.espresso.runtime.staticobject.StaticObject receiver, @com.oracle.truffle.api.dsl.Bind(value = "getMeta().java_util_Iterator_next") com.oracle.truffle.espresso.impl.Method next, @com.oracle.truffle.api.dsl.Cached(value = "create($parameters)") com.oracle.truffle.espresso.nodes.interop.LookupAndInvokeKnownMethodNode lookupAndInvoke) throws com.oracle.truffle.api.interop.StopIterationException{
            return com.oracle.truffle.espresso.runtime.dispatch.staticobject.IteratorInterop.getIteratorNextElement(receiver, next, lookupAndInvoke);
        }

    }

    @Override
    protected void registerMessages(Class<?> cls) {
        com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessageFactories.register(cls, com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.Message.IsIterator, factory,true);
        com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessageFactories.register(cls, com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.Message.HasIteratorNextElement, factory,false);
        com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessageFactories.register(cls, com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.Message.GetIteratorNextElement, factory,false);
    }

}

