/* Copyright (c) 2023 Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

package com.oracle.truffle.espresso.runtime.dispatch.staticobject;

/**
 * Generated by: {@link com.oracle.truffle.espresso.runtime.dispatch.staticobject.BaseInterop}
 */
@com.oracle.truffle.espresso.substitutions.Collect(getter = "getInstance", value = com.oracle.truffle.espresso.runtime.dispatch.messages.InteropNodes.class)
public final class BaseInteropInteropNodes extends com.oracle.truffle.espresso.runtime.dispatch.messages.InteropNodes {

    private static final Factory factory = new Factory(com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessageFactories.dispatchToId(BaseInterop.class));

    private static final com.oracle.truffle.espresso.runtime.dispatch.messages.InteropNodes INSTANCE = new BaseInteropInteropNodes();

    private BaseInteropInteropNodes() {
        super(BaseInterop.class, null);
    }

    public static com.oracle.truffle.espresso.runtime.dispatch.messages.InteropNodes getInstance() {
        return INSTANCE;
    }

    static final class Factory implements com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessageFactory {

        private final int sourceDispatch;

        Factory(int sourceDispatch) {
            this.sourceDispatch = sourceDispatch;
        }

        @Override
        public final int sourceDispatch() {
            return sourceDispatch;
        }

        @Override
        public final com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage create(com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.Message message){
            switch (message) {
                case IsNull: return BaseInteropInteropNodesFactory.IsNullNodeGen.create();
                case IsString: return BaseInteropInteropNodesFactory.IsStringNodeGen.create();
                case AsString: return BaseInteropInteropNodesFactory.AsStringNodeGen.create();
                case IsMetaObject: return BaseInteropInteropNodesFactory.IsMetaObjectNodeGen.create();
                case GetMetaQualifiedName: return BaseInteropInteropNodesFactory.GetMetaQualifiedNameNodeGen.create();
                case GetMetaSimpleName: return BaseInteropInteropNodesFactory.GetMetaSimpleNameNodeGen.create();
                case IsMetaInstance: return BaseInteropInteropNodesFactory.IsMetaInstanceNodeGen.create();
                case HasMetaObject: return BaseInteropInteropNodesFactory.HasMetaObjectNodeGen.create();
                case GetMetaObject: return BaseInteropInteropNodesFactory.GetMetaObjectNodeGen.create();
                case HasMetaParents: return BaseInteropInteropNodesFactory.HasMetaParentsNodeGen.create();
                case GetMetaParents: return BaseInteropInteropNodesFactory.GetMetaParentsNodeGen.create();
                case IsIdenticalOrUndefined: return BaseInteropInteropNodesFactory.IsIdenticalOrUndefinedNodeGen.create();
                case IdentityHashCode: return BaseInteropInteropNodesFactory.IdentityHashCodeNodeGen.create();
                case HasLanguage: return BaseInteropInteropNodesFactory.HasLanguageNodeGen.create();
                case GetLanguage: return BaseInteropInteropNodesFactory.GetLanguageNodeGen.create();
                case ToDisplayString: return BaseInteropInteropNodesFactory.ToDisplayStringNodeGen.create();
                default: return null;
            }
        }

    }

    abstract static class IsNullNode extends com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.IsNull {

        @com.oracle.truffle.api.dsl.Specialization
        static boolean isNull(com.oracle.truffle.espresso.runtime.staticobject.StaticObject object){
            return com.oracle.truffle.espresso.runtime.dispatch.staticobject.BaseInterop.isNull(object);
        }

    }

    abstract static class IsStringNode extends com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.IsString {

        @com.oracle.truffle.api.dsl.Specialization
        static boolean isString(com.oracle.truffle.espresso.runtime.staticobject.StaticObject object){
            return com.oracle.truffle.espresso.runtime.dispatch.staticobject.BaseInterop.isString(object);
        }

    }

    abstract static class AsStringNode extends com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.AsString {

        @com.oracle.truffle.api.dsl.Specialization
        static java.lang.String asString(com.oracle.truffle.espresso.runtime.staticobject.StaticObject object) throws com.oracle.truffle.api.interop.UnsupportedMessageException{
            return com.oracle.truffle.espresso.runtime.dispatch.staticobject.BaseInterop.asString(object);
        }

    }

    abstract static class IsMetaObjectNode extends com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.IsMetaObject {

        @com.oracle.truffle.api.dsl.Specialization
        static boolean isMetaObject(com.oracle.truffle.espresso.runtime.staticobject.StaticObject object){
            return com.oracle.truffle.espresso.runtime.dispatch.staticobject.BaseInterop.isMetaObject(object);
        }

    }

    abstract static class GetMetaQualifiedNameNode extends com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.GetMetaQualifiedName {

        @com.oracle.truffle.api.dsl.Specialization
        static java.lang.Object getMetaQualifiedName(com.oracle.truffle.espresso.runtime.staticobject.StaticObject object, @com.oracle.truffle.api.dsl.Cached(value = "create($parameters)") com.oracle.truffle.api.profiles.BranchProfile error) throws com.oracle.truffle.api.interop.UnsupportedMessageException{
            return com.oracle.truffle.espresso.runtime.dispatch.staticobject.BaseInterop.getMetaQualifiedName(object, error);
        }

    }

    abstract static class GetMetaSimpleNameNode extends com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.GetMetaSimpleName {

        @com.oracle.truffle.api.dsl.Specialization
        static java.lang.Object getMetaSimpleName(com.oracle.truffle.espresso.runtime.staticobject.StaticObject object, @com.oracle.truffle.api.dsl.Cached(value = "create($parameters)") com.oracle.truffle.api.profiles.BranchProfile error) throws com.oracle.truffle.api.interop.UnsupportedMessageException{
            return com.oracle.truffle.espresso.runtime.dispatch.staticobject.BaseInterop.getMetaSimpleName(object, error);
        }

    }

    abstract static class IsMetaInstanceNode extends com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.IsMetaInstance {

        @com.oracle.truffle.api.dsl.Specialization
        static boolean isMetaInstance(com.oracle.truffle.espresso.runtime.staticobject.StaticObject object, java.lang.Object instance, @com.oracle.truffle.api.dsl.Cached(value = "create($parameters)") com.oracle.truffle.api.profiles.BranchProfile error) throws com.oracle.truffle.api.interop.UnsupportedMessageException{
            return com.oracle.truffle.espresso.runtime.dispatch.staticobject.BaseInterop.isMetaInstance(object, instance, error);
        }

    }

    abstract static class HasMetaObjectNode extends com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.HasMetaObject {

        @com.oracle.truffle.api.dsl.Specialization
        static boolean hasMetaObject(com.oracle.truffle.espresso.runtime.staticobject.StaticObject object){
            return com.oracle.truffle.espresso.runtime.dispatch.staticobject.BaseInterop.hasMetaObject(object);
        }

    }

    abstract static class GetMetaObjectNode extends com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.GetMetaObject {

        @com.oracle.truffle.api.dsl.Specialization
        static java.lang.Object getMetaObject(com.oracle.truffle.espresso.runtime.staticobject.StaticObject object, @com.oracle.truffle.api.dsl.Cached(value = "create($parameters)") com.oracle.truffle.api.profiles.BranchProfile error) throws com.oracle.truffle.api.interop.UnsupportedMessageException{
            return com.oracle.truffle.espresso.runtime.dispatch.staticobject.BaseInterop.getMetaObject(object, error);
        }

    }

    abstract static class HasMetaParentsNode extends com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.HasMetaParents {

        @com.oracle.truffle.api.dsl.Specialization
        static boolean hasMetaParents(com.oracle.truffle.espresso.runtime.staticobject.StaticObject object){
            return com.oracle.truffle.espresso.runtime.dispatch.staticobject.BaseInterop.hasMetaParents(object);
        }

    }

    abstract static class GetMetaParentsNode extends com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.GetMetaParents {

        @com.oracle.truffle.api.dsl.Specialization
        static java.lang.Object getMetaParents(com.oracle.truffle.espresso.runtime.staticobject.StaticObject object, @com.oracle.truffle.api.dsl.Cached(value = "create($parameters)") com.oracle.truffle.api.profiles.BranchProfile error) throws com.oracle.truffle.api.interop.UnsupportedMessageException{
            return com.oracle.truffle.espresso.runtime.dispatch.staticobject.BaseInterop.getMetaParents(object, error);
        }

    }

    abstract static class IsIdenticalOrUndefinedNode extends com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.IsIdenticalOrUndefined {

        @com.oracle.truffle.api.dsl.Specialization
        static com.oracle.truffle.api.utilities.TriState isIdenticalOrUndefined(com.oracle.truffle.espresso.runtime.staticobject.StaticObject receiver, java.lang.Object other, @com.oracle.truffle.api.dsl.Cached(value = "create($parameters)") com.oracle.truffle.espresso.runtime.dispatch.staticobject.BaseInterop.IsIdenticalOrUndefinedImplNode node){
            return com.oracle.truffle.espresso.runtime.dispatch.staticobject.BaseInterop.isIdenticalOrUndefined(receiver, other, node);
        }

    }

    abstract static class IdentityHashCodeNode extends com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.IdentityHashCode {

        @com.oracle.truffle.api.dsl.Specialization
        static int identityHashCode(com.oracle.truffle.espresso.runtime.staticobject.StaticObject object){
            return com.oracle.truffle.espresso.runtime.dispatch.staticobject.BaseInterop.identityHashCode(object);
        }

    }

    abstract static class HasLanguageNode extends com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.HasLanguage {

        @com.oracle.truffle.api.dsl.Specialization
        static boolean hasLanguage(com.oracle.truffle.espresso.runtime.staticobject.StaticObject object){
            return com.oracle.truffle.espresso.runtime.dispatch.staticobject.BaseInterop.hasLanguage(object);
        }

    }

    abstract static class GetLanguageNode extends com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.GetLanguage {

        @com.oracle.truffle.api.dsl.Specialization
        static java.lang.Class<? extends com.oracle.truffle.api.TruffleLanguage<?>> getLanguage(com.oracle.truffle.espresso.runtime.staticobject.StaticObject object){
            return com.oracle.truffle.espresso.runtime.dispatch.staticobject.BaseInterop.getLanguage(object);
        }

    }

    abstract static class ToDisplayStringNode extends com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.ToDisplayString {

        @com.oracle.truffle.api.dsl.Specialization
        static java.lang.Object toDisplayString(com.oracle.truffle.espresso.runtime.staticobject.StaticObject object, boolean allowSideEffects){
            return com.oracle.truffle.espresso.runtime.dispatch.staticobject.BaseInterop.toDisplayString(object, allowSideEffects);
        }

    }

    @Override
    protected void registerMessages(Class<?> cls) {
        com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessageFactories.register(cls, com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.Message.IsNull, factory,true);
        com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessageFactories.register(cls, com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.Message.IsString, factory,true);
        com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessageFactories.register(cls, com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.Message.AsString, factory,true);
        com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessageFactories.register(cls, com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.Message.IsMetaObject, factory,true);
        com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessageFactories.register(cls, com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.Message.GetMetaQualifiedName, factory,true);
        com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessageFactories.register(cls, com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.Message.GetMetaSimpleName, factory,true);
        com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessageFactories.register(cls, com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.Message.IsMetaInstance, factory,true);
        com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessageFactories.register(cls, com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.Message.HasMetaObject, factory,true);
        com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessageFactories.register(cls, com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.Message.GetMetaObject, factory,true);
        com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessageFactories.register(cls, com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.Message.HasMetaParents, factory,true);
        com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessageFactories.register(cls, com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.Message.GetMetaParents, factory,true);
        com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessageFactories.register(cls, com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.Message.IsIdenticalOrUndefined, factory,true);
        com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessageFactories.register(cls, com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.Message.IdentityHashCode, factory,true);
        com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessageFactories.register(cls, com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.Message.HasLanguage, factory,true);
        com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessageFactories.register(cls, com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.Message.GetLanguage, factory,true);
        com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessageFactories.register(cls, com.oracle.truffle.espresso.runtime.dispatch.messages.InteropMessage.Message.ToDisplayString, factory,true);
    }

}

