// CheckStyle: start generated
package com.oracle.truffle.espresso.runtime.dispatch.staticobject;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.utilities.TriState;
import com.oracle.truffle.espresso.runtime.dispatch.staticobject.BaseInterop.IsIdenticalOrUndefinedImplNode;
import com.oracle.truffle.espresso.runtime.dispatch.staticobject.BaseInteropFactory.IsIdenticalOrUndefinedImplNodeGen;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import java.lang.invoke.VarHandle;
import java.util.Objects;

@GeneratedBy(BaseInterop.class)
@SuppressWarnings("javadoc")
final class BaseInteropGen {

    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    static  {
        LibraryExport.register(BaseInterop.class, new InteropLibraryExports());
    }

    private BaseInteropGen() {
    }

    @GeneratedBy(BaseInterop.class)
    private static final class InteropLibraryExports extends LibraryExport<InteropLibrary> {

        private InteropLibraryExports() {
            super(InteropLibrary.class, StaticObject.class, false, false, 0);
        }

        @Override
        protected InteropLibrary createUncached(Object receiver) {
            assert receiver instanceof StaticObject;
            InteropLibrary uncached = new Uncached(receiver);
            return uncached;
        }

        @Override
        protected InteropLibrary createCached(Object receiver) {
            assert receiver instanceof StaticObject;
            return new Cached(receiver);
        }

        @GeneratedBy(BaseInterop.class)
        private static final class Cached extends InteropLibrary {

            @Child private DynamicDispatchLibrary dynamicDispatch_;
            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link BaseInterop#getMetaQualifiedName}
             *   1: SpecializationActive {@link BaseInterop#getMetaSimpleName}
             *   2: SpecializationActive {@link BaseInterop#isMetaInstance}
             *   3: SpecializationActive {@link BaseInterop#getMetaObject}
             *   4: SpecializationActive {@link BaseInterop#getMetaParents}
             *   5: SpecializationActive {@link BaseInterop#isIdenticalOrUndefined}
             * </pre>
             */
            @CompilationFinal private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link BaseInterop#getMetaQualifiedName}
             *   Parameter: {@link BranchProfile} error</pre>
             */
            @CompilationFinal private BranchProfile error;
            /**
             * Source Info: <pre>
             *   Specialization: {@link BaseInterop#isIdenticalOrUndefined}
             *   Parameter: {@link IsIdenticalOrUndefinedImplNode} node</pre>
             */
            @Child private IsIdenticalOrUndefinedImplNode isIdenticalOrUndefinedNode__isIdenticalOrUndefined_node_;

            protected Cached(Object receiver) {
                this.dynamicDispatch_ = insert(DYNAMIC_DISPATCH_LIBRARY_.create(receiver));
            }

            @Override
            public boolean accepts(Object receiver) {
                return dynamicDispatch_.accepts(receiver) && dynamicDispatch_.dispatch(receiver) == BaseInterop.class;
            }

            @Override
            public boolean isNull(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return BaseInterop.isNull(((StaticObject) dynamicDispatch_.cast(receiver)));
            }

            @Override
            public boolean isString(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return BaseInterop.isString(((StaticObject) dynamicDispatch_.cast(receiver)));
            }

            @Override
            public String asString(Object receiver) throws UnsupportedMessageException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return BaseInterop.asString(((StaticObject) dynamicDispatch_.cast(receiver)));
            }

            @Override
            public boolean isMetaObject(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return BaseInterop.isMetaObject(((StaticObject) dynamicDispatch_.cast(receiver)));
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link BaseInterop#getMetaQualifiedName}
             *     Activation probability: 0.16667
             *     With/without class size: 6/0 bytes
             * </pre>
             */
            @Override
            public Object getMetaQualifiedName(Object arg0Value_) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                StaticObject arg0Value = (StaticObject) dynamicDispatch_.cast(arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b1) != 0 /* is SpecializationActive[BaseInterop.getMetaQualifiedName(StaticObject, BranchProfile)] */) {
                    {
                        BranchProfile error_ = this.error;
                        if (error_ != null) {
                            return BaseInterop.getMetaQualifiedName(arg0Value, error_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return getMetaQualifiedNameNode_AndSpecialize(arg0Value);
            }

            private Object getMetaQualifiedNameNode_AndSpecialize(StaticObject arg0Value) throws UnsupportedMessageException {
                int state_0 = this.state_0_;
                BranchProfile error_;
                BranchProfile error__shared = this.error;
                if (error__shared != null) {
                    error_ = error__shared;
                } else {
                    error_ = (BranchProfile.create());
                    if (error_ == null) {
                        throw new IllegalStateException("Specialization 'getMetaQualifiedName(StaticObject, BranchProfile)' contains a shared cache with name 'error' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.error == null) {
                    VarHandle.storeStoreFence();
                    this.error = error_;
                }
                state_0 = state_0 | 0b1 /* add SpecializationActive[BaseInterop.getMetaQualifiedName(StaticObject, BranchProfile)] */;
                this.state_0_ = state_0;
                return BaseInterop.getMetaQualifiedName(arg0Value, error_);
            }

            @Override
            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if ((state_0 & 0b1) == 0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    return NodeCost.MONOMORPHIC;
                }
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link BaseInterop#getMetaSimpleName}
             *     Activation probability: 0.16667
             *     With/without class size: 6/0 bytes
             * </pre>
             */
            @Override
            public Object getMetaSimpleName(Object arg0Value_) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                StaticObject arg0Value = (StaticObject) dynamicDispatch_.cast(arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[BaseInterop.getMetaSimpleName(StaticObject, BranchProfile)] */) {
                    {
                        BranchProfile error_ = this.error;
                        if (error_ != null) {
                            return BaseInterop.getMetaSimpleName(arg0Value, error_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return getMetaSimpleNameNode_AndSpecialize(arg0Value);
            }

            private Object getMetaSimpleNameNode_AndSpecialize(StaticObject arg0Value) throws UnsupportedMessageException {
                int state_0 = this.state_0_;
                BranchProfile error_;
                BranchProfile error__shared = this.error;
                if (error__shared != null) {
                    error_ = error__shared;
                } else {
                    error_ = (BranchProfile.create());
                    if (error_ == null) {
                        throw new IllegalStateException("Specialization 'getMetaSimpleName(StaticObject, BranchProfile)' contains a shared cache with name 'error' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.error == null) {
                    VarHandle.storeStoreFence();
                    this.error = error_;
                }
                state_0 = state_0 | 0b10 /* add SpecializationActive[BaseInterop.getMetaSimpleName(StaticObject, BranchProfile)] */;
                this.state_0_ = state_0;
                return BaseInterop.getMetaSimpleName(arg0Value, error_);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link BaseInterop#isMetaInstance}
             *     Activation probability: 0.16667
             *     With/without class size: 6/0 bytes
             * </pre>
             */
            @Override
            public boolean isMetaInstance(Object arg0Value_, Object arg1Value) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                StaticObject arg0Value = (StaticObject) dynamicDispatch_.cast(arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[BaseInterop.isMetaInstance(StaticObject, Object, BranchProfile)] */) {
                    {
                        BranchProfile error_ = this.error;
                        if (error_ != null) {
                            return BaseInterop.isMetaInstance(arg0Value, arg1Value, error_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return isMetaInstanceNode_AndSpecialize(arg0Value, arg1Value);
            }

            private boolean isMetaInstanceNode_AndSpecialize(StaticObject arg0Value, Object arg1Value) throws UnsupportedMessageException {
                int state_0 = this.state_0_;
                BranchProfile error_;
                BranchProfile error__shared = this.error;
                if (error__shared != null) {
                    error_ = error__shared;
                } else {
                    error_ = (BranchProfile.create());
                    if (error_ == null) {
                        throw new IllegalStateException("Specialization 'isMetaInstance(StaticObject, Object, BranchProfile)' contains a shared cache with name 'error' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.error == null) {
                    VarHandle.storeStoreFence();
                    this.error = error_;
                }
                state_0 = state_0 | 0b100 /* add SpecializationActive[BaseInterop.isMetaInstance(StaticObject, Object, BranchProfile)] */;
                this.state_0_ = state_0;
                return BaseInterop.isMetaInstance(arg0Value, arg1Value, error_);
            }

            @Override
            public boolean hasMetaObject(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return BaseInterop.hasMetaObject(((StaticObject) dynamicDispatch_.cast(receiver)));
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link BaseInterop#getMetaObject}
             *     Activation probability: 0.16667
             *     With/without class size: 6/0 bytes
             * </pre>
             */
            @Override
            public Object getMetaObject(Object arg0Value_) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                StaticObject arg0Value = (StaticObject) dynamicDispatch_.cast(arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[BaseInterop.getMetaObject(StaticObject, BranchProfile)] */) {
                    {
                        BranchProfile error_ = this.error;
                        if (error_ != null) {
                            return BaseInterop.getMetaObject(arg0Value, error_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return getMetaObjectNode_AndSpecialize(arg0Value);
            }

            private Object getMetaObjectNode_AndSpecialize(StaticObject arg0Value) throws UnsupportedMessageException {
                int state_0 = this.state_0_;
                BranchProfile error_;
                BranchProfile error__shared = this.error;
                if (error__shared != null) {
                    error_ = error__shared;
                } else {
                    error_ = (BranchProfile.create());
                    if (error_ == null) {
                        throw new IllegalStateException("Specialization 'getMetaObject(StaticObject, BranchProfile)' contains a shared cache with name 'error' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.error == null) {
                    VarHandle.storeStoreFence();
                    this.error = error_;
                }
                state_0 = state_0 | 0b1000 /* add SpecializationActive[BaseInterop.getMetaObject(StaticObject, BranchProfile)] */;
                this.state_0_ = state_0;
                return BaseInterop.getMetaObject(arg0Value, error_);
            }

            @Override
            public boolean hasMetaParents(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return BaseInterop.hasMetaParents(((StaticObject) dynamicDispatch_.cast(receiver)));
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link BaseInterop#getMetaParents}
             *     Activation probability: 0.16667
             *     With/without class size: 6/0 bytes
             * </pre>
             */
            @Override
            public Object getMetaParents(Object arg0Value_) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                StaticObject arg0Value = (StaticObject) dynamicDispatch_.cast(arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[BaseInterop.getMetaParents(StaticObject, BranchProfile)] */) {
                    {
                        BranchProfile error_ = this.error;
                        if (error_ != null) {
                            return BaseInterop.getMetaParents(arg0Value, error_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return getMetaParentsNode_AndSpecialize(arg0Value);
            }

            private Object getMetaParentsNode_AndSpecialize(StaticObject arg0Value) throws UnsupportedMessageException {
                int state_0 = this.state_0_;
                BranchProfile error_;
                BranchProfile error__shared = this.error;
                if (error__shared != null) {
                    error_ = error__shared;
                } else {
                    error_ = (BranchProfile.create());
                    if (error_ == null) {
                        throw new IllegalStateException("Specialization 'getMetaParents(StaticObject, BranchProfile)' contains a shared cache with name 'error' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.error == null) {
                    VarHandle.storeStoreFence();
                    this.error = error_;
                }
                state_0 = state_0 | 0b10000 /* add SpecializationActive[BaseInterop.getMetaParents(StaticObject, BranchProfile)] */;
                this.state_0_ = state_0;
                return BaseInterop.getMetaParents(arg0Value, error_);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link BaseInterop#isIdenticalOrUndefined}
             *     Activation probability: 0.16667
             *     With/without class size: 7/4 bytes
             * </pre>
             */
            @Override
            protected TriState isIdenticalOrUndefined(Object arg0Value_, Object arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                StaticObject arg0Value = (StaticObject) dynamicDispatch_.cast(arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b100000) != 0 /* is SpecializationActive[BaseInterop.isIdenticalOrUndefined(StaticObject, Object, IsIdenticalOrUndefinedImplNode)] */) {
                    {
                        IsIdenticalOrUndefinedImplNode node__ = this.isIdenticalOrUndefinedNode__isIdenticalOrUndefined_node_;
                        if (node__ != null) {
                            return BaseInterop.isIdenticalOrUndefined(arg0Value, arg1Value, node__);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return isIdenticalOrUndefinedNode_AndSpecialize(arg0Value, arg1Value);
            }

            private TriState isIdenticalOrUndefinedNode_AndSpecialize(StaticObject arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                IsIdenticalOrUndefinedImplNode node__ = this.insert((IsIdenticalOrUndefinedImplNodeGen.create()));
                Objects.requireNonNull(node__, "Specialization 'isIdenticalOrUndefined(StaticObject, Object, IsIdenticalOrUndefinedImplNode)' cache 'node' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.isIdenticalOrUndefinedNode__isIdenticalOrUndefined_node_ = node__;
                state_0 = state_0 | 0b100000 /* add SpecializationActive[BaseInterop.isIdenticalOrUndefined(StaticObject, Object, IsIdenticalOrUndefinedImplNode)] */;
                this.state_0_ = state_0;
                return BaseInterop.isIdenticalOrUndefined(arg0Value, arg1Value, node__);
            }

            @Override
            public int identityHashCode(Object receiver) throws UnsupportedMessageException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return BaseInterop.identityHashCode(((StaticObject) dynamicDispatch_.cast(receiver)));
            }

            @Override
            public boolean hasLanguage(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return BaseInterop.hasLanguage(((StaticObject) dynamicDispatch_.cast(receiver)));
            }

            @Override
            public Class<? extends TruffleLanguage<?>> getLanguage(Object receiver) throws UnsupportedMessageException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return BaseInterop.getLanguage(((StaticObject) dynamicDispatch_.cast(receiver)));
            }

            @Override
            public Object toDisplayString(Object receiver, boolean allowSideEffects) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return BaseInterop.toDisplayString(((StaticObject) dynamicDispatch_.cast(receiver)), allowSideEffects);
            }

        }
        @GeneratedBy(BaseInterop.class)
        @DenyReplace
        private static final class Uncached extends InteropLibrary {

            @Child private DynamicDispatchLibrary dynamicDispatch_;

            protected Uncached(Object receiver) {
                this.dynamicDispatch_ = DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver);
            }

            @Override
            @TruffleBoundary
            public boolean accepts(Object receiver) {
                return dynamicDispatch_.accepts(receiver) && dynamicDispatch_.dispatch(receiver) == BaseInterop.class;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @TruffleBoundary
            @Override
            public boolean isNull(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return BaseInterop.isNull(((StaticObject) receiver) );
            }

            @TruffleBoundary
            @Override
            public boolean isString(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return BaseInterop.isString(((StaticObject) receiver) );
            }

            @TruffleBoundary
            @Override
            public String asString(Object receiver) throws UnsupportedMessageException {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return BaseInterop.asString(((StaticObject) receiver) );
            }

            @TruffleBoundary
            @Override
            public boolean isMetaObject(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return BaseInterop.isMetaObject(((StaticObject) receiver) );
            }

            @TruffleBoundary
            @Override
            public Object getMetaQualifiedName(Object arg0Value_) throws UnsupportedMessageException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                StaticObject arg0Value = ((StaticObject) arg0Value_);
                return BaseInterop.getMetaQualifiedName(arg0Value, (BranchProfile.getUncached()));
            }

            @TruffleBoundary
            @Override
            public Object getMetaSimpleName(Object arg0Value_) throws UnsupportedMessageException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                StaticObject arg0Value = ((StaticObject) arg0Value_);
                return BaseInterop.getMetaSimpleName(arg0Value, (BranchProfile.getUncached()));
            }

            @TruffleBoundary
            @Override
            public boolean isMetaInstance(Object arg0Value_, Object arg1Value) throws UnsupportedMessageException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                StaticObject arg0Value = ((StaticObject) arg0Value_);
                return BaseInterop.isMetaInstance(arg0Value, arg1Value, (BranchProfile.getUncached()));
            }

            @TruffleBoundary
            @Override
            public boolean hasMetaObject(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return BaseInterop.hasMetaObject(((StaticObject) receiver) );
            }

            @TruffleBoundary
            @Override
            public Object getMetaObject(Object arg0Value_) throws UnsupportedMessageException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                StaticObject arg0Value = ((StaticObject) arg0Value_);
                return BaseInterop.getMetaObject(arg0Value, (BranchProfile.getUncached()));
            }

            @TruffleBoundary
            @Override
            public boolean hasMetaParents(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return BaseInterop.hasMetaParents(((StaticObject) receiver) );
            }

            @TruffleBoundary
            @Override
            public Object getMetaParents(Object arg0Value_) throws UnsupportedMessageException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                StaticObject arg0Value = ((StaticObject) arg0Value_);
                return BaseInterop.getMetaParents(arg0Value, (BranchProfile.getUncached()));
            }

            @TruffleBoundary
            @Override
            public TriState isIdenticalOrUndefined(Object arg0Value_, Object arg1Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                StaticObject arg0Value = ((StaticObject) arg0Value_);
                return BaseInterop.isIdenticalOrUndefined(arg0Value, arg1Value, (IsIdenticalOrUndefinedImplNodeGen.getUncached()));
            }

            @TruffleBoundary
            @Override
            public int identityHashCode(Object receiver) throws UnsupportedMessageException {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return BaseInterop.identityHashCode(((StaticObject) receiver) );
            }

            @TruffleBoundary
            @Override
            public boolean hasLanguage(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return BaseInterop.hasLanguage(((StaticObject) receiver) );
            }

            @TruffleBoundary
            @Override
            public Class<? extends TruffleLanguage<?>> getLanguage(Object receiver) throws UnsupportedMessageException {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return BaseInterop.getLanguage(((StaticObject) receiver) );
            }

            @TruffleBoundary
            @Override
            public Object toDisplayString(Object receiver, boolean allowSideEffects) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return BaseInterop.toDisplayString(((StaticObject) receiver) , allowSideEffects);
            }

        }
    }
}
