// CheckStyle: start generated
package com.oracle.truffle.espresso.nodes.quick;

import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.ProbeNode;
import com.oracle.truffle.api.instrumentation.InstrumentableNode.WrapperNode;
import com.oracle.truffle.api.nodes.NodeCost;

@GeneratedBy(BaseQuickNode.class)
final class BaseQuickNodeWrapper extends BaseQuickNode implements WrapperNode {

    @Child private BaseQuickNode delegateNode;
    @Child private ProbeNode probeNode;

    BaseQuickNodeWrapper(BaseQuickNode delegateNode, ProbeNode probeNode) {
        this.delegateNode = delegateNode;
        this.probeNode = probeNode;
    }

    @Override
    public BaseQuickNode getDelegateNode() {
        return delegateNode;
    }

    @Override
    public ProbeNode getProbeNode() {
        return probeNode;
    }

    @Override
    public NodeCost getCost() {
        return NodeCost.NONE;
    }

    @Override
    public int execute(VirtualFrame frame) {
        int returnValue;
        for (;;) {
            boolean wasOnReturnExecuted = false;
            try {
                probeNode.onEnter(frame);
                returnValue = delegateNode.execute(frame);
                wasOnReturnExecuted = true;
                probeNode.onReturnValue(frame, returnValue);
                break;
            } catch (Throwable t) {
                Object result = probeNode.onReturnExceptionalOrUnwind(frame, t, wasOnReturnExecuted);
                if (result == ProbeNode.UNWIND_ACTION_REENTER) {
                    continue;
                } else if (result != null) {
                    returnValue = (int) result;
                    break;
                }
                throw t;
            }
        }
        return returnValue;
    }

    @Override
    public int getBci(Frame frame) {
        return this.delegateNode.getBci(frame);
    }

}
