// CheckStyle: start generated
package com.oracle.truffle.espresso.nodes.interop;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.dsl.InlineSupport.ReferenceField;
import com.oracle.truffle.api.dsl.InlineSupport.UnsafeAccessedField;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.espresso.impl.ArrayKlass;
import com.oracle.truffle.espresso.impl.Klass;
import com.oracle.truffle.espresso.impl.Method;
import com.oracle.truffle.espresso.impl.ObjectKlass;
import com.oracle.truffle.espresso.impl.PrimitiveKlass;
import com.oracle.truffle.espresso.impl.ObjectKlass.KlassVersion;
import java.lang.invoke.MethodHandles;

/**
 * Debug Info: <pre>
 *   Specialization {@link LookupVirtualMethodNode#doPrimitive}
 *     Activation probability: 0.32000
 *     With/without class size: 7/0 bytes
 *   Specialization {@link LookupVirtualMethodNode#doArrayCached}
 *     Activation probability: 0.26000
 *     With/without class size: 11/12 bytes
 *   Specialization {@link LookupVirtualMethodNode#doArrayGeneric}
 *     Activation probability: 0.20000
 *     With/without class size: 6/0 bytes
 *   Specialization {@link LookupVirtualMethodNode#doCached}
 *     Activation probability: 0.14000
 *     With/without class size: 8/16 bytes
 *   Specialization {@link LookupVirtualMethodNode#doGeneric}
 *     Activation probability: 0.08000
 *     With/without class size: 4/0 bytes
 * </pre>
 */
@GeneratedBy(LookupVirtualMethodNode.class)
@SuppressWarnings("javadoc")
public final class LookupVirtualMethodNodeGen extends LookupVirtualMethodNode {

    static final ReferenceField<ArrayCachedData> ARRAY_CACHED_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "arrayCached_cache", ArrayCachedData.class);
    static final ReferenceField<CachedData> CACHED_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "cached_cache", CachedData.class);
    private static final Uncached UNCACHED = new Uncached();

    /**
     * State Info: <pre>
     *   0: SpecializationActive {@link LookupVirtualMethodNode#doPrimitive}
     *   1: SpecializationActive {@link LookupVirtualMethodNode#doArrayCached}
     *   2: SpecializationActive {@link LookupVirtualMethodNode#doArrayGeneric}
     *   3: SpecializationActive {@link LookupVirtualMethodNode#doCached}
     *   4: SpecializationActive {@link LookupVirtualMethodNode#doGeneric}
     * </pre>
     */
    @CompilationFinal private int state_0_;
    @UnsafeAccessedField @CompilationFinal private ArrayCachedData arrayCached_cache;
    @UnsafeAccessedField @CompilationFinal private CachedData cached_cache;

    private LookupVirtualMethodNodeGen() {
    }

    @ExplodeLoop
    @Override
    public Method[] execute(Klass arg0Value, String arg1Value, int arg2Value) throws ArityException {
        int state_0 = this.state_0_;
        if (state_0 != 0 /* is SpecializationActive[LookupVirtualMethodNode.doPrimitive(PrimitiveKlass, String, int)] || SpecializationActive[LookupVirtualMethodNode.doArrayCached(ArrayKlass, String, int, String, int, Method[])] || SpecializationActive[LookupVirtualMethodNode.doArrayGeneric(ArrayKlass, String, int)] || SpecializationActive[LookupVirtualMethodNode.doCached(ObjectKlass, String, int, KlassVersion, String, int, Method[])] || SpecializationActive[LookupVirtualMethodNode.doGeneric(ObjectKlass, String, int)] */) {
            if ((state_0 & 0b1) != 0 /* is SpecializationActive[LookupVirtualMethodNode.doPrimitive(PrimitiveKlass, String, int)] */ && arg0Value instanceof PrimitiveKlass) {
                PrimitiveKlass arg0Value_ = (PrimitiveKlass) arg0Value;
                return doPrimitive(arg0Value_, arg1Value, arg2Value);
            }
            if ((state_0 & 0b110) != 0 /* is SpecializationActive[LookupVirtualMethodNode.doArrayCached(ArrayKlass, String, int, String, int, Method[])] || SpecializationActive[LookupVirtualMethodNode.doArrayGeneric(ArrayKlass, String, int)] */ && arg0Value instanceof ArrayKlass) {
                ArrayKlass arg0Value_ = (ArrayKlass) arg0Value;
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LookupVirtualMethodNode.doArrayCached(ArrayKlass, String, int, String, int, Method[])] */) {
                    ArrayCachedData s1_ = this.arrayCached_cache;
                    while (s1_ != null) {
                        if ((arg1Value.equals(s1_.cachedMethodName_)) && (arg2Value == s1_.cachedArity_)) {
                            return doArrayCached(arg0Value_, arg1Value, arg2Value, s1_.cachedMethodName_, s1_.cachedArity_, s1_.methods_);
                        }
                        s1_ = s1_.next_;
                    }
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[LookupVirtualMethodNode.doArrayGeneric(ArrayKlass, String, int)] */) {
                    return doArrayGeneric(arg0Value_, arg1Value, arg2Value);
                }
            }
            if ((state_0 & 0b11000) != 0 /* is SpecializationActive[LookupVirtualMethodNode.doCached(ObjectKlass, String, int, KlassVersion, String, int, Method[])] || SpecializationActive[LookupVirtualMethodNode.doGeneric(ObjectKlass, String, int)] */ && arg0Value instanceof ObjectKlass) {
                ObjectKlass arg0Value_ = (ObjectKlass) arg0Value;
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LookupVirtualMethodNode.doCached(ObjectKlass, String, int, KlassVersion, String, int, Method[])] */) {
                    CachedData s3_ = this.cached_cache;
                    while (s3_ != null) {
                        if (!Assumption.isValidAssumption(s3_.assumption0_)) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            removeCached_(s3_);
                            return executeAndSpecialize(arg0Value_, arg1Value, arg2Value);
                        }
                        if ((arg0Value_.equals(s3_.cachedKlass_.getKlass())) && (arg1Value.equals(s3_.cachedMethodName_)) && (arg2Value == s3_.cachedArity_)) {
                            return doCached(arg0Value_, arg1Value, arg2Value, s3_.cachedKlass_, s3_.cachedMethodName_, s3_.cachedArity_, s3_.methods_);
                        }
                        s3_ = s3_.next_;
                    }
                }
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LookupVirtualMethodNode.doGeneric(ObjectKlass, String, int)] */) {
                    return doGeneric(arg0Value_, arg1Value, arg2Value);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(arg0Value, arg1Value, arg2Value);
    }

    private Method[] executeAndSpecialize(Klass arg0Value, String arg1Value, int arg2Value) throws ArityException {
        int state_0 = this.state_0_;
        if (arg0Value instanceof PrimitiveKlass) {
            PrimitiveKlass arg0Value_ = (PrimitiveKlass) arg0Value;
            state_0 = state_0 | 0b1 /* add SpecializationActive[LookupVirtualMethodNode.doPrimitive(PrimitiveKlass, String, int)] */;
            this.state_0_ = state_0;
            return doPrimitive(arg0Value_, arg1Value, arg2Value);
        }
        if (arg0Value instanceof ArrayKlass) {
            ArrayKlass arg0Value_ = (ArrayKlass) arg0Value;
            if (((state_0 & 0b100)) == 0 /* is-not SpecializationActive[LookupVirtualMethodNode.doArrayGeneric(ArrayKlass, String, int)] */) {
                while (true) {
                    int count1_ = 0;
                    ArrayCachedData s1_ = ARRAY_CACHED_CACHE_UPDATER.getVolatile(this);
                    ArrayCachedData s1_original = s1_;
                    while (s1_ != null) {
                        if ((arg1Value.equals(s1_.cachedMethodName_)) && (arg2Value == s1_.cachedArity_)) {
                            break;
                        }
                        count1_++;
                        s1_ = s1_.next_;
                    }
                    if (s1_ == null) {
                        // assert (arg1Value.equals(s1_.cachedMethodName_));
                        // assert (arg2Value == s1_.cachedArity_);
                        if (count1_ < (LookupVirtualMethodNode.LIMIT)) {
                            s1_ = new ArrayCachedData(s1_original);
                            s1_.cachedMethodName_ = (arg1Value);
                            s1_.cachedArity_ = (arg2Value);
                            s1_.methods_ = (doGeneric(LookupVirtualMethodNode.getJLObject(arg0Value_.getMeta()), arg1Value, arg2Value));
                            if (!ARRAY_CACHED_CACHE_UPDATER.compareAndSet(this, s1_original, s1_)) {
                                continue;
                            }
                            state_0 = state_0 | 0b10 /* add SpecializationActive[LookupVirtualMethodNode.doArrayCached(ArrayKlass, String, int, String, int, Method[])] */;
                            this.state_0_ = state_0;
                        }
                    }
                    if (s1_ != null) {
                        return doArrayCached(arg0Value_, arg1Value, arg2Value, s1_.cachedMethodName_, s1_.cachedArity_, s1_.methods_);
                    }
                    break;
                }
            }
            this.arrayCached_cache = null;
            state_0 = state_0 & 0xfffffffd /* remove SpecializationActive[LookupVirtualMethodNode.doArrayCached(ArrayKlass, String, int, String, int, Method[])] */;
            state_0 = state_0 | 0b100 /* add SpecializationActive[LookupVirtualMethodNode.doArrayGeneric(ArrayKlass, String, int)] */;
            this.state_0_ = state_0;
            return doArrayGeneric(arg0Value_, arg1Value, arg2Value);
        }
        if (arg0Value instanceof ObjectKlass) {
            ObjectKlass arg0Value_ = (ObjectKlass) arg0Value;
            if (((state_0 & 0b10000)) == 0 /* is-not SpecializationActive[LookupVirtualMethodNode.doGeneric(ObjectKlass, String, int)] */) {
                while (true) {
                    int count3_ = 0;
                    CachedData s3_ = CACHED_CACHE_UPDATER.getVolatile(this);
                    CachedData s3_original = s3_;
                    while (s3_ != null) {
                        if ((arg0Value_.equals(s3_.cachedKlass_.getKlass())) && (arg1Value.equals(s3_.cachedMethodName_)) && (arg2Value == s3_.cachedArity_) && Assumption.isValidAssumption(s3_.assumption0_)) {
                            break;
                        }
                        count3_++;
                        s3_ = s3_.next_;
                    }
                    if (s3_ == null) {
                        {
                            KlassVersion cachedKlass__ = (arg0Value_.getKlassVersion());
                            if ((arg0Value_.equals(cachedKlass__.getKlass()))) {
                                // assert (arg1Value.equals(s3_.cachedMethodName_));
                                // assert (arg2Value == s3_.cachedArity_);
                                Assumption assumption0 = (cachedKlass__.getAssumption());
                                if (Assumption.isValidAssumption(assumption0)) {
                                    if (count3_ < (LookupVirtualMethodNode.LIMIT)) {
                                        s3_ = new CachedData(s3_original);
                                        s3_.cachedKlass_ = cachedKlass__;
                                        s3_.cachedMethodName_ = (arg1Value);
                                        s3_.cachedArity_ = (arg2Value);
                                        s3_.methods_ = (doGeneric(cachedKlass__.getKlass(), arg1Value, arg2Value));
                                        s3_.assumption0_ = assumption0;
                                        if (!CACHED_CACHE_UPDATER.compareAndSet(this, s3_original, s3_)) {
                                            continue;
                                        }
                                        state_0 = state_0 | 0b1000 /* add SpecializationActive[LookupVirtualMethodNode.doCached(ObjectKlass, String, int, KlassVersion, String, int, Method[])] */;
                                        this.state_0_ = state_0;
                                    }
                                }
                            }
                        }
                    }
                    if (s3_ != null) {
                        return doCached(arg0Value_, arg1Value, arg2Value, s3_.cachedKlass_, s3_.cachedMethodName_, s3_.cachedArity_, s3_.methods_);
                    }
                    break;
                }
            }
            this.cached_cache = null;
            state_0 = state_0 & 0xfffffff7 /* remove SpecializationActive[LookupVirtualMethodNode.doCached(ObjectKlass, String, int, KlassVersion, String, int, Method[])] */;
            state_0 = state_0 | 0b10000 /* add SpecializationActive[LookupVirtualMethodNode.doGeneric(ObjectKlass, String, int)] */;
            this.state_0_ = state_0;
            return doGeneric(arg0Value_, arg1Value, arg2Value);
        }
        throw new UnsupportedSpecializationException(this, new Node[] {null, null, null}, arg0Value, arg1Value, arg2Value);
    }

    @Override
    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if (state_0 == 0) {
            return NodeCost.UNINITIALIZED;
        } else {
            if ((state_0 & (state_0 - 1)) == 0 /* is-single  */) {
                ArrayCachedData s1_ = this.arrayCached_cache;
                CachedData s3_ = this.cached_cache;
                if ((s1_ == null || s1_.next_ == null) && (s3_ == null || s3_.next_ == null)) {
                    return NodeCost.MONOMORPHIC;
                }
            }
        }
        return NodeCost.POLYMORPHIC;
    }

    void removeCached_(CachedData s3_) {
        while (true) {
            CachedData cur = this.cached_cache;
            CachedData original = cur;
            CachedData update = null;
            while (cur != null) {
                if (cur == s3_) {
                    if (cur == original) {
                        update = cur.next_;
                    } else {
                        update = original.remove(s3_);
                    }
                    break;
                }
                cur = cur.next_;
            }
            if (cur != null && !CACHED_CACHE_UPDATER.compareAndSet(this, original, update)) {
                continue;
            }
            break;
        }
    }

    @NeverDefault
    public static LookupVirtualMethodNode create() {
        return new LookupVirtualMethodNodeGen();
    }

    @NeverDefault
    public static LookupVirtualMethodNode getUncached() {
        return LookupVirtualMethodNodeGen.UNCACHED;
    }

    @GeneratedBy(LookupVirtualMethodNode.class)
    @DenyReplace
    private static final class ArrayCachedData implements SpecializationDataNode {

        @CompilationFinal final ArrayCachedData next_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LookupVirtualMethodNode#doArrayCached}
         *   Parameter: {@link String} cachedMethodName</pre>
         */
        @CompilationFinal String cachedMethodName_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LookupVirtualMethodNode#doArrayCached}
         *   Parameter: int cachedArity</pre>
         */
        @CompilationFinal int cachedArity_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LookupVirtualMethodNode#doArrayCached}
         *   Parameter: {@link Method} methods</pre>
         */
        @CompilationFinal(dimensions = 0) Method[] methods_;

        ArrayCachedData(ArrayCachedData next_) {
            this.next_ = next_;
        }

    }
    @GeneratedBy(LookupVirtualMethodNode.class)
    @DenyReplace
    private static final class CachedData implements SpecializationDataNode {

        @CompilationFinal final CachedData next_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LookupVirtualMethodNode#doCached}
         *   Parameter: {@link KlassVersion} cachedKlass</pre>
         */
        @CompilationFinal KlassVersion cachedKlass_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LookupVirtualMethodNode#doCached}
         *   Parameter: {@link String} cachedMethodName</pre>
         */
        @CompilationFinal String cachedMethodName_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LookupVirtualMethodNode#doCached}
         *   Parameter: int cachedArity</pre>
         */
        @CompilationFinal int cachedArity_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LookupVirtualMethodNode#doCached}
         *   Parameter: {@link Method} methods</pre>
         */
        @CompilationFinal(dimensions = 0) Method[] methods_;
        @CompilationFinal Assumption assumption0_;

        CachedData(CachedData next_) {
            this.next_ = next_;
        }

        CachedData remove(CachedData search) {
            CachedData newNext = this.next_;
            if (newNext != null) {
                if (search == newNext) {
                    newNext = newNext.next_;
                } else {
                    newNext = newNext.remove(search);
                }
            }
            CachedData copy = new CachedData(newNext);
            copy.cachedKlass_ = this.cachedKlass_;
            copy.cachedMethodName_ = this.cachedMethodName_;
            copy.cachedArity_ = this.cachedArity_;
            copy.methods_ = this.methods_;
            copy.assumption0_ = this.assumption0_;
            return copy;
        }

    }
    @GeneratedBy(LookupVirtualMethodNode.class)
    @DenyReplace
    private static final class Uncached extends LookupVirtualMethodNode {

        @TruffleBoundary
        @Override
        public Method[] execute(Klass arg0Value, String arg1Value, int arg2Value) throws ArityException {
            if (arg0Value instanceof PrimitiveKlass) {
                PrimitiveKlass arg0Value_ = (PrimitiveKlass) arg0Value;
                return doPrimitive(arg0Value_, arg1Value, arg2Value);
            }
            if (arg0Value instanceof ArrayKlass) {
                ArrayKlass arg0Value_ = (ArrayKlass) arg0Value;
                return doArrayGeneric(arg0Value_, arg1Value, arg2Value);
            }
            if (arg0Value instanceof ObjectKlass) {
                ObjectKlass arg0Value_ = (ObjectKlass) arg0Value;
                return doGeneric(arg0Value_, arg1Value, arg2Value);
            }
            throw new UnsupportedSpecializationException(this, new Node[] {null, null, null}, arg0Value, arg1Value, arg2Value);
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        @Override
        public boolean isAdoptable() {
            return false;
        }

    }
}
