// CheckStyle: start generated
package com.oracle.truffle.espresso.nodes.bytecodes;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.espresso.EspressoLanguage;
import com.oracle.truffle.espresso.meta.Meta;
import com.oracle.truffle.espresso.nodes.quick.interop.Utils;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import java.lang.invoke.VarHandle;
import java.util.Objects;

/**
 * Debug Info: <pre>
 *   Specialization {@link ByteArrayStore#doWithNullCheck}
 *     Activation probability: 1.00000
 *     With/without class size: 28/8 bytes
 * </pre>
 */
@GeneratedBy(ByteArrayStore.class)
@SuppressWarnings("javadoc")
public final class ByteArrayStoreNodeGen extends ByteArrayStore {

    private static final Uncached UNCACHED = new Uncached();
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    /**
     * State Info: <pre>
     *   0: SpecializationActive {@link ByteArrayStore#doWithNullCheck}
     * </pre>
     */
    @CompilationFinal private int state_0_;
    /**
     * Source Info: <pre>
     *   Specialization: {@link ByteArrayStore#doWithNullCheck}
     *   Parameter: {@link NullCheck} nullCheck</pre>
     */
    @Child private NullCheck nullCheck_;
    /**
     * Source Info: <pre>
     *   Specialization: {@link ByteArrayStore#doWithNullCheck}
     *   Parameter: {@link WithoutNullCheck} byteArrayStore</pre>
     */
    @Child private WithoutNullCheck byteArrayStore_;

    private ByteArrayStoreNodeGen() {
    }

    @Override
    public void execute(StaticObject arg0Value, int arg1Value, byte arg2Value) {
        int state_0 = this.state_0_;
        if (state_0 != 0 /* is SpecializationActive[ByteArrayStore.doWithNullCheck(StaticObject, int, byte, NullCheck, WithoutNullCheck)] */) {
            {
                NullCheck nullCheck__ = this.nullCheck_;
                if (nullCheck__ != null) {
                    WithoutNullCheck byteArrayStore__ = this.byteArrayStore_;
                    if (byteArrayStore__ != null) {
                        doWithNullCheck(arg0Value, arg1Value, arg2Value, nullCheck__, byteArrayStore__);
                        return;
                    }
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        executeAndSpecialize(arg0Value, arg1Value, arg2Value);
        return;
    }

    private void executeAndSpecialize(StaticObject arg0Value, int arg1Value, byte arg2Value) {
        int state_0 = this.state_0_;
        NullCheck nullCheck__ = this.insert((NullCheckNodeGen.create()));
        Objects.requireNonNull(nullCheck__, "Specialization 'doWithNullCheck(StaticObject, int, byte, NullCheck, WithoutNullCheck)' cache 'nullCheck' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
        VarHandle.storeStoreFence();
        this.nullCheck_ = nullCheck__;
        WithoutNullCheck byteArrayStore__ = this.insert((WithoutNullCheckNodeGen.create()));
        Objects.requireNonNull(byteArrayStore__, "Specialization 'doWithNullCheck(StaticObject, int, byte, NullCheck, WithoutNullCheck)' cache 'byteArrayStore' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
        VarHandle.storeStoreFence();
        this.byteArrayStore_ = byteArrayStore__;
        state_0 = state_0 | 0b1 /* add SpecializationActive[ByteArrayStore.doWithNullCheck(StaticObject, int, byte, NullCheck, WithoutNullCheck)] */;
        this.state_0_ = state_0;
        doWithNullCheck(arg0Value, arg1Value, arg2Value, nullCheck__, byteArrayStore__);
        return;
    }

    @Override
    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if (state_0 == 0) {
            return NodeCost.UNINITIALIZED;
        } else {
            return NodeCost.MONOMORPHIC;
        }
    }

    @NeverDefault
    public static ByteArrayStore create() {
        return new ByteArrayStoreNodeGen();
    }

    @NeverDefault
    public static ByteArrayStore getUncached() {
        return ByteArrayStoreNodeGen.UNCACHED;
    }

    @GeneratedBy(ByteArrayStore.class)
    @DenyReplace
    private static final class Uncached extends ByteArrayStore {

        @TruffleBoundary
        @Override
        public void execute(StaticObject arg0Value, int arg1Value, byte arg2Value) {
            doWithNullCheck(arg0Value, arg1Value, arg2Value, (NullCheckNodeGen.getUncached()), (WithoutNullCheckNodeGen.getUncached()));
            return;
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        @Override
        public boolean isAdoptable() {
            return false;
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link WithoutNullCheck#doEspresso}
     *     Activation probability: 0.48333
     *     With/without class size: 9/0 bytes
     *   Specialization {@link WithoutNullCheck#doBufferLike}
     *     Activation probability: 0.33333
     *     With/without class size: 13/12 bytes
     *   Specialization {@link WithoutNullCheck#doArrayLike}
     *     Activation probability: 0.18333
     *     With/without class size: 9/12 bytes
     * </pre>
     */
    @GeneratedBy(WithoutNullCheck.class)
    @SuppressWarnings("javadoc")
    public static final class WithoutNullCheckNodeGen extends WithoutNullCheck {

        private static final Uncached UNCACHED = new Uncached();

        /**
         * State Info: <pre>
         *   0: SpecializationActive {@link WithoutNullCheck#doEspresso}
         *   1: SpecializationActive {@link WithoutNullCheck#doBufferLike}
         *   2: SpecializationActive {@link WithoutNullCheck#doArrayLike}
         * </pre>
         */
        @CompilationFinal private int state_0_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link WithoutNullCheck#doBufferLike}
         *   Parameter: {@link InteropLibrary} interop</pre>
         */
        @Child private InteropLibrary bufferLike_interop_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link WithoutNullCheck#doBufferLike}
         *   Parameter: {@link BranchProfile} outOfBoundsProfile</pre>
         */
        @CompilationFinal private BranchProfile bufferLike_outOfBoundsProfile_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link WithoutNullCheck#doBufferLike}
         *   Parameter: {@link BranchProfile} readOnlyProfile</pre>
         */
        @CompilationFinal private BranchProfile bufferLike_readOnlyProfile_;
        @Child private ArrayLikeData arrayLike_cache;

        private WithoutNullCheckNodeGen() {
        }

        @Override
        public void execute(StaticObject arg0Value, int arg1Value, byte arg2Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is SpecializationActive[ByteArrayStore.WithoutNullCheck.doEspresso(StaticObject, int, byte)] || SpecializationActive[ByteArrayStore.WithoutNullCheck.doBufferLike(StaticObject, int, byte, EspressoLanguage, Meta, InteropLibrary, BranchProfile, BranchProfile)] || SpecializationActive[ByteArrayStore.WithoutNullCheck.doArrayLike(StaticObject, int, byte, InteropLibrary, EspressoLanguage, Meta, BranchProfile, ConditionProfile)] */) {
                if ((state_0 & 0b1) != 0 /* is SpecializationActive[ByteArrayStore.WithoutNullCheck.doEspresso(StaticObject, int, byte)] */) {
                    if ((arg0Value.isEspressoObject())) {
                        doEspresso(arg0Value, arg1Value, arg2Value);
                        return;
                    }
                }
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[ByteArrayStore.WithoutNullCheck.doBufferLike(StaticObject, int, byte, EspressoLanguage, Meta, InteropLibrary, BranchProfile, BranchProfile)] */) {
                    {
                        InteropLibrary interop__ = this.bufferLike_interop_;
                        if (interop__ != null) {
                            BranchProfile outOfBoundsProfile__ = this.bufferLike_outOfBoundsProfile_;
                            if (outOfBoundsProfile__ != null) {
                                BranchProfile readOnlyProfile__ = this.bufferLike_readOnlyProfile_;
                                if (readOnlyProfile__ != null) {
                                    if ((arg0Value.isForeignObject())) {
                                        EspressoLanguage language__ = (getLanguage());
                                        Meta meta__ = (getMeta());
                                        if ((Utils.isBufferLikeByteArray(language__, meta__, interop__, arg0Value))) {
                                            doBufferLike(arg0Value, arg1Value, arg2Value, language__, meta__, interop__, outOfBoundsProfile__, readOnlyProfile__);
                                            return;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[ByteArrayStore.WithoutNullCheck.doArrayLike(StaticObject, int, byte, InteropLibrary, EspressoLanguage, Meta, BranchProfile, ConditionProfile)] */) {
                    ArrayLikeData s2_ = this.arrayLike_cache;
                    if (s2_ != null) {
                        if ((arg0Value.isForeignObject())) {
                            EspressoLanguage language__1 = (getLanguage());
                            Meta meta__1 = (getMeta());
                            if ((!(Utils.isBufferLikeByteArray(language__1, meta__1, s2_.interop_, arg0Value))) && (Utils.isArrayLike(s2_.interop_, arg0Value.rawForeignObject(language__1)))) {
                                doArrayLike(arg0Value, arg1Value, arg2Value, s2_.interop_, language__1, meta__1, s2_.exceptionProfile_, s2_.isByteArrayProfile_);
                                return;
                            }
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            executeAndSpecialize(arg0Value, arg1Value, arg2Value);
            return;
        }

        @SuppressWarnings("unused")
        private void executeAndSpecialize(StaticObject arg0Value, int arg1Value, byte arg2Value) {
            int state_0 = this.state_0_;
            if ((arg0Value.isEspressoObject())) {
                state_0 = state_0 | 0b1 /* add SpecializationActive[ByteArrayStore.WithoutNullCheck.doEspresso(StaticObject, int, byte)] */;
                this.state_0_ = state_0;
                doEspresso(arg0Value, arg1Value, arg2Value);
                return;
            }
            {
                Meta meta__ = null;
                EspressoLanguage language__ = null;
                if ((arg0Value.isForeignObject())) {
                    language__ = (getLanguage());
                    meta__ = (getMeta());
                    InteropLibrary interop__ = this.insert((INTEROP_LIBRARY_.createDispatched(WithoutNullCheck.LIMIT)));
                    if ((Utils.isBufferLikeByteArray(language__, meta__, interop__, arg0Value))) {
                        Objects.requireNonNull(this.insert(interop__), "Specialization 'doBufferLike(StaticObject, int, byte, EspressoLanguage, Meta, InteropLibrary, BranchProfile, BranchProfile)' cache 'interop' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                        VarHandle.storeStoreFence();
                        this.bufferLike_interop_ = interop__;
                        BranchProfile outOfBoundsProfile__ = (BranchProfile.create());
                        Objects.requireNonNull(outOfBoundsProfile__, "Specialization 'doBufferLike(StaticObject, int, byte, EspressoLanguage, Meta, InteropLibrary, BranchProfile, BranchProfile)' cache 'outOfBoundsProfile' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                        VarHandle.storeStoreFence();
                        this.bufferLike_outOfBoundsProfile_ = outOfBoundsProfile__;
                        BranchProfile readOnlyProfile__ = (BranchProfile.create());
                        Objects.requireNonNull(readOnlyProfile__, "Specialization 'doBufferLike(StaticObject, int, byte, EspressoLanguage, Meta, InteropLibrary, BranchProfile, BranchProfile)' cache 'readOnlyProfile' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                        VarHandle.storeStoreFence();
                        this.bufferLike_readOnlyProfile_ = readOnlyProfile__;
                        state_0 = state_0 | 0b10 /* add SpecializationActive[ByteArrayStore.WithoutNullCheck.doBufferLike(StaticObject, int, byte, EspressoLanguage, Meta, InteropLibrary, BranchProfile, BranchProfile)] */;
                        this.state_0_ = state_0;
                        doBufferLike(arg0Value, arg1Value, arg2Value, language__, meta__, interop__, outOfBoundsProfile__, readOnlyProfile__);
                        return;
                    }
                }
            }
            {
                Meta meta__1 = null;
                EspressoLanguage language__1 = null;
                if ((arg0Value.isForeignObject())) {
                    InteropLibrary interop__1 = this.insert((INTEROP_LIBRARY_.createDispatched(WithoutNullCheck.LIMIT)));
                    language__1 = (getLanguage());
                    meta__1 = (getMeta());
                    if ((!(Utils.isBufferLikeByteArray(language__1, meta__1, interop__1, arg0Value))) && (Utils.isArrayLike(interop__1, arg0Value.rawForeignObject(language__1)))) {
                        ArrayLikeData s2_ = this.insert(new ArrayLikeData());
                        Objects.requireNonNull(s2_.insert(interop__1), "Specialization 'doArrayLike(StaticObject, int, byte, InteropLibrary, EspressoLanguage, Meta, BranchProfile, ConditionProfile)' cache 'interop' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                        s2_.interop_ = interop__1;
                        BranchProfile exceptionProfile__ = (BranchProfile.create());
                        Objects.requireNonNull(exceptionProfile__, "Specialization 'doArrayLike(StaticObject, int, byte, InteropLibrary, EspressoLanguage, Meta, BranchProfile, ConditionProfile)' cache 'exceptionProfile' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                        s2_.exceptionProfile_ = exceptionProfile__;
                        ConditionProfile isByteArrayProfile__ = (ConditionProfile.create());
                        Objects.requireNonNull(isByteArrayProfile__, "Specialization 'doArrayLike(StaticObject, int, byte, InteropLibrary, EspressoLanguage, Meta, BranchProfile, ConditionProfile)' cache 'isByteArrayProfile' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                        s2_.isByteArrayProfile_ = isByteArrayProfile__;
                        VarHandle.storeStoreFence();
                        this.arrayLike_cache = s2_;
                        state_0 = state_0 | 0b100 /* add SpecializationActive[ByteArrayStore.WithoutNullCheck.doArrayLike(StaticObject, int, byte, InteropLibrary, EspressoLanguage, Meta, BranchProfile, ConditionProfile)] */;
                        this.state_0_ = state_0;
                        doArrayLike(arg0Value, arg1Value, arg2Value, interop__1, language__1, meta__1, exceptionProfile__, isByteArrayProfile__);
                        return;
                    }
                }
            }
            throw new UnsupportedSpecializationException(this, new Node[] {null, null, null}, arg0Value, arg1Value, arg2Value);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if ((state_0 & (state_0 - 1)) == 0 /* is-single  */) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        @NeverDefault
        public static WithoutNullCheck create() {
            return new WithoutNullCheckNodeGen();
        }

        @NeverDefault
        public static WithoutNullCheck getUncached() {
            return WithoutNullCheckNodeGen.UNCACHED;
        }

        @GeneratedBy(WithoutNullCheck.class)
        @DenyReplace
        private static final class ArrayLikeData extends Node implements SpecializationDataNode {

            /**
             * Source Info: <pre>
             *   Specialization: {@link WithoutNullCheck#doArrayLike}
             *   Parameter: {@link InteropLibrary} interop</pre>
             */
            @Child InteropLibrary interop_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link WithoutNullCheck#doArrayLike}
             *   Parameter: {@link BranchProfile} exceptionProfile</pre>
             */
            @CompilationFinal BranchProfile exceptionProfile_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link WithoutNullCheck#doArrayLike}
             *   Parameter: {@link ConditionProfile} isByteArrayProfile</pre>
             */
            @CompilationFinal ConditionProfile isByteArrayProfile_;

            ArrayLikeData() {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

        }
        @GeneratedBy(WithoutNullCheck.class)
        @DenyReplace
        private static final class Uncached extends WithoutNullCheck {

            @TruffleBoundary
            @Override
            public void execute(StaticObject arg0Value, int arg1Value, byte arg2Value) {
                if ((arg0Value.isEspressoObject())) {
                    doEspresso(arg0Value, arg1Value, arg2Value);
                    return;
                }
                if ((arg0Value.isForeignObject()) && (Utils.isBufferLikeByteArray((getLanguage()), (getMeta()), (INTEROP_LIBRARY_.getUncached()), arg0Value))) {
                    doBufferLike(arg0Value, arg1Value, arg2Value, (getLanguage()), (getMeta()), (INTEROP_LIBRARY_.getUncached()), (BranchProfile.getUncached()), (BranchProfile.getUncached()));
                    return;
                }
                if ((arg0Value.isForeignObject()) && (!(Utils.isBufferLikeByteArray((getLanguage()), (getMeta()), (INTEROP_LIBRARY_.getUncached()), arg0Value))) && (Utils.isArrayLike((INTEROP_LIBRARY_.getUncached()), arg0Value.rawForeignObject((getLanguage()))))) {
                    doArrayLike(arg0Value, arg1Value, arg2Value, (INTEROP_LIBRARY_.getUncached()), (getLanguage()), (getMeta()), (BranchProfile.getUncached()), (ConditionProfile.getUncached()));
                    return;
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null}, arg0Value, arg1Value, arg2Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
}
