// CheckStyle: start generated
package com.oracle.truffle.espresso.nodes.bytecodes;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.espresso.EspressoLanguage;
import com.oracle.truffle.espresso.nodes.bytecodes.ArrayLength.WithoutNullCheck;
import com.oracle.truffle.espresso.nodes.quick.interop.Utils;
import com.oracle.truffle.espresso.runtime.staticobject.StaticObject;
import java.lang.invoke.VarHandle;
import java.util.Objects;

@GeneratedBy(ArrayLength.class)
@SuppressWarnings("javadoc")
public final class ArrayLengthFactory {

    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    /**
     * Debug Info: <pre>
     *   Specialization {@link WithoutNullCheck#doEspresso}
     *     Activation probability: 0.48333
     *     With/without class size: 9/0 bytes
     *   Specialization {@link WithoutNullCheck#doBufferLike}
     *     Activation probability: 0.33333
     *     With/without class size: 12/8 bytes
     *   Specialization {@link WithoutNullCheck#doArrayLike}
     *     Activation probability: 0.18333
     *     With/without class size: 8/8 bytes
     * </pre>
     */
    @GeneratedBy(WithoutNullCheck.class)
    @SuppressWarnings("javadoc")
    public static final class WithoutNullCheckNodeGen extends WithoutNullCheck {

        private static final Uncached UNCACHED = new Uncached();

        /**
         * State Info: <pre>
         *   0: SpecializationActive {@link WithoutNullCheck#doEspresso}
         *   1: SpecializationActive {@link WithoutNullCheck#doBufferLike}
         *   2: SpecializationActive {@link WithoutNullCheck#doArrayLike}
         * </pre>
         */
        @CompilationFinal private int state_0_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link WithoutNullCheck#doBufferLike}
         *   Parameter: {@link InteropLibrary} interop</pre>
         */
        @Child private InteropLibrary bufferLike_interop_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link WithoutNullCheck#doBufferLike}
         *   Parameter: {@link BranchProfile} sizeOverflowProfile</pre>
         */
        @CompilationFinal private BranchProfile bufferLike_sizeOverflowProfile_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link WithoutNullCheck#doArrayLike}
         *   Parameter: {@link InteropLibrary} interop</pre>
         */
        @Child private InteropLibrary arrayLike_interop_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link WithoutNullCheck#doArrayLike}
         *   Parameter: {@link BranchProfile} sizeOverflowProfile</pre>
         */
        @CompilationFinal private BranchProfile arrayLike_sizeOverflowProfile_;

        private WithoutNullCheckNodeGen() {
        }

        @Override
        public int execute(StaticObject arg0Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is SpecializationActive[ArrayLength.WithoutNullCheck.doEspresso(StaticObject)] || SpecializationActive[ArrayLength.WithoutNullCheck.doBufferLike(StaticObject, EspressoLanguage, InteropLibrary, BranchProfile)] || SpecializationActive[ArrayLength.WithoutNullCheck.doArrayLike(StaticObject, EspressoLanguage, InteropLibrary, BranchProfile)] */) {
                if ((state_0 & 0b1) != 0 /* is SpecializationActive[ArrayLength.WithoutNullCheck.doEspresso(StaticObject)] */) {
                    if ((arg0Value.isEspressoObject())) {
                        return doEspresso(arg0Value);
                    }
                }
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[ArrayLength.WithoutNullCheck.doBufferLike(StaticObject, EspressoLanguage, InteropLibrary, BranchProfile)] */) {
                    {
                        InteropLibrary interop__ = this.bufferLike_interop_;
                        if (interop__ != null) {
                            BranchProfile sizeOverflowProfile__ = this.bufferLike_sizeOverflowProfile_;
                            if (sizeOverflowProfile__ != null) {
                                if ((arg0Value.isForeignObject())) {
                                    EspressoLanguage language__ = (getLanguage());
                                    if ((Utils.isBufferLikeByteArray(language__, getMeta(), interop__, arg0Value))) {
                                        return doBufferLike(arg0Value, language__, interop__, sizeOverflowProfile__);
                                    }
                                }
                            }
                        }
                    }
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[ArrayLength.WithoutNullCheck.doArrayLike(StaticObject, EspressoLanguage, InteropLibrary, BranchProfile)] */) {
                    {
                        InteropLibrary interop__1 = this.arrayLike_interop_;
                        if (interop__1 != null) {
                            BranchProfile sizeOverflowProfile__1 = this.arrayLike_sizeOverflowProfile_;
                            if (sizeOverflowProfile__1 != null) {
                                if ((arg0Value.isForeignObject())) {
                                    EspressoLanguage language__1 = (getLanguage());
                                    if ((!(Utils.isBufferLikeByteArray(language__1, getMeta(), interop__1, arg0Value))) && (Utils.isArrayLike(interop__1, arg0Value.rawForeignObject(language__1)))) {
                                        return doArrayLike(arg0Value, language__1, interop__1, sizeOverflowProfile__1);
                                    }
                                }
                            }
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value);
        }

        @SuppressWarnings("unused")
        private int executeAndSpecialize(StaticObject arg0Value) {
            int state_0 = this.state_0_;
            if ((arg0Value.isEspressoObject())) {
                state_0 = state_0 | 0b1 /* add SpecializationActive[ArrayLength.WithoutNullCheck.doEspresso(StaticObject)] */;
                this.state_0_ = state_0;
                return doEspresso(arg0Value);
            }
            {
                EspressoLanguage language__ = null;
                if ((arg0Value.isForeignObject())) {
                    language__ = (getLanguage());
                    InteropLibrary interop__ = this.insert((INTEROP_LIBRARY_.createDispatched(WithoutNullCheck.LIMIT)));
                    if ((Utils.isBufferLikeByteArray(language__, getMeta(), interop__, arg0Value))) {
                        Objects.requireNonNull(this.insert(interop__), "Specialization 'doBufferLike(StaticObject, EspressoLanguage, InteropLibrary, BranchProfile)' cache 'interop' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                        VarHandle.storeStoreFence();
                        this.bufferLike_interop_ = interop__;
                        BranchProfile sizeOverflowProfile__ = (BranchProfile.create());
                        Objects.requireNonNull(sizeOverflowProfile__, "Specialization 'doBufferLike(StaticObject, EspressoLanguage, InteropLibrary, BranchProfile)' cache 'sizeOverflowProfile' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                        VarHandle.storeStoreFence();
                        this.bufferLike_sizeOverflowProfile_ = sizeOverflowProfile__;
                        state_0 = state_0 | 0b10 /* add SpecializationActive[ArrayLength.WithoutNullCheck.doBufferLike(StaticObject, EspressoLanguage, InteropLibrary, BranchProfile)] */;
                        this.state_0_ = state_0;
                        return doBufferLike(arg0Value, language__, interop__, sizeOverflowProfile__);
                    }
                }
            }
            {
                EspressoLanguage language__1 = null;
                if ((arg0Value.isForeignObject())) {
                    language__1 = (getLanguage());
                    InteropLibrary interop__1 = this.insert((INTEROP_LIBRARY_.createDispatched(WithoutNullCheck.LIMIT)));
                    if ((!(Utils.isBufferLikeByteArray(language__1, getMeta(), interop__1, arg0Value))) && (Utils.isArrayLike(interop__1, arg0Value.rawForeignObject(language__1)))) {
                        Objects.requireNonNull(this.insert(interop__1), "Specialization 'doArrayLike(StaticObject, EspressoLanguage, InteropLibrary, BranchProfile)' cache 'interop' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                        VarHandle.storeStoreFence();
                        this.arrayLike_interop_ = interop__1;
                        BranchProfile sizeOverflowProfile__1 = (BranchProfile.create());
                        Objects.requireNonNull(sizeOverflowProfile__1, "Specialization 'doArrayLike(StaticObject, EspressoLanguage, InteropLibrary, BranchProfile)' cache 'sizeOverflowProfile' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                        VarHandle.storeStoreFence();
                        this.arrayLike_sizeOverflowProfile_ = sizeOverflowProfile__1;
                        state_0 = state_0 | 0b100 /* add SpecializationActive[ArrayLength.WithoutNullCheck.doArrayLike(StaticObject, EspressoLanguage, InteropLibrary, BranchProfile)] */;
                        this.state_0_ = state_0;
                        return doArrayLike(arg0Value, language__1, interop__1, sizeOverflowProfile__1);
                    }
                }
            }
            throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if ((state_0 & (state_0 - 1)) == 0 /* is-single  */) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        @NeverDefault
        public static WithoutNullCheck create() {
            return new WithoutNullCheckNodeGen();
        }

        @NeverDefault
        public static WithoutNullCheck getUncached() {
            return WithoutNullCheckNodeGen.UNCACHED;
        }

        @GeneratedBy(WithoutNullCheck.class)
        @DenyReplace
        private static final class Uncached extends WithoutNullCheck {

            @TruffleBoundary
            @Override
            public int execute(StaticObject arg0Value) {
                if ((arg0Value.isEspressoObject())) {
                    return doEspresso(arg0Value);
                }
                if ((arg0Value.isForeignObject()) && (Utils.isBufferLikeByteArray((getLanguage()), getMeta(), (INTEROP_LIBRARY_.getUncached()), arg0Value))) {
                    return doBufferLike(arg0Value, (getLanguage()), (INTEROP_LIBRARY_.getUncached()), (BranchProfile.getUncached()));
                }
                if ((arg0Value.isForeignObject()) && (!(Utils.isBufferLikeByteArray((getLanguage()), getMeta(), (INTEROP_LIBRARY_.getUncached()), arg0Value))) && (Utils.isArrayLike((INTEROP_LIBRARY_.getUncached()), arg0Value.rawForeignObject((getLanguage()))))) {
                    return doArrayLike(arg0Value, (getLanguage()), (INTEROP_LIBRARY_.getUncached()), (BranchProfile.getUncached()));
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
}
