/*
 * Decompiled with CFR 0.152.
 */
package gw.util;

import gw.util.CommandFailedException;
import gw.util.OSPlatform;
import gw.util.ShellProcess;
import gw.util.StreamUtil;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@Deprecated
public class ProcessStarter {
    public static final OutputHandler IGNORE = new NullOutputHandler();
    private static final String CONSOLE_NEWLINE = new String("\n");
    private final ProcessBuilder _pb;
    private boolean _withCMD = false;
    private boolean _inludeStdErrInOutput;
    private boolean _dontThrowOnNonZeroReturn;
    private final String _rawCmd;
    private Writer _stdOut;
    private Writer _stdErr;
    private String _charset = null;

    public ProcessStarter(String command) {
        this._rawCmd = command;
        ArrayList<String> args = new ArrayList<String>();
        args.addAll(this.parseCommandLine(command));
        this._pb = new ProcessBuilder(args);
    }

    private List<String> parseCommandLine(String str) {
        ArrayList<String> strs = new ArrayList<String>();
        StringBuilder currentToken = new StringBuilder();
        boolean inString = false;
        char stringStart = '0';
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (Character.isWhitespace(c)) {
                if (inString) {
                    currentToken.append(c);
                    continue;
                }
                if (currentToken.length() <= 0) continue;
                strs.add(currentToken.toString());
                currentToken.setLength(0);
                continue;
            }
            if ('\'' == c || '\"' == c) {
                if (inString) {
                    if (stringStart == c) {
                        strs.add(currentToken.toString());
                        currentToken.setLength(0);
                        inString = false;
                        continue;
                    }
                    currentToken.append(c);
                    continue;
                }
                stringStart = c;
                inString = true;
                continue;
            }
            if ('\\' == c) {
                if (inString) {
                    if (i + 1 >= str.length()) continue;
                    char nextC = str.charAt(i + 1);
                    if (nextC == stringStart) {
                        currentToken.append(nextC);
                        ++i;
                        continue;
                    }
                    currentToken.append(c);
                    continue;
                }
                currentToken.append(c);
                continue;
            }
            currentToken.append(c);
        }
        if (currentToken.length() > 0) {
            strs.add(currentToken.toString());
        }
        return strs;
    }

    public String exec() {
        Writer stdOut;
        Writer writer = stdOut = this._stdOut != null ? this._stdOut : new StringWriter();
        Writer stdErr = this._stdErr != null ? this._stdErr : new StdErrWriter(this._inludeStdErrInOutput ? stdOut : new StringWriter());
        this.handleCommand(stdOut, stdErr);
        this.flush(stdOut);
        this.flush(stdErr);
        return stdOut.toString();
    }

    private void flush(Writer stdOut) {
        try {
            stdOut.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execWithPipe() {
        Process process;
        try {
            process = this.startImpl();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Thread outThread = new Thread((Runnable)new StreamPipe(process.getInputStream(), System.out, false), "stdout");
        Thread errThread = new Thread((Runnable)new StreamPipe(process.getErrorStream(), System.err, false), "stderr");
        StreamPipe inPipe = new StreamPipe(System.in, process.getOutputStream(), true);
        Thread inThread = new Thread((Runnable)inPipe, "stdin");
        errThread.start();
        outThread.start();
        inThread.start();
        try {
            int i = process.waitFor();
            inPipe.setDone();
            errThread.join();
            outThread.join();
            inThread.join();
            if (i != 0) {
                String command = "";
                for (String c : this._pb.command()) {
                    command = command + c + " ";
                }
                StringBuilder s = new StringBuilder().append("The command \"").append(command).append("\" failed with code ").append(i).append(".");
                throw new CommandFailedException(i, s.toString());
            }
        }
        catch (InterruptedException e) {
        }
        finally {
            try {
                process.getErrorStream().close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                process.getInputStream().close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                process.getOutputStream().close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private Process startImpl() throws IOException {
        if (OSPlatform.isWindows() && this._withCMD) {
            this._pb.command().clear();
            this._pb.command().add("CMD.EXE");
            this._pb.command().add("/C");
            this._pb.command().add(this._rawCmd);
        }
        return this._pb.start();
    }

    public void processWithHandler(ProcessHandler handler) {
        Process process = null;
        try {
            process = this.startImpl();
            ShellProcess shellProcess = new ShellProcess(process);
            handler.run(shellProcess);
            try {
                process.exitValue();
            }
            catch (IllegalThreadStateException e) {
                process.destroy();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (process != null) {
                try {
                    process.getErrorStream().close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                try {
                    process.getInputStream().close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                try {
                    process.getOutputStream().close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public Process start() throws IOException {
        return this.startImpl();
    }

    public Map<String, String> getEnvironment() {
        return this._pb.environment();
    }

    public File getDirectory() {
        return this._pb.directory();
    }

    public void setDirectory(File directory) {
        this._pb.directory(directory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleCommand(Writer stdOut, Writer stdErr) {
        Process process;
        try {
            process = this.startImpl();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Gobbler outputGobbler = new Gobbler(process.getInputStream(), stdOut, this._charset);
        Gobbler errorGobbler = new Gobbler(process.getErrorStream(), stdErr, this._charset);
        errorGobbler.start();
        outputGobbler.start();
        try {
            int i = process.waitFor();
            errorGobbler.join();
            outputGobbler.join();
            if (i != 0) {
                String command = "";
                for (String c : this._pb.command()) {
                    command = command + c + " ";
                }
                StringBuilder s = new StringBuilder().append("The command \"").append(command).append("\" failed with code ").append(i).append(".");
                if (stdErr instanceof StdErrWriter) {
                    s.append("  StdErr was : \n").append("\n").append(ProcessStarter.indent(((StdErrWriter)stdErr).getString()));
                }
                if (!this._dontThrowOnNonZeroReturn) {
                    throw new CommandFailedException(i, s.toString());
                }
            }
        }
        catch (InterruptedException e) {
        }
        finally {
            try {
                process.getErrorStream().close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                process.getInputStream().close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                process.getOutputStream().close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static String indent(String string) {
        String[] strings = string.split(System.getProperty("line.separator"));
        StringBuilder sb = new StringBuilder();
        for (String s : strings) {
            sb.append("  ").append(s);
        }
        return sb.toString();
    }

    public ProcessStarter withCharset(String cs) {
        this._charset = cs;
        return this;
    }

    public ProcessStarter withCMD() {
        this._withCMD = true;
        return this;
    }

    public ProcessStarter includeStdErrInOutput() {
        this._inludeStdErrInOutput = true;
        return this;
    }

    public ProcessStarter doNotThrowOnNonZeroReturnVal() {
        this._dontThrowOnNonZeroReturn = true;
        return this;
    }

    public ProcessStarter withStdErrHandler(OutputHandler stdErrHandler) {
        this._stdErr = new HandlerWriter(stdErrHandler);
        return this;
    }

    public ProcessStarter withStdOutHandler(OutputHandler stdOutHandler) {
        this._stdOut = new HandlerWriter(stdOutHandler);
        return this;
    }

    public static class NullOutputHandler
    implements OutputHandler {
        @Override
        public void handleLine(String line) {
        }
    }

    private static class StreamPipe
    implements Runnable {
        private OutputStream _outStream;
        private InputStream _inStream;
        private boolean _poll;
        private boolean _done = false;

        public StreamPipe(InputStream inStream, OutputStream outStream, boolean poll) {
            this._inStream = inStream;
            this._outStream = outStream;
            this._poll = poll;
        }

        public void setDone() {
            this._done = true;
        }

        @Override
        public void run() {
            try {
                byte[] buf = new byte[4096];
                BufferedInputStream bis = new BufferedInputStream(this._inStream);
                while (!this._done) {
                    int avail = bis.available();
                    if (avail > 0) {
                        int numRead;
                        if (avail > 4096) {
                            avail = 4096;
                        }
                        if ((numRead = bis.read(buf, 0, avail)) != 0) {
                            try {
                                this._outStream.write(buf, 0, numRead);
                                this._outStream.flush();
                                continue;
                            }
                            catch (IOException ex) {}
                        }
                        break;
                    }
                    if (!this._poll) {
                        int ch = bis.read();
                        if (ch != -1) {
                            try {
                                this._outStream.write(ch);
                                this._outStream.flush();
                                continue;
                            }
                            catch (IOException ex) {}
                        }
                        break;
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class HandlerWriter
    extends Writer {
        private final OutputHandler _handler;

        public HandlerWriter(OutputHandler handler) {
            this._handler = handler;
        }

        @Override
        public void write(String str, int off, int len) throws IOException {
            if (str != CONSOLE_NEWLINE) {
                this._handler.handleLine(str);
            }
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void close() throws IOException {
        }

        public String toString() {
            return "";
        }
    }

    public static interface ProcessHandler {
        public void run(ShellProcess var1);
    }

    public static interface OutputHandler {
        public void handleLine(String var1);
    }

    private static class StdErrWriter
    extends Writer {
        Writer _str;

        public StdErrWriter(Writer stringWriter) {
            this._str = stringWriter;
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            System.err.print(new String(cbuf, off, len));
            this._str.write(cbuf, off, len);
        }

        @Override
        public void flush() throws IOException {
            this._str.flush();
        }

        @Override
        public void close() throws IOException {
            this._str.close();
        }

        public String getString() {
            return this._str.toString();
        }
    }

    private static class Gobbler
    extends Thread {
        private InputStream _streamToGobble;
        private Writer _buffer;
        private String _gobblerCharset = null;

        public Gobbler(InputStream streamToGobble, Writer buffer, String charSet) {
            this._streamToGobble = streamToGobble;
            this._buffer = buffer;
            this._gobblerCharset = charSet;
        }

        @Override
        public void run() {
            try {
                String line;
                Reader inputStreamReader = this._gobblerCharset == null ? StreamUtil.getInputStreamReader((InputStream)this._streamToGobble) : StreamUtil.getInputStreamReader((InputStream)this._streamToGobble, (String)this._gobblerCharset);
                BufferedReader br = new BufferedReader(inputStreamReader);
                while ((line = br.readLine()) != null) {
                    this._buffer.append(line).append(CONSOLE_NEWLINE);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

