/*
 * Decompiled with CFR 0.152.
 */
package gw.util.process;

import gw.util.StreamUtil;
import gw.util.process.OutputHandler;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

class ChainedOutputHandler
implements OutputHandler,
Closeable {
    private static final OutputHandler NULL_OUTPUT_HANDLER = new OutputHandler(){

        @Override
        public void handleLine(String line) {
        }
    };
    private List<OutputHandler> _handlers = new ArrayList<OutputHandler>();

    ChainedOutputHandler() {
    }

    void add(OutputHandler handler) {
        this._handlers.add(handler);
    }

    OutputHandler maybeReduce() {
        switch (this._handlers.size()) {
            case 0: {
                return NULL_OUTPUT_HANDLER;
            }
            case 1: {
                return this._handlers.get(0);
            }
        }
        return this;
    }

    @Override
    public void handleLine(String line) {
        for (OutputHandler handler : this._handlers) {
            handler.handleLine(line);
        }
    }

    @Override
    public void close() throws IOException {
        this.close(0);
    }

    private void close(int idx) throws IOException {
        if (idx >= this._handlers.size()) {
            return;
        }
        OutputHandler handler = this._handlers.get(idx);
        try {
            if (handler instanceof Closeable) {
                StreamUtil.close((Closeable[])new Closeable[]{(Closeable)((Object)handler)});
            }
        }
        finally {
            this.close(idx + 1);
        }
    }
}

