/*
 * Decompiled with CFR 0.152.
 */
package gw.gosudoc.com.sun.tools.javadoc.main;

import gw.gosudoc.com.sun.tools.javadoc.main.DocEnv;
import gw.gosudoc.com.sun.tools.javadoc.main.DocImpl;
import java.text.BreakIterator;
import java.text.Collator;
import java.util.Locale;

@Deprecated
class DocLocale {
    final String localeName;
    final Locale locale;
    final Collator collator;
    private final DocEnv docenv;
    private final BreakIterator sentenceBreaker;
    private boolean useBreakIterator = false;
    static final String[] sentenceTerminators = new String[]{"<p>", "</p>", "<h1>", "<h2>", "<h3>", "<h4>", "<h5>", "<h6>", "</h1>", "</h2>", "</h3>", "</h4>", "</h5>", "</h6>", "<hr>", "<pre>", "</pre>"};

    DocLocale(DocEnv docenv, String localeName, boolean useBreakIterator) {
        this.docenv = docenv;
        this.localeName = localeName;
        this.useBreakIterator = useBreakIterator;
        this.locale = this.getLocale();
        if (this.locale == null) {
            docenv.exit();
        } else {
            Locale.setDefault(this.locale);
        }
        this.collator = Collator.getInstance(this.locale);
        this.sentenceBreaker = BreakIterator.getSentenceInstance(this.locale);
    }

    /*
     * Enabled aggressive block sorting
     */
    private Locale getLocale() {
        Locale userlocale = null;
        if (this.localeName.length() <= 0) return Locale.getDefault();
        int firstuscore = this.localeName.indexOf(95);
        int seconduscore = -1;
        String language = null;
        String country = null;
        String variant = null;
        if (firstuscore == 2) {
            language = this.localeName.substring(0, firstuscore);
            seconduscore = this.localeName.indexOf(95, firstuscore + 1);
            if (seconduscore > 0) {
                if (seconduscore != firstuscore + 3 || this.localeName.length() <= seconduscore + 1) {
                    this.docenv.error(null, "main.malformed_locale_name", this.localeName);
                    return null;
                }
                country = this.localeName.substring(firstuscore + 1, seconduscore);
                variant = this.localeName.substring(seconduscore + 1);
            } else {
                if (this.localeName.length() != firstuscore + 3) {
                    this.docenv.error(null, "main.malformed_locale_name", this.localeName);
                    return null;
                }
                country = this.localeName.substring(firstuscore + 1);
            }
        } else if (firstuscore == -1 && this.localeName.length() == 2) {
            language = this.localeName;
        } else {
            this.docenv.error(null, "main.malformed_locale_name", this.localeName);
            return null;
        }
        userlocale = this.searchLocale(language, country, variant);
        if (userlocale == null) {
            this.docenv.error(null, "main.illegal_locale_name", this.localeName);
            return null;
        }
        return userlocale;
    }

    private Locale searchLocale(String language, String country, String variant) {
        for (Locale loc : Locale.getAvailableLocales()) {
            if (!loc.getLanguage().equals(language) || country != null && !loc.getCountry().equals(country) || variant != null && !loc.getVariant().equals(variant)) continue;
            return loc;
        }
        return null;
    }

    String localeSpecificFirstSentence(DocImpl doc, String s) {
        if (s == null || s.length() == 0) {
            return "";
        }
        int index = s.indexOf("-->");
        if (s.trim().startsWith("<!--") && index != -1) {
            return this.localeSpecificFirstSentence(doc, s.substring(index + 3, s.length()));
        }
        if (this.useBreakIterator || !this.locale.getLanguage().equals("en")) {
            this.sentenceBreaker.setText(s.replace('\n', ' '));
            int start = this.sentenceBreaker.first();
            int end = this.sentenceBreaker.next();
            return s.substring(start, end).trim();
        }
        return this.englishLanguageFirstSentence(s).trim();
    }

    private String englishLanguageFirstSentence(String s) {
        if (s == null) {
            return null;
        }
        int len = s.length();
        boolean period = false;
        block5: for (int i = 0; i < len; ++i) {
            switch (s.charAt(i)) {
                case '.': {
                    period = true;
                    continue block5;
                }
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    if (!period) continue block5;
                    return s.substring(0, i);
                }
                case '<': {
                    if (i <= 0 || !this.htmlSentenceTerminatorFound(s, i)) continue block5;
                    return s.substring(0, i);
                }
                default: {
                    period = false;
                }
            }
        }
        return s;
    }

    private boolean htmlSentenceTerminatorFound(String str, int index) {
        for (String terminator : sentenceTerminators) {
            if (!str.regionMatches(true, index, terminator, 0, terminator.length())) continue;
            return true;
        }
        return false;
    }
}

