/*
 * Decompiled with CFR 0.152.
 */
package gw.gosudoc.tags;

import gw.gosudoc.doc.GSRootDocImpl;
import gw.internal.gosu.ir.transform.expression.TypeAsTransformer;
import gw.internal.gosu.runtime.GosuRuntimeMethods;
import gw.lang.enhancements.CoreArrayEnhancement;
import gw.lang.enhancements.CoreIterableEnhancement;
import gw.lang.parser.ICoercer;
import gw.lang.parser.IReducedDynamicFunctionSymbol;
import gw.lang.parser.coercers.RuntimeCoercer;
import gw.lang.reflect.ClassLazyTypeResolver;
import gw.lang.reflect.IAttributedFeatureInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.LazyTypeResolver;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.gs.IGosuClassObject;
import gw.lang.reflect.gs.IGosuMethodInfo;
import gw.lang.reflect.gs.IGosuPropertyInfo;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import manifold.internal.runtime.Bootstrap;

public class TagsTokenizer
implements IGosuClassObject {
    GSRootDocImpl _rootDoc;
    IAttributedFeatureInfo _fi;
    String _src;
    static final String INLINE_TAG_REGEXP;
    static final String BLOCK_TAG_REGEXP;
    static final Pattern INLINE_TAG_PATTERN;
    static final Pattern BLOCK_TAG_PATTERN;

    static {
        Bootstrap.init();
        INLINE_TAG_REGEXP = "\\{@[^}]+\\}";
        BLOCK_TAG_REGEXP = "^[ ]*@([a-zA-Z]*).*";
        INLINE_TAG_PATTERN = Pattern.compile(INLINE_TAG_REGEXP);
        BLOCK_TAG_PATTERN = Pattern.compile(BLOCK_TAG_REGEXP);
    }

    public TagsTokenizer(String src, IAttributedFeatureInfo featureInfo, GSRootDocImpl rootDoc) {
        String string = src;
        this._src = string != null ? string : "";
        this._fi = featureInfo;
        this._rootDoc = rootDoc;
    }

    public String processTags() {
        String returnStr = this._src;
        if (returnStr.contains("@")) {
            if (returnStr.contains("{@")) {
                returnStr = this.processInlineTags(returnStr);
            }
            if (returnStr.contains("@")) {
                returnStr = this.processBlockTags(returnStr);
            }
        }
        return returnStr;
    }

    public String processInlineTags(String str) {
        Matcher matcher = INLINE_TAG_PATTERN.matcher(str);
        StringBuilder returnStr = new StringBuilder();
        int currentLocation = 0;
        while (matcher.find()) {
            int matchStart = matcher.start();
            int matchEnd = matcher.end();
            returnStr.append(str.substring(currentLocation, matchStart));
            returnStr.append(this.processInlineTag(str.substring(matchStart, matchEnd)));
            currentLocation = matchEnd;
        }
        returnStr.append(str.substring(currentLocation));
        return returnStr.toString();
    }

    String processInlineTag(String inlineTag) {
        if (inlineTag.startsWith("{@code ")) {
            String content = inlineTag.substring(Math.min(7, inlineTag.length() - 1), inlineTag.length() - 1);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append((Object)"<code>");
            stringBuilder.append((Object)content);
            stringBuilder.append((Object)"</code>");
            return stringBuilder.toString();
        }
        if (inlineTag.startsWith("{@link ")) {
            String content = inlineTag.substring(Math.min(7, inlineTag.length() - 1), inlineTag.length() - 1);
            return this.linkToFeature(content);
        }
        if (inlineTag.equals("{@docRoot}")) {
            return inlineTag;
        }
        if (inlineTag.equals("{@inheritDoc}")) {
            return this.handleDescriptionInheritance(this._fi, inlineTag);
        }
        return inlineTag;
    }

    String linkToFeature(String content) {
        Object object;
        Object object2;
        Object[] pieces;
        String stripped = content.trim();
        Object[] objectArray = pieces = stripped.split(" ");
        Object[] objectArray2 = ClassLazyTypeResolver.String;
        if (objectArray == null) {
            throw new NullPointerException();
        }
        String feature = (String)CoreArrayEnhancement.first((Object[])objectArray, (LazyTypeResolver)objectArray2);
        if (pieces.length > 1) {
            object2 = pieces[1];
        } else {
            objectArray2 = pieces;
            object = ClassLazyTypeResolver.String;
            if (objectArray2 == null) {
                throw new NullPointerException();
            }
            object2 = (String)CoreArrayEnhancement.first((Object[])objectArray2, (LazyTypeResolver)object);
        }
        Object description = object2;
        object = new StringBuilder();
        ((StringBuilder)object).append((Object)"<a href='");
        ((StringBuilder)object).append((Object)this.parseLink(feature));
        ((StringBuilder)object).append((Object)"'>");
        ((StringBuilder)object).append(description);
        ((StringBuilder)object).append((Object)"</a>");
        return ((StringBuilder)object).toString();
    }

    String parseLink(String feature) {
        Object[] typeAndFeature;
        Object[] objectArray = typeAndFeature = feature.split(String.valueOf('#'));
        Object object = ClassLazyTypeResolver.String;
        if (objectArray == null) {
            throw new NullPointerException();
        }
        String linkToType = this.linkToType((String)CoreArrayEnhancement.first((Object[])objectArray, (LazyTypeResolver)object));
        if (typeAndFeature.length > 1) {
            object = new StringBuilder();
            ((StringBuilder)object).append((Object)linkToType);
            ((StringBuilder)object).append((Object)"#");
            ((StringBuilder)object).append(typeAndFeature[1]);
            return ((StringBuilder)object).toString();
        }
        object = new StringBuilder();
        ((StringBuilder)object).append((Object)linkToType);
        return ((StringBuilder)object).toString();
    }

    String linkToType(String typeName) {
        if (typeName.length() == 0) {
            return "";
        }
        if (typeName.indexOf(46) > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append((Object)"{@docRoot}/");
            stringBuilder.append((Object)this.packagePath(typeName));
            stringBuilder.append((Object)"/");
            stringBuilder.append((Object)typeName);
            stringBuilder.append((Object)".html");
            return stringBuilder.toString();
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append((Object)this._fi.getOwnersType().getNamespace());
        stringBuilder.append((Object)".");
        stringBuilder.append((Object)typeName);
        stringBuilder.append((Object)".html");
        return stringBuilder.toString();
    }

    String packagePath(String typeName) {
        Object[] objectArray = typeName.split("\\.");
        if (objectArray == null) {
            throw new NullPointerException();
        }
        List components = CoreArrayEnhancement.toList((Object[])objectArray);
        List list = components.subList(0, components.size() - 1);
        String string = "/";
        if (list == null) {
            throw new NullPointerException();
        }
        return CoreIterableEnhancement.join(list, (String)string);
    }

    /*
     * WARNING - void declaration
     */
    public String processBlockTags(String str) {
        String currentTag;
        void lines;
        StringBuilder sb = new StringBuilder();
        String[] stringArray = str.split("\n");
        Object var4_4 = null;
        ArrayList<void> tagBuffer = null;
        void var6_6 = lines;
        int n = -1 + (var6_6 == null ? -1 : ((void)var6_6).length);
        int n2 = -1;
        Object var9_9 = null;
        if (var6_6 != null) {
            while (n2 != n) {
                void line;
                Matcher matcher;
                if ((matcher = BLOCK_TAG_PATTERN.matcher((CharSequence)(line = var6_6[++n2]))).matches() && this.validTagName(matcher.group(1))) {
                    sb.append(this.handleBlockCurrentTag(currentTag, (List<String>)tagBuffer)).append("\n");
                    currentTag = matcher.group(1);
                    ArrayList<void> arrayList = new ArrayList<void>();
                    arrayList.add(line);
                    tagBuffer = arrayList;
                    continue;
                }
                if (currentTag == null) {
                    sb.append((String)line).append("\n");
                    continue;
                }
                tagBuffer.add(line);
            }
        }
        sb.append(this.handleBlockCurrentTag(currentTag, tagBuffer)).append("\n");
        return sb.toString();
    }

    String handleBlockCurrentTag(String currentTag, List<String> tagBuffer) {
        if (currentTag == null) {
            return "";
        }
        Object object = currentTag;
        String string = "see";
        if (object == string || object != null && string != null && object.equals(string)) {
            String value = this.blockTagValue(currentTag, tagBuffer);
            return "<dl><dt><b>See Also:</b></dt><dd>" + this.linkToFeature(value) + "<dd></dl>";
        }
        object = tagBuffer;
        string = "\n";
        if (object == null) {
            throw new NullPointerException();
        }
        return CoreIterableEnhancement.join((Iterable)object, (String)string);
    }

    String blockTagValue(String currentTag, List<String> tagBuffer) {
        StringBuilder sb = new StringBuilder();
        List<String> list = tagBuffer;
        ClassLazyTypeResolver classLazyTypeResolver = ClassLazyTypeResolver.String;
        if (list == null) {
            throw new NullPointerException();
        }
        String firstLine = (String)CoreIterableEnhancement.first(list, (LazyTypeResolver)classLazyTypeResolver);
        sb.append(firstLine.substring(firstLine.indexOf('@' + currentTag) + 1 + currentTag.length())).append("\n");
        Iterator<String> rest = tagBuffer.iterator();
        rest.next();
        while (rest.hasNext()) {
            sb.append(rest.next()).append("\n");
        }
        return sb.toString();
    }

    boolean validTagName(String tagName) {
        String string = tagName;
        String string2 = "see";
        return string == string2 || string != null && string2 != null && string.equals(string2);
    }

    String handleDescriptionInheritance(IAttributedFeatureInfo fi, String description) {
        String superCI;
        String string;
        if (fi instanceof IGosuMethodInfo && ((string = description) == null ? false : string.contains("{@inheritDoc}"))) {
            String superDesc;
            string = fi;
            string = (string instanceof IGosuMethodInfo || string == null ? (IGosuMethodInfo)string : (IGosuMethodInfo)TypeAsTransformer.coerceValue((Object)string, (IType)TypeSystem.getByFullName((String)"gw.lang.reflect.gs.IGosuMethodInfo", (String)"_default_"), (ICoercer)RuntimeCoercer.instance())).getDfs();
            string = string == null ? (IReducedDynamicFunctionSymbol)null : string.getSuperDfs();
            Object object = superCI = string == null ? (IAttributedFeatureInfo)null : string.getMethodOrConstructorInfo();
            if (superCI != null && (superDesc = this.handleDescriptionInheritance((IAttributedFeatureInfo)superCI, superCI.getDescription())) != null) {
                return description.replace("{@inheritDoc}", superDesc);
            }
            return "";
        }
        if (fi instanceof IGosuPropertyInfo && ((superCI = description) == null ? false : superCI.contains("{@inheritDoc}"))) {
            String superDesc;
            superCI = fi;
            superCI = (superCI instanceof IGosuPropertyInfo || superCI == null ? (IGosuPropertyInfo)superCI : (IGosuPropertyInfo)TypeAsTransformer.coerceValue((Object)superCI, (IType)TypeSystem.getByFullName((String)"gw.lang.reflect.gs.IGosuPropertyInfo", (String)"_default_"), (ICoercer)RuntimeCoercer.instance())).getDps();
            superCI = superCI == null ? (IReducedDynamicFunctionSymbol)null : superCI.getGetterDfs();
            superCI = superCI == null ? (IReducedDynamicFunctionSymbol)null : superCI.getSuperDfs();
            Object object = superCI = superCI == null ? (IAttributedFeatureInfo)null : superCI.getMethodOrConstructorInfo();
            if (superCI != null && (superDesc = this.handleDescriptionInheritance((IAttributedFeatureInfo)superCI, superCI.getDescription())) != null) {
                return description.replace("{@inheritDoc}", superDesc);
            }
            return "";
        }
        return description;
    }

    public /* synthetic */ IType getIntrinsicType() {
        return GosuRuntimeMethods.getType((Object)this);
    }
}

