/*
 * Decompiled with CFR 0.152.
 */
package gw.gosudoc.com.sun.tools.doclets.internal.toolkit.util;

import gw.gosudoc.com.sun.javadoc.ClassDoc;
import gw.gosudoc.com.sun.javadoc.Doc;
import gw.gosudoc.com.sun.javadoc.PackageDoc;
import gw.gosudoc.com.sun.javadoc.ProgramElementDoc;
import gw.gosudoc.com.sun.javadoc.RootDoc;
import gw.gosudoc.com.sun.tools.doclets.internal.toolkit.Configuration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Deprecated
public class IndexBuilder {
    private Map<Character, List<Doc>> indexmap = new HashMap<Character, List<Doc>>();
    private boolean noDeprecated;
    private boolean classesOnly;
    private boolean javafx;
    protected final Object[] elements;
    private final Configuration configuration;

    public IndexBuilder(Configuration configuration, boolean noDeprecated) {
        this(configuration, noDeprecated, false);
    }

    public IndexBuilder(Configuration configuration, boolean noDeprecated, boolean classesOnly) {
        this.configuration = configuration;
        if (classesOnly) {
            configuration.message.notice("doclet.Building_Index_For_All_Classes", new Object[0]);
        } else {
            configuration.message.notice("doclet.Building_Index", new Object[0]);
        }
        this.noDeprecated = noDeprecated;
        this.classesOnly = classesOnly;
        this.javafx = configuration.javafx;
        this.buildIndexMap(configuration.root);
        Set<Character> set = this.indexmap.keySet();
        this.elements = set.toArray();
        Arrays.sort(this.elements);
    }

    protected void sortIndexMap() {
        for (List<Doc> docs : this.indexmap.values()) {
            Collections.sort(docs, this.configuration.utils.makeComparatorForIndexUse());
        }
    }

    protected void buildIndexMap(RootDoc root) {
        Doc[] packages = root.specifiedPackages();
        Doc[] classes = root.classes();
        if (!this.classesOnly) {
            if (packages.length == 0) {
                HashSet<PackageDoc> set = new HashSet<PackageDoc>();
                Doc[] docArray = classes;
                int n = docArray.length;
                for (int i = 0; i < n; ++i) {
                    Doc aClass = docArray[i];
                    PackageDoc pd = aClass.containingPackage();
                    if (pd == null || pd.name().length() <= 0) continue;
                    set.add(pd);
                }
                this.adjustIndexMap(set.toArray(packages));
            } else {
                this.adjustIndexMap(packages);
            }
        }
        this.adjustIndexMap(classes);
        if (!this.classesOnly) {
            for (Doc aClass : classes) {
                if (!this.shouldAddToIndexMap(aClass)) continue;
                this.putMembersInIndexMap((ClassDoc)aClass);
            }
        }
        this.sortIndexMap();
    }

    protected void putMembersInIndexMap(ClassDoc classdoc) {
        this.adjustIndexMap(classdoc.fields());
        this.adjustIndexMap(classdoc.methods());
        this.adjustIndexMap(classdoc.constructors());
    }

    protected void adjustIndexMap(Doc[] elements) {
        for (Doc element : elements) {
            if (!this.shouldAddToIndexMap(element)) continue;
            String name = element.name();
            char ch = name.length() == 0 ? (char)'*' : (char)Character.toUpperCase(name.charAt(0));
            Character unicode = Character.valueOf(ch);
            List<Doc> list = this.indexmap.get(unicode);
            if (list == null) {
                list = new ArrayList<Doc>();
                this.indexmap.put(unicode, list);
            }
            list.add(element);
        }
    }

    protected boolean shouldAddToIndexMap(Doc element) {
        if (this.javafx && element.tags("treatAsPrivate").length > 0) {
            return false;
        }
        if (element instanceof PackageDoc) {
            return !this.noDeprecated || !this.configuration.utils.isDeprecated(element);
        }
        return !this.noDeprecated || !this.configuration.utils.isDeprecated(element) && !this.configuration.utils.isDeprecated(((ProgramElementDoc)element).containingPackage());
    }

    public Map<Character, List<Doc>> getIndexMap() {
        return this.indexmap;
    }

    public List<Doc> getMemberList(Character index) {
        return this.indexmap.get(index);
    }

    public Object[] elements() {
        return this.elements;
    }
}

