/*
 * Decompiled with CFR 0.152.
 */
package gw.gosudoc.com.sun.tools.doclets.internal.toolkit.util;

import gw.gosudoc.com.sun.javadoc.ClassDoc;
import gw.gosudoc.com.sun.javadoc.Doc;
import gw.gosudoc.com.sun.javadoc.RootDoc;
import gw.gosudoc.com.sun.javadoc.Type;
import gw.gosudoc.com.sun.tools.doclets.internal.toolkit.Configuration;
import gw.gosudoc.com.sun.tools.doclets.internal.toolkit.util.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;

@Deprecated
public class ClassTree {
    private final SortedSet<ClassDoc> baseclasses;
    private final Map<ClassDoc, SortedSet<ClassDoc>> subclasses = new HashMap<ClassDoc, SortedSet<ClassDoc>>();
    private final SortedSet<ClassDoc> baseinterfaces;
    private final Map<ClassDoc, SortedSet<ClassDoc>> subinterfaces = new HashMap<ClassDoc, SortedSet<ClassDoc>>();
    private final SortedSet<ClassDoc> baseEnums;
    private final Map<ClassDoc, SortedSet<ClassDoc>> subEnums = new HashMap<ClassDoc, SortedSet<ClassDoc>>();
    private final SortedSet<ClassDoc> baseAnnotationTypes;
    private final Map<ClassDoc, SortedSet<ClassDoc>> subAnnotationTypes = new HashMap<ClassDoc, SortedSet<ClassDoc>>();
    private final Map<ClassDoc, SortedSet<ClassDoc>> implementingclasses = new HashMap<ClassDoc, SortedSet<ClassDoc>>();
    private final Configuration configuration;
    private final Utils utils;
    private final Comparator<Doc> comparator;

    public ClassTree(Configuration configuration, boolean noDeprecated) {
        configuration.message.notice("doclet.Building_Tree", new Object[0]);
        this.configuration = configuration;
        this.utils = configuration.utils;
        this.comparator = this.utils.makeGeneralPurposeComparator();
        this.baseAnnotationTypes = new TreeSet<Doc>(this.comparator);
        this.baseEnums = new TreeSet<Doc>(this.comparator);
        this.baseclasses = new TreeSet<Doc>(this.comparator);
        this.baseinterfaces = new TreeSet<Doc>(this.comparator);
        this.buildTree(configuration.root.classes());
    }

    public ClassTree(RootDoc root, Configuration configuration) {
        this.configuration = configuration;
        this.utils = configuration.utils;
        this.comparator = this.utils.makeGeneralPurposeComparator();
        this.baseAnnotationTypes = new TreeSet<Doc>(this.comparator);
        this.baseEnums = new TreeSet<Doc>(this.comparator);
        this.baseclasses = new TreeSet<Doc>(this.comparator);
        this.baseinterfaces = new TreeSet<Doc>(this.comparator);
        this.buildTree(root.classes());
    }

    public ClassTree(ClassDoc[] classes, Configuration configuration) {
        this.configuration = configuration;
        this.utils = configuration.utils;
        this.comparator = this.utils.makeGeneralPurposeComparator();
        this.baseAnnotationTypes = new TreeSet<Doc>(this.comparator);
        this.baseEnums = new TreeSet<Doc>(this.comparator);
        this.baseclasses = new TreeSet<Doc>(this.comparator);
        this.baseinterfaces = new TreeSet<Doc>(this.comparator);
        this.buildTree(classes);
    }

    private void buildTree(ClassDoc[] classes) {
        for (ClassDoc aClass : classes) {
            if (this.configuration.nodeprecated && (this.utils.isDeprecated(aClass) || this.utils.isDeprecated(aClass.containingPackage())) || this.configuration.javafx && aClass.tags("treatAsPrivate").length > 0) continue;
            if (aClass.isEnum()) {
                this.processType(aClass, this.configuration, this.baseEnums, this.subEnums);
                continue;
            }
            if (aClass.isClass()) {
                this.processType(aClass, this.configuration, this.baseclasses, this.subclasses);
                continue;
            }
            if (aClass.isInterface()) {
                this.processInterface(aClass);
                continue;
            }
            if (!aClass.isAnnotationType()) continue;
            this.processType(aClass, this.configuration, this.baseAnnotationTypes, this.subAnnotationTypes);
        }
    }

    private void processType(ClassDoc cd, Configuration configuration, Collection<ClassDoc> bases, Map<ClassDoc, SortedSet<ClassDoc>> subs) {
        ClassDoc superclass = this.utils.getFirstVisibleSuperClassCD(cd, configuration);
        if (superclass != null) {
            if (!this.add(subs, superclass, cd)) {
                return;
            }
            this.processType(superclass, configuration, bases, subs);
        } else if (!bases.contains(cd)) {
            bases.add(cd);
        }
        List<Type> intfacs = this.utils.getAllInterfaces(cd, configuration);
        for (Type intfac : intfacs) {
            this.add(this.implementingclasses, intfac.asClassDoc(), cd);
        }
    }

    private void processInterface(ClassDoc cd) {
        ClassDoc[] intfacs = cd.interfaces();
        if (intfacs.length > 0) {
            for (ClassDoc intfac : intfacs) {
                if (!this.add(this.subinterfaces, intfac, cd)) {
                    return;
                }
                this.processInterface(intfac);
            }
        } else if (!this.baseinterfaces.contains(cd)) {
            this.baseinterfaces.add(cd);
        }
    }

    private boolean add(Map<ClassDoc, SortedSet<ClassDoc>> map, ClassDoc superclass, ClassDoc cd) {
        SortedSet<ClassDoc> list = map.get(superclass);
        if (list == null) {
            list = new TreeSet<Doc>(this.comparator);
            map.put(superclass, list);
        }
        if (list.contains(cd)) {
            return false;
        }
        list.add(cd);
        return true;
    }

    private SortedSet<ClassDoc> get(Map<ClassDoc, SortedSet<ClassDoc>> map, ClassDoc cd) {
        SortedSet<ClassDoc> aset = map.get(cd);
        if (aset == null) {
            return new TreeSet<Doc>(this.comparator);
        }
        return aset;
    }

    public SortedSet<ClassDoc> subclasses(ClassDoc cd) {
        return this.get(this.subclasses, cd);
    }

    public SortedSet<ClassDoc> subinterfaces(ClassDoc cd) {
        return this.get(this.subinterfaces, cd);
    }

    public SortedSet<ClassDoc> implementingclasses(ClassDoc cd) {
        SortedSet<ClassDoc> result = this.get(this.implementingclasses, cd);
        SortedSet<ClassDoc> intfcs = this.allSubs(cd, false);
        Iterator subInterfacesIter = intfcs.iterator();
        while (subInterfacesIter.hasNext()) {
            for (ClassDoc c : this.implementingclasses((ClassDoc)subInterfacesIter.next())) {
                if (result.contains(c)) continue;
                result.add(c);
            }
        }
        return result;
    }

    public SortedSet<ClassDoc> subs(ClassDoc cd, boolean isEnum) {
        if (isEnum) {
            return this.get(this.subEnums, cd);
        }
        if (cd.isAnnotationType()) {
            return this.get(this.subAnnotationTypes, cd);
        }
        if (cd.isInterface()) {
            return this.get(this.subinterfaces, cd);
        }
        if (cd.isClass()) {
            return this.get(this.subclasses, cd);
        }
        return null;
    }

    public SortedSet<ClassDoc> allSubs(ClassDoc cd, boolean isEnum) {
        ArrayList<ClassDoc> list = new ArrayList<ClassDoc>(this.subs(cd, isEnum));
        for (int i = 0; i < list.size(); ++i) {
            cd = (ClassDoc)list.get(i);
            SortedSet<ClassDoc> tlist = this.subs(cd, isEnum);
            for (ClassDoc tcd : tlist) {
                if (list.contains(tcd)) continue;
                list.add(tcd);
            }
        }
        TreeSet<Doc> oset = new TreeSet<Doc>(this.comparator);
        oset.addAll(list);
        return oset;
    }

    public SortedSet<ClassDoc> baseclasses() {
        return this.baseclasses;
    }

    public SortedSet<ClassDoc> baseinterfaces() {
        return this.baseinterfaces;
    }

    public SortedSet<ClassDoc> baseEnums() {
        return this.baseEnums;
    }

    public SortedSet<ClassDoc> baseAnnotationTypes() {
        return this.baseAnnotationTypes;
    }
}

