/*
 * Decompiled with CFR 0.152.
 */
package gw.gosudoc.com.sun.tools.doclets.internal.toolkit.taglets;

import com.sun.tools.javac.util.StringUtils;
import gw.gosudoc.com.sun.javadoc.ClassDoc;
import gw.gosudoc.com.sun.javadoc.ConstructorDoc;
import gw.gosudoc.com.sun.javadoc.Doc;
import gw.gosudoc.com.sun.javadoc.FieldDoc;
import gw.gosudoc.com.sun.javadoc.MethodDoc;
import gw.gosudoc.com.sun.javadoc.PackageDoc;
import gw.gosudoc.com.sun.javadoc.RootDoc;
import gw.gosudoc.com.sun.javadoc.Tag;
import gw.gosudoc.com.sun.tools.doclets.internal.toolkit.taglets.CodeTaglet;
import gw.gosudoc.com.sun.tools.doclets.internal.toolkit.taglets.DocRootTaglet;
import gw.gosudoc.com.sun.tools.doclets.internal.toolkit.taglets.IndexTaglet;
import gw.gosudoc.com.sun.tools.doclets.internal.toolkit.taglets.InheritDocTaglet;
import gw.gosudoc.com.sun.tools.doclets.internal.toolkit.taglets.LegacyTaglet;
import gw.gosudoc.com.sun.tools.doclets.internal.toolkit.taglets.LiteralTaglet;
import gw.gosudoc.com.sun.tools.doclets.internal.toolkit.taglets.ParamTaglet;
import gw.gosudoc.com.sun.tools.doclets.internal.toolkit.taglets.PropertyGetterTaglet;
import gw.gosudoc.com.sun.tools.doclets.internal.toolkit.taglets.PropertySetterTaglet;
import gw.gosudoc.com.sun.tools.doclets.internal.toolkit.taglets.ReturnTaglet;
import gw.gosudoc.com.sun.tools.doclets.internal.toolkit.taglets.SeeTaglet;
import gw.gosudoc.com.sun.tools.doclets.internal.toolkit.taglets.SimpleTaglet;
import gw.gosudoc.com.sun.tools.doclets.internal.toolkit.taglets.Taglet;
import gw.gosudoc.com.sun.tools.doclets.internal.toolkit.taglets.ThrowsTaglet;
import gw.gosudoc.com.sun.tools.doclets.internal.toolkit.taglets.ValueTaglet;
import gw.gosudoc.com.sun.tools.doclets.internal.toolkit.util.MessageRetriever;
import java.io.File;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.tools.DocumentationTool;
import javax.tools.JavaFileManager;

@Deprecated
public class TagletManager {
    public static final char SIMPLE_TAGLET_OPT_SEPARATOR = ':';
    public static final String ALT_SIMPLE_TAGLET_OPT_SEPARATOR = "-";
    private LinkedHashMap<String, Taglet> customTags;
    private Taglet[] packageTags;
    private Taglet[] typeTags;
    private Taglet[] fieldTags;
    private Taglet[] constructorTags;
    private Taglet[] methodTags;
    private Taglet[] overviewTags;
    private Taglet[] inlineTags;
    private Taglet[] serializedFormTags;
    private MessageRetriever message;
    private Set<String> standardTags;
    private Set<String> standardTagsLowercase;
    private Set<String> overridenStandardTags = new HashSet<String>();
    private Set<String> potentiallyConflictingTags = new HashSet<String>();
    private Set<String> unseenCustomTags;
    private boolean nosince;
    private boolean showversion;
    private boolean showauthor;
    private boolean javafx;
    private boolean exportInternalAPI;

    public TagletManager(boolean nosince, boolean showversion, boolean showauthor, boolean javafx, boolean exportInternalAPI, MessageRetriever message) {
        this.standardTags = new HashSet<String>();
        this.standardTagsLowercase = new HashSet<String>();
        this.unseenCustomTags = new HashSet<String>();
        this.customTags = new LinkedHashMap();
        this.nosince = nosince;
        this.showversion = showversion;
        this.showauthor = showauthor;
        this.javafx = javafx;
        this.exportInternalAPI = exportInternalAPI;
        this.message = message;
        this.initStandardTaglets();
        this.initStandardTagsLowercase();
    }

    public void addCustomTag(Taglet customTag) {
        if (customTag != null) {
            String name = customTag.getName();
            if (this.customTags.containsKey(name)) {
                this.customTags.remove(name);
            }
            this.customTags.put(name, customTag);
            this.checkTagName(name);
        }
    }

    public Set<String> getCustomTagNames() {
        return this.customTags.keySet();
    }

    public void addCustomTag(String classname, JavaFileManager fileManager, String tagletPath) {
        try {
            Object newLastTag;
            ClassLoader tagClassLoader;
            Class<?> customTagClass = null;
            String cpString = null;
            if (fileManager != null && fileManager.hasLocation(DocumentationTool.Location.TAGLET_PATH)) {
                tagClassLoader = fileManager.getClassLoader(DocumentationTool.Location.TAGLET_PATH);
            } else {
                cpString = this.appendPath(System.getProperty("env.class.path"), cpString);
                cpString = this.appendPath(System.getProperty("java.class.path"), cpString);
                cpString = this.appendPath(tagletPath, cpString);
                tagClassLoader = new URLClassLoader(this.pathToURLs(cpString));
            }
            if (this.exportInternalAPI) {
                this.exportInternalAPI(tagClassLoader);
            }
            customTagClass = tagClassLoader.loadClass(classname);
            Method meth = customTagClass.getMethod("register", Map.class);
            Object[] list = this.customTags.values().toArray();
            Taglet lastTag = list != null && list.length > 0 ? (Taglet)list[list.length - 1] : null;
            meth.invoke(null, this.customTags);
            list = this.customTags.values().toArray();
            Object object = newLastTag = list != null && list.length > 0 ? list[list.length - 1] : null;
            if (lastTag != newLastTag) {
                this.message.notice("doclet.Notice_taglet_registered", classname);
                if (newLastTag != null) {
                    this.checkTaglet(newLastTag);
                }
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
            this.message.error("doclet.Error_taglet_not_registered", exc.getClass().getName(), classname);
        }
    }

    private void exportInternalAPI(ClassLoader cl) {
        String[] packages = new String[]{"gw.gosudoc.com.sun.tools.doclets", "gw.gosudoc.com.sun.tools.doclets.standard", "gw.gosudoc.com.sun.tools.doclets.internal.toolkit", "gw.gosudoc.com.sun.tools.doclets.internal.toolkit.taglets", "gw.gosudoc.com.sun.tools.doclets.internal.toolkit.builders", "gw.gosudoc.com.sun.tools.doclets.internal.toolkit.util", "gw.gosudoc.com.sun.tools.doclets.internal.toolkit.util.links", "gw.gosudoc.com.sun.tools.doclets.formats.html", "gw.gosudoc.com.sun.tools.doclets.formats.html.markup"};
        try {
            Method getModuleMethod = Class.class.getDeclaredMethod("getModule", new Class[0]);
            Object thisModule = getModuleMethod.invoke(this.getClass(), new Object[0]);
            Class<?> moduleClass = Class.forName("java.lang.Module");
            Method addExportsMethod = moduleClass.getDeclaredMethod("addExports", String.class, moduleClass);
            Method getUnnamedModuleMethod = ClassLoader.class.getDeclaredMethod("getUnnamedModule", new Class[0]);
            Object target = getUnnamedModuleMethod.invoke((Object)cl, new Object[0]);
            for (String pack : packages) {
                addExportsMethod.invoke(thisModule, pack, target);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String appendPath(String path1, String path2) {
        if (path1 == null || path1.length() == 0) {
            return path2 == null ? "." : path2;
        }
        if (path2 == null || path2.length() == 0) {
            return path1;
        }
        return path1 + File.pathSeparator + path2;
    }

    private URL[] pathToURLs(String path) {
        LinkedHashSet<URL> urls = new LinkedHashSet<URL>();
        for (String s : path.split(File.pathSeparator)) {
            if (s.isEmpty()) continue;
            try {
                urls.add(new File(s).getAbsoluteFile().toURI().toURL());
            }
            catch (MalformedURLException e) {
                this.message.error("doclet.MalformedURL", s);
            }
        }
        return urls.toArray(new URL[urls.size()]);
    }

    public void addNewSimpleCustomTag(String tagName, String header, String locations) {
        if (tagName == null || locations == null) {
            return;
        }
        Taglet tag = this.customTags.get(tagName);
        locations = StringUtils.toLowerCase(locations);
        if (tag == null || header != null) {
            this.customTags.remove(tagName);
            this.customTags.put(tagName, new SimpleTaglet(tagName, header, locations));
            if (locations != null && locations.indexOf(120) == -1) {
                this.checkTagName(tagName);
            }
        } else {
            this.customTags.remove(tagName);
            this.customTags.put(tagName, tag);
        }
    }

    private void checkTagName(String name) {
        if (this.standardTags.contains(name)) {
            this.overridenStandardTags.add(name);
        } else {
            if (name.indexOf(46) == -1) {
                this.potentiallyConflictingTags.add(name);
            }
            this.unseenCustomTags.add(name);
        }
    }

    private void checkTaglet(Object taglet) {
        if (taglet instanceof Taglet) {
            this.checkTagName(((Taglet)taglet).getName());
        } else if (taglet instanceof gw.gosudoc.com.sun.tools.doclets.Taglet) {
            gw.gosudoc.com.sun.tools.doclets.Taglet legacyTaglet = (gw.gosudoc.com.sun.tools.doclets.Taglet)taglet;
            this.customTags.remove(legacyTaglet.getName());
            this.customTags.put(legacyTaglet.getName(), new LegacyTaglet(legacyTaglet));
            this.checkTagName(legacyTaglet.getName());
        } else {
            throw new IllegalArgumentException("Given object is not a taglet.");
        }
    }

    public void seenCustomTag(String name) {
        this.unseenCustomTags.remove(name);
    }

    public void checkTags(Doc doc, Tag[] tags, boolean areInlineTags) {
        if (tags == null) {
            return;
        }
        for (Tag tag : tags) {
            String name = tag.name();
            if (name.length() > 0 && name.charAt(0) == '@') {
                name = name.substring(1, name.length());
            }
            if (!this.standardTags.contains(name) && !this.customTags.containsKey(name)) {
                if (this.standardTagsLowercase.contains(StringUtils.toLowerCase(name))) {
                    this.message.warning(tag.position(), "doclet.UnknownTagLowercase", tag.name());
                    continue;
                }
                this.message.warning(tag.position(), "doclet.UnknownTag", tag.name());
                continue;
            }
            Taglet taglet = this.customTags.get(name);
            if (taglet == null) continue;
            if (areInlineTags && !taglet.isInlineTag()) {
                this.printTagMisuseWarn(taglet, tag, "inline");
            }
            if (doc instanceof RootDoc && !taglet.inOverview()) {
                this.printTagMisuseWarn(taglet, tag, "overview");
                continue;
            }
            if (doc instanceof PackageDoc && !taglet.inPackage()) {
                this.printTagMisuseWarn(taglet, tag, "package");
                continue;
            }
            if (doc instanceof ClassDoc && !taglet.inType()) {
                this.printTagMisuseWarn(taglet, tag, "class");
                continue;
            }
            if (doc instanceof ConstructorDoc && !taglet.inConstructor()) {
                this.printTagMisuseWarn(taglet, tag, "constructor");
                continue;
            }
            if (doc instanceof FieldDoc && !taglet.inField()) {
                this.printTagMisuseWarn(taglet, tag, "field");
                continue;
            }
            if (!(doc instanceof MethodDoc) || taglet.inMethod()) continue;
            this.printTagMisuseWarn(taglet, tag, "method");
        }
    }

    private void printTagMisuseWarn(Taglet taglet, Tag tag, String holderType) {
        String[] locations;
        LinkedHashSet<String> locationsSet = new LinkedHashSet<String>();
        if (taglet.inOverview()) {
            locationsSet.add("overview");
        }
        if (taglet.inPackage()) {
            locationsSet.add("package");
        }
        if (taglet.inType()) {
            locationsSet.add("class/interface");
        }
        if (taglet.inConstructor()) {
            locationsSet.add("constructor");
        }
        if (taglet.inField()) {
            locationsSet.add("field");
        }
        if (taglet.inMethod()) {
            locationsSet.add("method");
        }
        if (taglet.isInlineTag()) {
            locationsSet.add("inline text");
        }
        if ((locations = locationsSet.toArray(new String[0])) == null || locations.length == 0) {
            return;
        }
        StringBuilder combined_locations = new StringBuilder();
        for (int i = 0; i < locations.length; ++i) {
            if (i > 0) {
                combined_locations.append(", ");
            }
            combined_locations.append(locations[i]);
        }
        this.message.warning(tag.position(), "doclet.tag_misuse", "@" + taglet.getName(), holderType, combined_locations.toString());
    }

    public Taglet[] getPackageCustomTaglets() {
        if (this.packageTags == null) {
            this.initCustomTagletArrays();
        }
        return this.packageTags;
    }

    public Taglet[] getTypeCustomTaglets() {
        if (this.typeTags == null) {
            this.initCustomTagletArrays();
        }
        return this.typeTags;
    }

    public Taglet[] getInlineCustomTaglets() {
        if (this.inlineTags == null) {
            this.initCustomTagletArrays();
        }
        return this.inlineTags;
    }

    public Taglet[] getFieldCustomTaglets() {
        if (this.fieldTags == null) {
            this.initCustomTagletArrays();
        }
        return this.fieldTags;
    }

    public Taglet[] getSerializedFormTaglets() {
        if (this.serializedFormTags == null) {
            this.initCustomTagletArrays();
        }
        return this.serializedFormTags;
    }

    public Taglet[] getCustomTaglets(Doc doc) {
        if (doc instanceof ConstructorDoc) {
            return this.getConstructorCustomTaglets();
        }
        if (doc instanceof MethodDoc) {
            return this.getMethodCustomTaglets();
        }
        if (doc instanceof FieldDoc) {
            return this.getFieldCustomTaglets();
        }
        if (doc instanceof ClassDoc) {
            return this.getTypeCustomTaglets();
        }
        if (doc instanceof PackageDoc) {
            return this.getPackageCustomTaglets();
        }
        if (doc instanceof RootDoc) {
            return this.getOverviewCustomTaglets();
        }
        return null;
    }

    public Taglet[] getConstructorCustomTaglets() {
        if (this.constructorTags == null) {
            this.initCustomTagletArrays();
        }
        return this.constructorTags;
    }

    public Taglet[] getMethodCustomTaglets() {
        if (this.methodTags == null) {
            this.initCustomTagletArrays();
        }
        return this.methodTags;
    }

    public Taglet[] getOverviewCustomTaglets() {
        if (this.overviewTags == null) {
            this.initCustomTagletArrays();
        }
        return this.overviewTags;
    }

    private void initCustomTagletArrays() {
        Iterator<Taglet> it = this.customTags.values().iterator();
        ArrayList<Taglet> pTags = new ArrayList<Taglet>(this.customTags.size());
        ArrayList<Taglet> tTags = new ArrayList<Taglet>(this.customTags.size());
        ArrayList<Taglet> fTags = new ArrayList<Taglet>(this.customTags.size());
        ArrayList<Taglet> cTags = new ArrayList<Taglet>(this.customTags.size());
        ArrayList<Taglet> mTags = new ArrayList<Taglet>(this.customTags.size());
        ArrayList<Taglet> iTags = new ArrayList<Taglet>(this.customTags.size());
        ArrayList<Taglet> oTags = new ArrayList<Taglet>(this.customTags.size());
        ArrayList<Taglet> sTags = new ArrayList<Taglet>();
        while (it.hasNext()) {
            Taglet current = it.next();
            if (current.inPackage() && !current.isInlineTag()) {
                pTags.add(current);
            }
            if (current.inType() && !current.isInlineTag()) {
                tTags.add(current);
            }
            if (current.inField() && !current.isInlineTag()) {
                fTags.add(current);
            }
            if (current.inConstructor() && !current.isInlineTag()) {
                cTags.add(current);
            }
            if (current.inMethod() && !current.isInlineTag()) {
                mTags.add(current);
            }
            if (current.isInlineTag()) {
                iTags.add(current);
            }
            if (!current.inOverview() || current.isInlineTag()) continue;
            oTags.add(current);
        }
        this.packageTags = pTags.toArray(new Taglet[0]);
        this.typeTags = tTags.toArray(new Taglet[0]);
        this.fieldTags = fTags.toArray(new Taglet[0]);
        this.constructorTags = cTags.toArray(new Taglet[0]);
        this.methodTags = mTags.toArray(new Taglet[0]);
        this.overviewTags = oTags.toArray(new Taglet[0]);
        this.inlineTags = iTags.toArray(new Taglet[0]);
        sTags.add(this.customTags.get("serialData"));
        sTags.add(this.customTags.get("throws"));
        if (!this.nosince) {
            sTags.add(this.customTags.get("since"));
        }
        sTags.add(this.customTags.get("see"));
        this.serializedFormTags = sTags.toArray(new Taglet[0]);
    }

    private void initStandardTaglets() {
        if (this.javafx) {
            this.initJavaFXTaglets();
        }
        this.addStandardTaglet(new ParamTaglet());
        this.addStandardTaglet(new ReturnTaglet());
        this.addStandardTaglet(new ThrowsTaglet());
        this.addStandardTaglet(new SimpleTaglet("exception", null, "mc"));
        this.addStandardTaglet(!this.nosince, new SimpleTaglet("since", this.message.getText("doclet.Since", new Object[0]), "a"));
        this.addStandardTaglet(this.showversion, new SimpleTaglet("version", this.message.getText("doclet.Version", new Object[0]), "pto"));
        this.addStandardTaglet(this.showauthor, new SimpleTaglet("author", this.message.getText("doclet.Author", new Object[0]), "pto"));
        this.addStandardTaglet(new SimpleTaglet("serialData", this.message.getText("doclet.SerialData", new Object[0]), "x"));
        SimpleTaglet temp = new SimpleTaglet("factory", this.message.getText("doclet.Factory", new Object[0]), "m");
        this.customTags.put(temp.getName(), temp);
        this.addStandardTaglet(new SeeTaglet());
        this.addStandardTaglet(new DocRootTaglet());
        this.addStandardTaglet(new InheritDocTaglet());
        this.addStandardTaglet(new ValueTaglet());
        this.addStandardTaglet(new LiteralTaglet());
        this.addStandardTaglet(new CodeTaglet());
        this.addStandardTaglet(new IndexTaglet());
        this.standardTags.add("deprecated");
        this.standardTags.add("link");
        this.standardTags.add("linkplain");
        this.standardTags.add("serial");
        this.standardTags.add("serialField");
        this.standardTags.add("Text");
    }

    private void initJavaFXTaglets() {
        this.addStandardTaglet(new PropertyGetterTaglet());
        this.addStandardTaglet(new PropertySetterTaglet());
        this.addStandardTaglet(new SimpleTaglet("propertyDescription", this.message.getText("doclet.PropertyDescription", new Object[0]), "fm"));
        this.addStandardTaglet(new SimpleTaglet("defaultValue", this.message.getText("doclet.DefaultValue", new Object[0]), "fm"));
        this.addStandardTaglet(new SimpleTaglet("treatAsPrivate", null, "fmt"));
    }

    void addStandardTaglet(Taglet taglet) {
        String name = taglet.getName();
        this.customTags.put(name, taglet);
        this.standardTags.add(name);
    }

    void addStandardTaglet(boolean enable, Taglet taglet) {
        String name = taglet.getName();
        if (enable) {
            this.customTags.put(name, taglet);
        }
        this.standardTags.add(name);
    }

    private void initStandardTagsLowercase() {
        for (String standardTag : this.standardTags) {
            this.standardTagsLowercase.add(StringUtils.toLowerCase(standardTag));
        }
    }

    public boolean isKnownCustomTag(String tagName) {
        return this.customTags.containsKey(tagName);
    }

    public void printReport() {
        this.printReportHelper("doclet.Notice_taglet_conflict_warn", this.potentiallyConflictingTags);
        this.printReportHelper("doclet.Notice_taglet_overriden", this.overridenStandardTags);
        this.printReportHelper("doclet.Notice_taglet_unseen", this.unseenCustomTags);
    }

    private void printReportHelper(String noticeKey, Set<String> names) {
        if (names.size() > 0) {
            String[] namesArray = names.toArray(new String[0]);
            Object result = " ";
            for (int i = 0; i < namesArray.length; ++i) {
                result = (String)result + "@" + namesArray[i];
                if (i + 1 >= namesArray.length) continue;
                result = (String)result + ", ";
            }
            this.message.notice(noticeKey, result);
        }
    }

    public Taglet getTaglet(String name) {
        if (name.indexOf("@") == 0) {
            return this.customTags.get(name.substring(1));
        }
        return this.customTags.get(name);
    }
}

