/*
 * Decompiled with CFR 0.152.
 */
package gw.gosudoc.com.sun.tools.doclets.internal.toolkit.builders;

import com.sun.tools.javac.util.StringUtils;
import gw.gosudoc.com.sun.javadoc.ClassDoc;
import gw.gosudoc.com.sun.javadoc.Doc;
import gw.gosudoc.com.sun.javadoc.FieldDoc;
import gw.gosudoc.com.sun.javadoc.MemberDoc;
import gw.gosudoc.com.sun.javadoc.MethodDoc;
import gw.gosudoc.com.sun.javadoc.PackageDoc;
import gw.gosudoc.com.sun.javadoc.SerialFieldTag;
import gw.gosudoc.com.sun.javadoc.Tag;
import gw.gosudoc.com.sun.tools.doclets.internal.toolkit.Content;
import gw.gosudoc.com.sun.tools.doclets.internal.toolkit.SerializedFormWriter;
import gw.gosudoc.com.sun.tools.doclets.internal.toolkit.builders.AbstractBuilder;
import gw.gosudoc.com.sun.tools.doclets.internal.toolkit.builders.XMLNode;
import gw.gosudoc.com.sun.tools.doclets.internal.toolkit.util.DocletAbortException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;

@Deprecated
public class SerializedFormBuilder
extends AbstractBuilder {
    public static final String NAME = "SerializedForm";
    private SerializedFormWriter writer;
    private SerializedFormWriter.SerialFieldWriter fieldWriter;
    private SerializedFormWriter.SerialMethodWriter methodWriter;
    private static final String SERIAL_VERSION_UID_HEADER = "serialVersionUID:";
    private PackageDoc currentPackage;
    private ClassDoc currentClass;
    protected MemberDoc currentMember;
    private Content contentTree;

    private SerializedFormBuilder(AbstractBuilder.Context context) {
        super(context);
    }

    public static SerializedFormBuilder getInstance(AbstractBuilder.Context context) {
        return new SerializedFormBuilder(context);
    }

    @Override
    public void build() throws IOException {
        if (!this.serialClassFoundToDocument(this.configuration.root.classes())) {
            return;
        }
        try {
            this.writer = this.configuration.getWriterFactory().getSerializedFormWriter();
            if (this.writer == null) {
                return;
            }
        }
        catch (Exception e) {
            throw new DocletAbortException(e);
        }
        this.build(this.layoutParser.parseXML(NAME), this.contentTree);
        this.writer.close();
    }

    @Override
    public String getName() {
        return NAME;
    }

    public void buildSerializedForm(XMLNode node, Content serializedTree) throws Exception {
        serializedTree = this.writer.getHeader(this.configuration.getText("doclet.Serialized_Form"));
        this.buildChildren(node, serializedTree);
        this.writer.addFooter(serializedTree);
        this.writer.printDocument(serializedTree);
        this.writer.close();
    }

    public void buildSerializedFormSummaries(XMLNode node, Content serializedTree) {
        Content serializedSummariesTree = this.writer.getSerializedSummariesHeader();
        Iterator iterator = this.configuration.packages.iterator();
        while (iterator.hasNext()) {
            PackageDoc pkg;
            this.currentPackage = pkg = (PackageDoc)iterator.next();
            this.buildChildren(node, serializedSummariesTree);
        }
        serializedTree.addContent(this.writer.getSerializedContent(serializedSummariesTree));
    }

    public void buildPackageSerializedForm(XMLNode node, Content serializedSummariesTree) {
        Content packageSerializedTree = this.writer.getPackageSerializedHeader();
        String foo = this.currentPackage.name();
        ClassDoc[] classes = this.currentPackage.allClasses(false);
        if (classes == null || classes.length == 0) {
            return;
        }
        if (!SerializedFormBuilder.serialInclude(this.currentPackage)) {
            return;
        }
        if (!this.serialClassFoundToDocument(classes)) {
            return;
        }
        this.buildChildren(node, packageSerializedTree);
        this.writer.addPackageSerializedTree(serializedSummariesTree, packageSerializedTree);
    }

    public void buildPackageHeader(XMLNode node, Content packageSerializedTree) {
        packageSerializedTree.addContent(this.writer.getPackageHeader(this.utils.getPackageName(this.currentPackage)));
    }

    public void buildClassSerializedForm(XMLNode node, Content packageSerializedTree) {
        Content classSerializedTree = this.writer.getClassSerializedHeader();
        Object[] classes = this.currentPackage.allClasses(false);
        Arrays.sort(classes);
        Object[] objectArray = classes;
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            Object classDoc;
            this.currentClass = classDoc = objectArray[i];
            this.fieldWriter = this.writer.getSerialFieldWriter(this.currentClass);
            this.methodWriter = this.writer.getSerialMethodWriter(this.currentClass);
            if (!this.currentClass.isClass() || !this.currentClass.isSerializable() || !SerializedFormBuilder.serialClassInclude(this.currentClass)) continue;
            Content classTree = this.writer.getClassHeader(this.currentClass);
            this.buildChildren(node, classTree);
            classSerializedTree.addContent(classTree);
        }
        packageSerializedTree.addContent(classSerializedTree);
    }

    public void buildSerialUIDInfo(XMLNode node, Content classTree) {
        Content serialUidTree = this.writer.getSerialUIDInfoHeader();
        for (FieldDoc field : this.currentClass.fields(false)) {
            if (!field.name().equals("serialVersionUID") || field.constantValueExpression() == null) continue;
            this.writer.addSerialUIDInfo(SERIAL_VERSION_UID_HEADER, field.constantValueExpression(), serialUidTree);
            break;
        }
        classTree.addContent(serialUidTree);
    }

    public void buildClassContent(XMLNode node, Content classTree) {
        Content classContentTree = this.writer.getClassContentHeader();
        this.buildChildren(node, classContentTree);
        classTree.addContent(classContentTree);
    }

    public void buildSerializableMethods(XMLNode node, Content classContentTree) {
        Content serializableMethodTree = this.methodWriter.getSerializableMethodsHeader();
        MethodDoc[] members = this.currentClass.serializationMethods();
        int membersLength = members.length;
        if (membersLength > 0) {
            for (int i = 0; i < membersLength; ++i) {
                this.currentMember = members[i];
                Content methodsContentTree = this.methodWriter.getMethodsContentHeader(i == membersLength - 1);
                this.buildChildren(node, methodsContentTree);
                serializableMethodTree.addContent(methodsContentTree);
            }
        }
        if (this.currentClass.serializationMethods().length > 0) {
            classContentTree.addContent(this.methodWriter.getSerializableMethods(this.configuration.getText("doclet.Serialized_Form_methods"), serializableMethodTree));
            if (this.currentClass.isSerializable() && !this.currentClass.isExternalizable() && this.currentClass.serializationMethods().length == 0) {
                Content noCustomizationMsg = this.methodWriter.getNoCustomizationMsg(this.configuration.getText("doclet.Serializable_no_customization"));
                classContentTree.addContent(this.methodWriter.getSerializableMethods(this.configuration.getText("doclet.Serialized_Form_methods"), noCustomizationMsg));
            }
        }
    }

    public void buildMethodSubHeader(XMLNode node, Content methodsContentTree) {
        this.methodWriter.addMemberHeader((MethodDoc)this.currentMember, methodsContentTree);
    }

    public void buildDeprecatedMethodInfo(XMLNode node, Content methodsContentTree) {
        this.methodWriter.addDeprecatedMemberInfo((MethodDoc)this.currentMember, methodsContentTree);
    }

    public void buildMethodInfo(XMLNode node, Content methodsContentTree) {
        if (this.configuration.nocomment) {
            return;
        }
        this.buildChildren(node, methodsContentTree);
    }

    public void buildMethodDescription(XMLNode node, Content methodsContentTree) {
        this.methodWriter.addMemberDescription((MethodDoc)this.currentMember, methodsContentTree);
    }

    public void buildMethodTags(XMLNode node, Content methodsContentTree) {
        this.methodWriter.addMemberTags((MethodDoc)this.currentMember, methodsContentTree);
        MethodDoc method = (MethodDoc)this.currentMember;
        if (method.name().compareTo("writeExternal") == 0 && method.tags("serialData").length == 0 && this.configuration.serialwarn) {
            this.configuration.getDocletSpecificMsg().warning(this.currentMember.position(), "doclet.MissingSerialDataTag", method.containingClass().qualifiedName(), method.name());
        }
    }

    public void buildFieldHeader(XMLNode node, Content classContentTree) {
        if (this.currentClass.serializableFields().length > 0) {
            this.buildFieldSerializationOverview(this.currentClass, classContentTree);
        }
    }

    public void buildFieldSerializationOverview(ClassDoc classDoc, Content classContentTree) {
        FieldDoc serialPersistentField;
        if (classDoc.definesSerializableFields() && this.fieldWriter.shouldPrintOverview(serialPersistentField = classDoc.serializableFields()[0])) {
            Content serializableFieldsTree = this.fieldWriter.getSerializableFieldsHeader();
            Content fieldsOverviewContentTree = this.fieldWriter.getFieldsContentHeader(true);
            this.fieldWriter.addMemberDeprecatedInfo(serialPersistentField, fieldsOverviewContentTree);
            if (!this.configuration.nocomment) {
                this.fieldWriter.addMemberDescription(serialPersistentField, fieldsOverviewContentTree);
                this.fieldWriter.addMemberTags(serialPersistentField, fieldsOverviewContentTree);
            }
            serializableFieldsTree.addContent(fieldsOverviewContentTree);
            classContentTree.addContent(this.fieldWriter.getSerializableFields(this.configuration.getText("doclet.Serialized_Form_class"), serializableFieldsTree));
        }
    }

    public void buildSerializableFields(XMLNode node, Content classContentTree) {
        FieldDoc[] members = this.currentClass.serializableFields();
        int membersLength = members.length;
        if (membersLength > 0) {
            Content serializableFieldsTree = this.fieldWriter.getSerializableFieldsHeader();
            for (int i = 0; i < membersLength; ++i) {
                this.currentMember = members[i];
                if (!this.currentClass.definesSerializableFields()) {
                    Content fieldsContentTree = this.fieldWriter.getFieldsContentHeader(i == membersLength - 1);
                    this.buildChildren(node, fieldsContentTree);
                    serializableFieldsTree.addContent(fieldsContentTree);
                    continue;
                }
                this.buildSerialFieldTagsInfo(serializableFieldsTree);
            }
            classContentTree.addContent(this.fieldWriter.getSerializableFields(this.configuration.getText("doclet.Serialized_Form_fields"), serializableFieldsTree));
        }
    }

    public void buildFieldSubHeader(XMLNode node, Content fieldsContentTree) {
        if (!this.currentClass.definesSerializableFields()) {
            FieldDoc field = (FieldDoc)this.currentMember;
            this.fieldWriter.addMemberHeader(field.type().asClassDoc(), field.type().typeName(), field.type().dimension(), field.name(), fieldsContentTree);
        }
    }

    public void buildFieldDeprecationInfo(XMLNode node, Content fieldsContentTree) {
        if (!this.currentClass.definesSerializableFields()) {
            FieldDoc field = (FieldDoc)this.currentMember;
            this.fieldWriter.addMemberDeprecatedInfo(field, fieldsContentTree);
        }
    }

    public void buildSerialFieldTagsInfo(Content serializableFieldsTree) {
        if (this.configuration.nocomment) {
            return;
        }
        FieldDoc field = (FieldDoc)this.currentMember;
        Object[] tags = field.serialFieldTags();
        Arrays.sort(tags);
        int tagsLength = tags.length;
        for (int i = 0; i < tagsLength; ++i) {
            if (tags[i].fieldName() == null || tags[i].fieldType() == null) continue;
            Content fieldsContentTree = this.fieldWriter.getFieldsContentHeader(i == tagsLength - 1);
            this.fieldWriter.addMemberHeader(tags[i].fieldTypeDoc(), tags[i].fieldType(), "", tags[i].fieldName(), fieldsContentTree);
            this.fieldWriter.addMemberDescription((SerialFieldTag)tags[i], fieldsContentTree);
            serializableFieldsTree.addContent(fieldsContentTree);
        }
    }

    public void buildFieldInfo(XMLNode node, Content fieldsContentTree) {
        if (this.configuration.nocomment) {
            return;
        }
        FieldDoc field = (FieldDoc)this.currentMember;
        ClassDoc cd = field.containingClass();
        if (field.tags("serial").length == 0 && !field.isSynthetic() && this.configuration.serialwarn) {
            this.configuration.message.warning(field.position(), "doclet.MissingSerialTag", cd.qualifiedName(), field.name());
        }
        this.fieldWriter.addMemberDescription(field, fieldsContentTree);
        this.fieldWriter.addMemberTags(field, fieldsContentTree);
    }

    public static boolean serialInclude(Doc doc) {
        if (doc == null) {
            return false;
        }
        return doc.isClass() ? SerializedFormBuilder.serialClassInclude((ClassDoc)doc) : SerializedFormBuilder.serialDocInclude(doc);
    }

    private static boolean serialClassInclude(ClassDoc cd) {
        if (cd.isEnum()) {
            return false;
        }
        try {
            cd.superclassType();
        }
        catch (NullPointerException e) {
            return false;
        }
        if (cd.isSerializable()) {
            if (cd.tags("serial").length > 0) {
                return SerializedFormBuilder.serialDocInclude(cd);
            }
            return cd.isPublic() || cd.isProtected();
        }
        return false;
    }

    private static boolean serialDocInclude(Doc doc) {
        if (doc.isEnum()) {
            return false;
        }
        Tag[] serial = doc.tags("serial");
        if (serial.length > 0) {
            String serialtext = StringUtils.toLowerCase(serial[0].text());
            if (serialtext.contains("exclude")) {
                return false;
            }
            if (serialtext.contains("include")) {
                return true;
            }
        }
        return true;
    }

    private boolean serialClassFoundToDocument(ClassDoc[] classes) {
        for (ClassDoc aClass : classes) {
            if (!SerializedFormBuilder.serialClassInclude(aClass)) continue;
            return true;
        }
        return false;
    }
}

