/*
 * Decompiled with CFR 0.152.
 */
package gw.gosudoc.com.sun.tools.doclets.formats.html;

import gw.gosudoc.com.sun.javadoc.ClassDoc;
import gw.gosudoc.com.sun.javadoc.Doc;
import gw.gosudoc.com.sun.javadoc.ExecutableMemberDoc;
import gw.gosudoc.com.sun.javadoc.MemberDoc;
import gw.gosudoc.com.sun.javadoc.PackageDoc;
import gw.gosudoc.com.sun.javadoc.ProgramElementDoc;
import gw.gosudoc.com.sun.javadoc.Tag;
import gw.gosudoc.com.sun.tools.doclets.formats.html.ConfigurationImpl;
import gw.gosudoc.com.sun.tools.doclets.formats.html.HtmlDocletWriter;
import gw.gosudoc.com.sun.tools.doclets.formats.html.LinkInfoImpl;
import gw.gosudoc.com.sun.tools.doclets.formats.html.SearchIndexItem;
import gw.gosudoc.com.sun.tools.doclets.formats.html.markup.HtmlConstants;
import gw.gosudoc.com.sun.tools.doclets.formats.html.markup.HtmlStyle;
import gw.gosudoc.com.sun.tools.doclets.formats.html.markup.HtmlTag;
import gw.gosudoc.com.sun.tools.doclets.formats.html.markup.HtmlTree;
import gw.gosudoc.com.sun.tools.doclets.formats.html.markup.StringContent;
import gw.gosudoc.com.sun.tools.doclets.internal.toolkit.Content;
import gw.gosudoc.com.sun.tools.doclets.internal.toolkit.util.DocFile;
import gw.gosudoc.com.sun.tools.doclets.internal.toolkit.util.DocPath;
import gw.gosudoc.com.sun.tools.doclets.internal.toolkit.util.DocPaths;
import gw.gosudoc.com.sun.tools.doclets.internal.toolkit.util.DocletAbortException;
import gw.gosudoc.com.sun.tools.doclets.internal.toolkit.util.IndexBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

@Deprecated
public class AbstractIndexWriter
extends HtmlDocletWriter {
    protected IndexBuilder indexbuilder;

    protected AbstractIndexWriter(ConfigurationImpl configuration, DocPath path, IndexBuilder indexbuilder) throws IOException {
        super(configuration, path);
        this.indexbuilder = indexbuilder;
    }

    @Override
    protected Content getNavLinkIndex() {
        HtmlTree li = HtmlTree.LI(HtmlStyle.navBarCell1Rev, this.indexLabel);
        return li;
    }

    protected void addContents(Character uc, List<? extends Doc> memberlist, Content contentTree) {
        this.addHeading(uc, contentTree);
        int memberListSize = memberlist.size();
        if (memberListSize > 0) {
            HtmlTree dl = new HtmlTree(HtmlTag.DL);
            for (Doc doc : memberlist) {
                this.addDescription(dl, doc);
            }
            contentTree.addContent(dl);
        }
    }

    protected void addSearchContents(Character uc, List<SearchIndexItem> searchList, Content contentTree) {
        this.addHeading(uc, contentTree);
        if (!searchList.isEmpty()) {
            HtmlTree dl = new HtmlTree(HtmlTag.DL);
            for (SearchIndexItem sii : searchList) {
                this.addDescription(sii, dl);
            }
            contentTree.addContent(dl);
        }
    }

    protected void addContents(Character uc, List<? extends Doc> memberlist, List<SearchIndexItem> searchList, Content contentTree) {
        this.addHeading(uc, contentTree);
        int memberListSize = memberlist.size();
        int searchListSize = searchList.size();
        int i = 0;
        int j = 0;
        HtmlTree dl = new HtmlTree(HtmlTag.DL);
        while (i < memberListSize && j < searchListSize) {
            if (memberlist.get(i).name().compareTo(searchList.get(j).getLabel()) < 0) {
                this.addDescription(dl, memberlist.get(i));
                ++i;
                continue;
            }
            if (memberlist.get(i).name().compareTo(searchList.get(j).getLabel()) > 0) {
                this.addDescription(searchList.get(j), dl);
                ++j;
                continue;
            }
            this.addDescription(dl, memberlist.get(i));
            this.addDescription(searchList.get(j), dl);
            ++j;
            ++i;
        }
        if (i >= memberListSize) {
            while (j < searchListSize) {
                this.addDescription(searchList.get(j), dl);
                ++j;
            }
        }
        if (j >= searchListSize) {
            while (i < memberListSize) {
                this.addDescription(dl, memberlist.get(i));
                ++i;
            }
        }
        contentTree.addContent(dl);
    }

    protected void addHeading(Character uc, Content contentTree) {
        String unicode = uc.toString();
        contentTree.addContent(this.getMarkerAnchorForIndex(unicode));
        StringContent headContent = new StringContent(unicode);
        HtmlTree heading = HtmlTree.HEADING(HtmlConstants.CONTENT_HEADING, false, HtmlStyle.title, headContent);
        contentTree.addContent(heading);
    }

    protected void addDescription(Content dl, Doc element) {
        SearchIndexItem si = new SearchIndexItem();
        if (element instanceof MemberDoc) {
            this.addDescription((MemberDoc)element, dl, si);
            this.configuration.memberSearchIndex.add(si);
        } else if (element instanceof ClassDoc) {
            this.addDescription((ClassDoc)element, dl, si);
            this.configuration.typeSearchIndex.add(si);
        } else if (element instanceof PackageDoc) {
            this.addDescription((PackageDoc)element, dl, si);
            this.configuration.packageSearchIndex.add(si);
        }
    }

    protected void addDescription(PackageDoc pkg, Content dlTree, SearchIndexItem si) {
        Content link = this.getPackageLink(pkg, new StringContent(this.utils.getPackageName(pkg)));
        si.setLabel(this.utils.getPackageName(pkg));
        si.setCategory(this.getResource("doclet.Packages").toString());
        HtmlTree dt = HtmlTree.DT(link);
        ((Content)dt).addContent(" - ");
        ((Content)dt).addContent(this.getResource("doclet.package"));
        ((Content)dt).addContent(" " + pkg.name());
        dlTree.addContent(dt);
        HtmlTree dd = new HtmlTree(HtmlTag.DD);
        this.addSummaryComment(pkg, dd);
        dlTree.addContent(dd);
    }

    protected void addDescription(ClassDoc cd, Content dlTree, SearchIndexItem si) {
        Content link = this.getLink(new LinkInfoImpl(this.configuration, LinkInfoImpl.Kind.INDEX, cd).strong(true));
        si.setContainingPackage(this.utils.getPackageName(cd.containingPackage()));
        si.setLabel(cd.typeName());
        si.setCategory(this.getResource("doclet.Types").toString());
        HtmlTree dt = HtmlTree.DT(link);
        ((Content)dt).addContent(" - ");
        this.addClassInfo(cd, dt);
        dlTree.addContent(dt);
        HtmlTree dd = new HtmlTree(HtmlTag.DD);
        this.addComment(cd, dd);
        dlTree.addContent(dd);
    }

    protected void addClassInfo(ClassDoc cd, Content contentTree) {
        contentTree.addContent(this.getResource("doclet.in", this.utils.getTypeName(this.configuration, cd, false), this.getPackageLink(cd.containingPackage(), this.utils.getPackageName(cd.containingPackage()))));
    }

    protected void addDescription(MemberDoc member, Content dlTree, SearchIndexItem si) {
        String name = member instanceof ExecutableMemberDoc ? member.name() + ((ExecutableMemberDoc)member).flatSignature() : member.name();
        si.setContainingPackage(this.utils.getPackageName(member.containingClass().containingPackage()));
        si.setContainingClass(member.containingClass().typeName());
        if (member instanceof ExecutableMemberDoc) {
            ExecutableMemberDoc emd = (ExecutableMemberDoc)member;
            si.setLabel(member.name() + emd.flatSignature());
            if (!emd.signature().equals(emd.flatSignature())) {
                si.setUrl(this.getName(this.getAnchor((ExecutableMemberDoc)member)));
            }
        } else {
            si.setLabel(member.name());
        }
        si.setCategory(this.getResource("doclet.Members").toString());
        HtmlTree span = HtmlTree.SPAN(HtmlStyle.memberNameLink, this.getDocLink(LinkInfoImpl.Kind.INDEX, member, name));
        HtmlTree dt = HtmlTree.DT(span);
        ((Content)dt).addContent(" - ");
        this.addMemberDesc(member, dt);
        dlTree.addContent(dt);
        HtmlTree dd = new HtmlTree(HtmlTag.DD);
        this.addComment(member, dd);
        dlTree.addContent(dd);
    }

    protected void addDescription(SearchIndexItem sii, Content dlTree) {
        Object path = this.pathToRoot.isEmpty() ? "" : this.pathToRoot.getPath() + "/";
        path = (String)path + sii.getUrl();
        HtmlTree labelLink = HtmlTree.A((String)path, new StringContent(sii.getLabel()));
        HtmlTree dt = HtmlTree.DT(HtmlTree.SPAN(HtmlStyle.searchTagLink, labelLink));
        ((Content)dt).addContent(" - ");
        ((Content)dt).addContent(this.getResource("doclet.Search_tag_in", sii.getHolder()));
        dlTree.addContent(dt);
        HtmlTree dd = new HtmlTree(HtmlTag.DD);
        if (sii.getDescription().isEmpty()) {
            ((Content)dd).addContent(this.getSpace());
        } else {
            ((Content)dd).addContent(sii.getDescription());
        }
        dlTree.addContent(dd);
    }

    protected void addComment(ProgramElementDoc element, Content contentTree) {
        HtmlTree span = HtmlTree.SPAN(HtmlStyle.deprecatedLabel, this.deprecatedPhrase);
        HtmlTree div = new HtmlTree(HtmlTag.DIV);
        div.addStyle(HtmlStyle.block);
        if (this.utils.isDeprecated(element)) {
            div.addContent(span);
            Tag[] tags = element.tags("deprecated");
            if (tags.length > 0) {
                this.addInlineDeprecatedComment(element, tags[0], div);
            }
            contentTree.addContent(div);
        } else {
            for (ClassDoc cont = element.containingClass(); cont != null; cont = cont.containingClass()) {
                if (!this.utils.isDeprecated(cont)) continue;
                div.addContent(span);
                contentTree.addContent(div);
                break;
            }
            this.addSummaryComment(element, contentTree);
        }
    }

    protected void addMemberDesc(MemberDoc member, Content contentTree) {
        ClassDoc containing = member.containingClass();
        String classdesc = this.utils.getTypeName(this.configuration, containing, true) + " ";
        if (member.isField()) {
            if (member.isStatic()) {
                contentTree.addContent(this.getResource("doclet.Static_variable_in", classdesc));
            } else {
                contentTree.addContent(this.getResource("doclet.Variable_in", classdesc));
            }
        } else if (member.isConstructor()) {
            contentTree.addContent(this.getResource("doclet.Constructor_for", classdesc));
        } else if (member.isMethod()) {
            if (member.isStatic()) {
                contentTree.addContent(this.getResource("doclet.Static_method_in", classdesc));
            } else {
                contentTree.addContent(this.getResource("doclet.Method_in", classdesc));
            }
        }
        this.addPreQualifiedClassLink(LinkInfoImpl.Kind.INDEX, containing, false, contentTree);
    }

    public Content getMarkerAnchorForIndex(String anchorNameForIndex) {
        return this.getMarkerAnchor(this.getNameForIndex(anchorNameForIndex), null);
    }

    public String getNameForIndex(String unicode) {
        return "I:" + this.getName(unicode);
    }

    protected void createSearchIndexFiles() {
        this.createSearchIndexFile(DocPaths.PACKAGE_SEARCH_INDEX_JSON, DocPaths.PACKAGE_SEARCH_INDEX_ZIP, this.configuration.packageSearchIndex);
        this.createSearchIndexFile(DocPaths.TYPE_SEARCH_INDEX_JSON, DocPaths.TYPE_SEARCH_INDEX_ZIP, this.configuration.typeSearchIndex);
        this.createSearchIndexFile(DocPaths.MEMBER_SEARCH_INDEX_JSON, DocPaths.MEMBER_SEARCH_INDEX_ZIP, this.configuration.memberSearchIndex);
        this.createSearchIndexFile(DocPaths.TAG_SEARCH_INDEX_JSON, DocPaths.TAG_SEARCH_INDEX_ZIP, this.configuration.tagSearchIndex);
    }

    protected void createSearchIndexFile(DocPath searchIndexFile, DocPath searchIndexZip, List<SearchIndexItem> searchIndex) {
        if (!searchIndex.isEmpty()) {
            try {
                StringBuilder searchVar = new StringBuilder("[");
                boolean first = true;
                DocFile searchFile = DocFile.createFileForOutput(this.configuration, searchIndexFile);
                Path p = Paths.get(searchFile.getPath(), new String[0]);
                for (SearchIndexItem item : searchIndex) {
                    if (first) {
                        searchVar.append(item.toString());
                        first = false;
                        continue;
                    }
                    searchVar.append(",").append(item.toString());
                }
                searchVar.append("]");
                Files.write(p, searchVar.toString().getBytes(), new OpenOption[0]);
                DocFile zipFile = DocFile.createFileForOutput(this.configuration, searchIndexZip);
                try (FileOutputStream fos = new FileOutputStream(zipFile.getPath());
                     ZipOutputStream zos = new ZipOutputStream(fos);){
                    this.zipFile(searchFile.getPath(), searchIndexFile, zos);
                }
                Files.delete(p);
            }
            catch (IOException ie) {
                throw new DocletAbortException(ie);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void zipFile(String inputFile, DocPath file, ZipOutputStream zos) {
        try {
            try {
                ZipEntry ze = new ZipEntry(file.getPath());
                zos.putNextEntry(ze);
                try (FileInputStream fis = new FileInputStream(new File(inputFile));){
                    byte[] buf = new byte[2048];
                    int len = fis.read(buf);
                    while (len > 0) {
                        zos.write(buf, 0, len);
                        len = fis.read(buf);
                    }
                }
            }
            finally {
                zos.closeEntry();
            }
        }
        catch (IOException e) {
            throw new DocletAbortException(e);
        }
    }
}

