/*
 * Decompiled with CFR 0.152.
 */
package gw.gosudoc.com.sun.tools.doclets.internal.toolkit.builders;

import gw.gosudoc.com.sun.javadoc.AnnotationTypeDoc;
import gw.gosudoc.com.sun.javadoc.ClassDoc;
import gw.gosudoc.com.sun.javadoc.MethodDoc;
import gw.gosudoc.com.sun.javadoc.ProgramElementDoc;
import gw.gosudoc.com.sun.javadoc.Tag;
import gw.gosudoc.com.sun.tools.doclets.internal.toolkit.AnnotationTypeWriter;
import gw.gosudoc.com.sun.tools.doclets.internal.toolkit.ClassWriter;
import gw.gosudoc.com.sun.tools.doclets.internal.toolkit.Content;
import gw.gosudoc.com.sun.tools.doclets.internal.toolkit.MemberSummaryWriter;
import gw.gosudoc.com.sun.tools.doclets.internal.toolkit.WriterFactory;
import gw.gosudoc.com.sun.tools.doclets.internal.toolkit.builders.AbstractBuilder;
import gw.gosudoc.com.sun.tools.doclets.internal.toolkit.builders.AbstractMemberBuilder;
import gw.gosudoc.com.sun.tools.doclets.internal.toolkit.builders.XMLNode;
import gw.gosudoc.com.sun.tools.doclets.internal.toolkit.util.DocFinder;
import gw.gosudoc.com.sun.tools.doclets.internal.toolkit.util.VisibleMemberMap;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

@Deprecated
public class MemberSummaryBuilder
extends AbstractMemberBuilder {
    public static final String NAME = "MemberSummary";
    private final VisibleMemberMap[] visibleMemberMaps;
    private MemberSummaryWriter[] memberSummaryWriters;
    private final ClassDoc classDoc;

    private MemberSummaryBuilder(AbstractBuilder.Context context, ClassDoc classDoc) {
        super(context);
        this.classDoc = classDoc;
        this.visibleMemberMaps = new VisibleMemberMap[9];
        for (int i = 0; i < 9; ++i) {
            this.visibleMemberMaps[i] = new VisibleMemberMap(classDoc, i, this.configuration);
        }
    }

    public static MemberSummaryBuilder getInstance(ClassWriter classWriter, AbstractBuilder.Context context) throws Exception {
        MemberSummaryBuilder builder = new MemberSummaryBuilder(context, classWriter.getClassDoc());
        builder.memberSummaryWriters = new MemberSummaryWriter[9];
        WriterFactory wf = context.configuration.getWriterFactory();
        for (int i = 0; i < 9; ++i) {
            builder.memberSummaryWriters[i] = builder.visibleMemberMaps[i].noVisibleMembers() ? null : wf.getMemberSummaryWriter(classWriter, i);
        }
        return builder;
    }

    public static MemberSummaryBuilder getInstance(AnnotationTypeWriter annotationTypeWriter, AbstractBuilder.Context context) throws Exception {
        MemberSummaryBuilder builder = new MemberSummaryBuilder(context, annotationTypeWriter.getAnnotationTypeDoc());
        builder.memberSummaryWriters = new MemberSummaryWriter[9];
        WriterFactory wf = context.configuration.getWriterFactory();
        for (int i = 0; i < 9; ++i) {
            builder.memberSummaryWriters[i] = builder.visibleMemberMaps[i].noVisibleMembers() ? null : wf.getMemberSummaryWriter(annotationTypeWriter, i);
        }
        return builder;
    }

    @Override
    public String getName() {
        return NAME;
    }

    public VisibleMemberMap getVisibleMemberMap(int type) {
        return this.visibleMemberMaps[type];
    }

    public MemberSummaryWriter getMemberSummaryWriter(int type) {
        return this.memberSummaryWriters[type];
    }

    public List<ProgramElementDoc> members(int type) {
        return this.visibleMemberMaps[type].getLeafClassMembers(this.configuration);
    }

    @Override
    public boolean hasMembersToDocument() {
        if (this.classDoc instanceof AnnotationTypeDoc) {
            return ((AnnotationTypeDoc)this.classDoc).elements().length > 0;
        }
        for (int i = 0; i < 9; ++i) {
            VisibleMemberMap members = this.visibleMemberMaps[i];
            if (members.noVisibleMembers()) continue;
            return true;
        }
        return false;
    }

    public void buildEnumConstantsSummary(XMLNode node, Content memberSummaryTree) {
        MemberSummaryWriter writer = this.memberSummaryWriters[1];
        VisibleMemberMap visibleMemberMap = this.visibleMemberMaps[1];
        this.addSummary(writer, visibleMemberMap, false, memberSummaryTree);
    }

    public void buildAnnotationTypeFieldsSummary(XMLNode node, Content memberSummaryTree) {
        MemberSummaryWriter writer = this.memberSummaryWriters[5];
        VisibleMemberMap visibleMemberMap = this.visibleMemberMaps[5];
        this.addSummary(writer, visibleMemberMap, false, memberSummaryTree);
    }

    public void buildAnnotationTypeOptionalMemberSummary(XMLNode node, Content memberSummaryTree) {
        MemberSummaryWriter writer = this.memberSummaryWriters[6];
        VisibleMemberMap visibleMemberMap = this.visibleMemberMaps[6];
        this.addSummary(writer, visibleMemberMap, false, memberSummaryTree);
    }

    public void buildAnnotationTypeRequiredMemberSummary(XMLNode node, Content memberSummaryTree) {
        MemberSummaryWriter writer = this.memberSummaryWriters[7];
        VisibleMemberMap visibleMemberMap = this.visibleMemberMaps[7];
        this.addSummary(writer, visibleMemberMap, false, memberSummaryTree);
    }

    public void buildFieldsSummary(XMLNode node, Content memberSummaryTree) {
        MemberSummaryWriter writer = this.memberSummaryWriters[2];
        VisibleMemberMap visibleMemberMap = this.visibleMemberMaps[2];
        this.addSummary(writer, visibleMemberMap, true, memberSummaryTree);
    }

    public void buildPropertiesSummary(XMLNode node, Content memberSummaryTree) {
        MemberSummaryWriter writer = this.memberSummaryWriters[8];
        VisibleMemberMap visibleMemberMap = this.visibleMemberMaps[8];
        this.addSummary(writer, visibleMemberMap, true, memberSummaryTree);
    }

    public void buildNestedClassesSummary(XMLNode node, Content memberSummaryTree) {
        MemberSummaryWriter writer = this.memberSummaryWriters[0];
        VisibleMemberMap visibleMemberMap = this.visibleMemberMaps[0];
        this.addSummary(writer, visibleMemberMap, true, memberSummaryTree);
    }

    public void buildMethodsSummary(XMLNode node, Content memberSummaryTree) {
        MemberSummaryWriter writer = this.memberSummaryWriters[4];
        VisibleMemberMap visibleMemberMap = this.visibleMemberMaps[4];
        this.addSummary(writer, visibleMemberMap, true, memberSummaryTree);
    }

    public void buildConstructorsSummary(XMLNode node, Content memberSummaryTree) {
        MemberSummaryWriter writer = this.memberSummaryWriters[3];
        VisibleMemberMap visibleMemberMap = this.visibleMemberMaps[3];
        this.addSummary(writer, visibleMemberMap, false, memberSummaryTree);
    }

    private void buildSummary(MemberSummaryWriter writer, VisibleMemberMap visibleMemberMap, LinkedList<Content> summaryTreeList) {
        ArrayList<ProgramElementDoc> members = new ArrayList<ProgramElementDoc>(visibleMemberMap.getLeafClassMembers(this.configuration));
        if (members.size() > 0) {
            Collections.sort(members);
            LinkedList<Content> tableContents = new LinkedList<Content>();
            for (int i = 0; i < members.size(); ++i) {
                ProgramElementDoc member = (ProgramElementDoc)members.get(i);
                ProgramElementDoc propertyDoc = visibleMemberMap.getPropertyMemberDoc(member);
                if (propertyDoc != null) {
                    this.processProperty(visibleMemberMap, member, propertyDoc);
                }
                Tag[] firstSentenceTags = member.firstSentenceTags();
                if (member instanceof MethodDoc && firstSentenceTags.length == 0) {
                    DocFinder.Output inheritedDoc = DocFinder.search(this.configuration, new DocFinder.Input((MethodDoc)member));
                    if (inheritedDoc.holder != null && inheritedDoc.holder.firstSentenceTags().length > 0) {
                        firstSentenceTags = inheritedDoc.holder.firstSentenceTags();
                    }
                }
                writer.addMemberSummary(this.classDoc, member, firstSentenceTags, tableContents, i);
            }
            summaryTreeList.add(writer.getSummaryTableTree(this.classDoc, tableContents));
        }
    }

    private void processProperty(VisibleMemberMap visibleMemberMap, ProgramElementDoc member, ProgramElementDoc propertyDoc) {
        StringBuilder commentTextBuilder = new StringBuilder();
        boolean isSetter = this.isSetter(member);
        boolean isGetter = this.isGetter(member);
        if (isGetter || isSetter) {
            if (isSetter) {
                commentTextBuilder.append(MessageFormat.format(this.configuration.getText("doclet.PropertySetterWithName"), this.utils.propertyNameFromMethodName(this.configuration, member.name())));
            }
            if (isGetter) {
                commentTextBuilder.append(MessageFormat.format(this.configuration.getText("doclet.PropertyGetterWithName"), this.utils.propertyNameFromMethodName(this.configuration, member.name())));
            }
            if (propertyDoc.commentText() != null && !propertyDoc.commentText().isEmpty()) {
                commentTextBuilder.append(" \n @propertyDescription ");
            }
        }
        commentTextBuilder.append(propertyDoc.commentText());
        LinkedList<Tag> allTags = new LinkedList<Tag>();
        String[] tagNames = new String[]{"@defaultValue", "@since"};
        for (String tagName : tagNames) {
            Tag[] tags = propertyDoc.tags(tagName);
            if (tags == null) continue;
            allTags.addAll(Arrays.asList(tags));
        }
        for (Tag tag : allTags) {
            commentTextBuilder.append("\n").append(tag.name()).append(" ").append(tag.text());
        }
        if (!isGetter && !isSetter) {
            MethodDoc getter = (MethodDoc)visibleMemberMap.getGetterForProperty(member);
            MethodDoc setter = (MethodDoc)visibleMemberMap.getSetterForProperty(member);
            if (null != getter && commentTextBuilder.indexOf("@see #" + getter.name()) == -1) {
                commentTextBuilder.append("\n @see #").append(getter.name()).append("() ");
            }
            if (null != setter && commentTextBuilder.indexOf("@see #" + setter.name()) == -1) {
                String typeName = setter.parameters()[0].typeName();
                if ((typeName = typeName.split("<")[0]).contains(".")) {
                    typeName = typeName.substring(typeName.lastIndexOf(".") + 1);
                }
                commentTextBuilder.append("\n @see #").append(setter.name());
                if (setter.parameters()[0].type().asTypeVariable() == null) {
                    commentTextBuilder.append("(").append(typeName).append(")");
                }
                commentTextBuilder.append(" \n");
            }
        }
        member.setRawCommentText(commentTextBuilder.toString());
    }

    private boolean isGetter(ProgramElementDoc ped) {
        String pedName = ped.name();
        return pedName.startsWith("get") || pedName.startsWith("is");
    }

    private boolean isSetter(ProgramElementDoc ped) {
        return ped.name().startsWith("set");
    }

    private void buildInheritedSummary(MemberSummaryWriter writer, VisibleMemberMap visibleMemberMap, LinkedList<Content> summaryTreeList) {
        for (ClassDoc inhclass : visibleMemberMap.getVisibleClassesList()) {
            List<ProgramElementDoc> inhmembers;
            if (!inhclass.isPublic() && !this.utils.isLinkable(inhclass, this.configuration) || inhclass == this.classDoc || (inhmembers = visibleMemberMap.getMembersFor(inhclass)).size() <= 0) continue;
            Collections.sort(inhmembers);
            Content inheritedTree = writer.getInheritedSummaryHeader(inhclass);
            Content linksTree = writer.getInheritedSummaryLinksTree();
            for (int j = 0; j < inhmembers.size(); ++j) {
                writer.addInheritedMemberSummary(inhclass.isPackagePrivate() && !this.utils.isLinkable(inhclass, this.configuration) ? this.classDoc : inhclass, inhmembers.get(j), j == 0, j == inhmembers.size() - 1, linksTree);
            }
            inheritedTree.addContent(linksTree);
            summaryTreeList.add(writer.getMemberTree(inheritedTree));
        }
    }

    private void addSummary(MemberSummaryWriter writer, VisibleMemberMap visibleMemberMap, boolean showInheritedSummary, Content memberSummaryTree) {
        LinkedList<Content> summaryTreeList = new LinkedList<Content>();
        this.buildSummary(writer, visibleMemberMap, summaryTreeList);
        if (showInheritedSummary) {
            this.buildInheritedSummary(writer, visibleMemberMap, summaryTreeList);
        }
        if (!summaryTreeList.isEmpty()) {
            Content memberTree = writer.getMemberSummaryHeader(this.classDoc, memberSummaryTree);
            for (Content aSummaryTreeList : summaryTreeList) {
                memberTree.addContent(aSummaryTreeList);
            }
            writer.addMemberTree(memberSummaryTree, memberTree);
        }
    }
}

