/*
 * Decompiled with CFR 0.152.
 */
package gw.util.science;

import gw.internal.gosu.runtime.GosuRuntimeMethods;
import gw.lang.reflect.IType;
import gw.lang.reflect.LazyTypeResolver;
import gw.lang.reflect.SimpleTypeLazyTypeResolver;
import gw.lang.reflect.gs.IGosuObject;
import gw.util.Rational;
import gw.util.science.AbstractProductUnit;
import gw.util.science.AreaUnit;
import gw.util.science.DensityUnit;
import gw.util.science.LengthUnit;
import gw.util.science.MassUnit;
import gw.util.science.UnitCache;
import gw.util.science.Volume;
import manifold.internal.runtime.Bootstrap;

public final class VolumeUnit
extends AbstractProductUnit<LengthUnit, AreaUnit, Volume, VolumeUnit>
implements IGosuObject {
    static final UnitCache<VolumeUnit> CACHE;
    public static VolumeUnit BASE;
    public static VolumeUnit LITER;
    public static VolumeUnit MILLI_LITER;
    public static VolumeUnit FLUID_OZ;
    public static VolumeUnit GALLON;
    public static VolumeUnit QUART;
    public static VolumeUnit PINT;
    public static VolumeUnit CUP;
    public static VolumeUnit TABLE_SPOON;
    public static VolumeUnit TEA_SPOON;

    static {
        Bootstrap.init();
        CACHE = new UnitCache((LazyTypeResolver)new SimpleTypeLazyTypeResolver("gw.util.science.VolumeUnit", "_default_"));
        BASE = VolumeUnit.get(LengthUnit.Meter, AreaUnit.get(LengthUnit.Meter, null, null, null, null), null, null, null);
        LITER = VolumeUnit.get(LengthUnit.Centi, AreaUnit.get(LengthUnit.Centi, null, null, null, null), Rational.get((long)1000L), "Litre", "L");
        MILLI_LITER = VolumeUnit.get(LengthUnit.Centi, AreaUnit.get(LengthUnit.Centi, null, null, null, null), Rational.ONE, "Millilitre", "mL");
        FLUID_OZ = VolumeUnit.get(LengthUnit.Centi, AreaUnit.get(LengthUnit.Centi, null, null, null, null), Rational.get((long)295735295625L, (long)10000000000L), "Fluid Ounce", "fl oz.");
        GALLON = VolumeUnit.get(LengthUnit.Centi, AreaUnit.get(LengthUnit.Centi, null, null, null, null), Rational.get((long)3785411784L, (long)1000000L), "Gallon", "gal.");
        QUART = VolumeUnit.get(LengthUnit.Centi, AreaUnit.get(LengthUnit.Centi, null, null, null, null), Rational.get((long)946352946L, (long)1000000L), "Quart", "qt.");
        PINT = VolumeUnit.get(LengthUnit.Centi, AreaUnit.get(LengthUnit.Centi, null, null, null, null), Rational.get((long)473176473L, (long)1000000L), "Pint", "pt.");
        CUP = VolumeUnit.get(LengthUnit.Centi, AreaUnit.get(LengthUnit.Centi, null, null, null, null), Rational.get((long)2365882365L, (long)10000000L), "Cup", "c.");
        TABLE_SPOON = VolumeUnit.get(LengthUnit.Centi, AreaUnit.get(LengthUnit.Centi, null, null, null, null), Rational.get((long)1478676478125L, (long)100000000000L), "Tablespoon", "tbsp");
        TEA_SPOON = VolumeUnit.get(LengthUnit.Centi, AreaUnit.get(LengthUnit.Centi, null, null, null, null), Rational.get((long)492892159375L, (long)100000000000L), "Teaspoon", "tsp");
    }

    VolumeUnit(LengthUnit lengthUnit, AreaUnit areaUnit, Rational factor, String name, String symbol) {
        AreaUnit areaUnit2 = areaUnit;
        super((LazyTypeResolver)new SimpleTypeLazyTypeResolver("gw.util.science.LengthUnit", "_default_"), (LazyTypeResolver)new SimpleTypeLazyTypeResolver("gw.util.science.AreaUnit", "_default_"), (LazyTypeResolver)new SimpleTypeLazyTypeResolver("gw.util.science.Volume", "_default_"), (LazyTypeResolver)new SimpleTypeLazyTypeResolver("gw.util.science.VolumeUnit", "_default_"), lengthUnit, areaUnit2 != null ? areaUnit2 : AreaUnit.get(lengthUnit, null, null, null, null), factor, name, symbol);
    }

    public static VolumeUnit get(LengthUnit lengthUnit, AreaUnit areaUnit, Rational factor, String name, String symbol) {
        VolumeUnit unit = new VolumeUnit(lengthUnit, areaUnit, factor, name, symbol);
        return (VolumeUnit)CACHE.get(unit);
    }

    public AreaUnit getAreaUnit() {
        return (AreaUnit)this.getRightUnit();
    }

    public LengthUnit getLengthUnit() {
        return (LengthUnit)this.getLeftUnit();
    }

    @Override
    public String getFullName() {
        return this.getAreaUnit().isIsSquare() && this.getAreaUnit().getWidthUnit() == this.getLengthUnit() ? this.getLengthUnit().getFullName() + "\u00b3" : this.getAreaUnit().getFullName() + "\u00d7" + this.getLengthUnit().getFullName();
    }

    @Override
    public String getFullSymbol() {
        return this.getAreaUnit().isIsSquare() && this.getAreaUnit().getWidthUnit() == this.getLengthUnit() ? this.getLengthUnit().getFullSymbol() + "\u00b3" : this.getAreaUnit().getFullSymbol() + "\u00d7" + this.getLengthUnit().getFullSymbol();
    }

    public boolean isIsCubic() {
        return this.getAreaUnit().isIsSquare() && this.getAreaUnit().getWidthUnit() == this.getLengthUnit();
    }

    public LengthUnit divide(AreaUnit len) {
        return this.getLengthUnit();
    }

    public MassUnit multiply(DensityUnit density) {
        return density.getMassUnit();
    }

    @Override
    public /* synthetic */ IType getIntrinsicType() {
        return GosuRuntimeMethods.getType((Object)this);
    }
}

