/*
 * Decompiled with CFR 0.152.
 */
package gw.util.science;

import gw.lang.reflect.gs.IGosuClassObject;
import gw.util.science.AngleUnit;
import gw.util.science.ChargeUnit;
import gw.util.science.CurrentUnit;
import gw.util.science.EnergyUnit;
import gw.util.science.ForceUnit;
import gw.util.science.FrequencyUnit;
import gw.util.science.HeatCapacityUnit;
import gw.util.science.LengthUnit;
import gw.util.science.MassUnit;
import gw.util.science.MomentumUnit;
import gw.util.science.PowerUnit;
import gw.util.science.TemperatureUnit;
import gw.util.science.TimeUnit;
import gw.util.science.VelocityUnit;
import gw.util.science.VolumeUnit;
import manifold.internal.runtime.Bootstrap;

public interface UnitConstants
extends IGosuClassObject {
    public static final LengthUnit mum;
    public static final LengthUnit mm;
    public static final LengthUnit cm;
    public static final LengthUnit m;
    public static final LengthUnit km;
    public static final LengthUnit inch;
    public static final LengthUnit ft;
    public static final LengthUnit yd;
    public static final LengthUnit mi;
    public static final TimeUnit ns;
    public static final TimeUnit mus;
    public static final TimeUnit ms;
    public static final TimeUnit s;
    public static final TimeUnit min;
    public static final TimeUnit hr;
    public static final TimeUnit day;
    public static final TimeUnit wk;
    public static final TimeUnit mo;
    public static final TimeUnit yr;
    public static final TimeUnit tmo;
    public static final TimeUnit tyr;
    public static final MassUnit amu;
    public static final MassUnit mug;
    public static final MassUnit mg;
    public static final MassUnit g;
    public static final MassUnit kg;
    public static final MassUnit ct;
    public static final MassUnit dr;
    public static final MassUnit gr;
    public static final MassUnit Nt;
    public static final MassUnit oz;
    public static final MassUnit ozt;
    public static final MassUnit lb;
    public static final MassUnit st;
    public static final MassUnit sht;
    public static final MassUnit lt;
    public static final MassUnit tonne;
    public static final MassUnit Mo;
    public static final VolumeUnit L;
    public static final VolumeUnit mL;
    public static final VolumeUnit fl_oz;
    public static final VolumeUnit gal;
    public static final VolumeUnit qt;
    public static final VolumeUnit pt;
    public static final VolumeUnit cup;
    public static final VolumeUnit tbsp;
    public static final VolumeUnit tsp;
    public static final AngleUnit cyc;
    public static final AngleUnit rad;
    public static final AngleUnit mrad;
    public static final AngleUnit nrad;
    public static final AngleUnit arcsec;
    public static final AngleUnit mas;
    public static final AngleUnit grad;
    public static final AngleUnit quad;
    public static final AngleUnit moa;
    public static final AngleUnit deg;
    public static final TemperatureUnit dK;
    public static final TemperatureUnit dC;
    public static final TemperatureUnit dF;
    public static final VelocityUnit mph;
    public static final MomentumUnit Ns;
    public static final ForceUnit N;
    public static final ForceUnit dyn;
    public static final EnergyUnit joule;
    public static final EnergyUnit J;
    public static final EnergyUnit erg;
    public static final EnergyUnit kcal;
    public static final PowerUnit watt;
    public static final PowerUnit W;
    public static final HeatCapacityUnit C;
    public static final FrequencyUnit Hz;
    public static final FrequencyUnit kHz;
    public static final FrequencyUnit MHz;
    public static final FrequencyUnit GHz;
    public static final FrequencyUnit rpm;
    public static final ChargeUnit coulomb;
    public static final CurrentUnit amp;

    static {
        Bootstrap.init();
        mum = LengthUnit.Micro;
        mm = LengthUnit.Milli;
        cm = LengthUnit.Centi;
        m = LengthUnit.Meter;
        km = LengthUnit.Kilometer;
        inch = LengthUnit.Inch;
        ft = LengthUnit.Foot;
        yd = LengthUnit.Yard;
        mi = LengthUnit.Mile;
        ns = TimeUnit.Nano;
        mus = TimeUnit.Micro;
        ms = TimeUnit.Milli;
        s = TimeUnit.Second;
        min = TimeUnit.Minute;
        hr = TimeUnit.Hour;
        day = TimeUnit.Day;
        wk = TimeUnit.Week;
        mo = TimeUnit.Month;
        yr = TimeUnit.Year;
        tmo = TimeUnit.TrMonth;
        tyr = TimeUnit.TrYear;
        amu = MassUnit.AtomicMass;
        mug = MassUnit.Micro;
        mg = MassUnit.Milli;
        g = MassUnit.Gram;
        kg = MassUnit.Kilogram;
        ct = MassUnit.Carat;
        dr = MassUnit.Dram;
        gr = MassUnit.Grain;
        Nt = MassUnit.Newton;
        oz = MassUnit.Ounce;
        ozt = MassUnit.TroyOunce;
        lb = MassUnit.Pound;
        st = MassUnit.Stone;
        sht = MassUnit.Ton;
        lt = MassUnit.TonUK;
        tonne = MassUnit.Tonne;
        Mo = MassUnit.Solar;
        L = VolumeUnit.LITER;
        mL = VolumeUnit.MILLI_LITER;
        fl_oz = VolumeUnit.FLUID_OZ;
        gal = VolumeUnit.GALLON;
        qt = VolumeUnit.QUART;
        pt = VolumeUnit.PINT;
        cup = VolumeUnit.CUP;
        tbsp = VolumeUnit.TABLE_SPOON;
        tsp = VolumeUnit.TEA_SPOON;
        cyc = AngleUnit.Turn;
        rad = AngleUnit.Radian;
        mrad = AngleUnit.Milli;
        nrad = AngleUnit.Nano;
        arcsec = AngleUnit.ArcSecond;
        mas = AngleUnit.MilliArcSecond;
        grad = AngleUnit.Gradian;
        quad = AngleUnit.Quadrant;
        moa = AngleUnit.MOA;
        deg = AngleUnit.Degree;
        dK = TemperatureUnit.Kelvin;
        dC = TemperatureUnit.Celcius;
        dF = TemperatureUnit.Fahrenheit;
        mph = mi.divide(hr);
        Ns = m.divide(s).postfixBind(kg);
        N = m.divide(s).divide(s).postfixBind(kg);
        dyn = cm.divide(s).divide(s).postfixBind(g);
        J = joule = m.postfixBind(N);
        erg = cm.postfixBind(dyn);
        kcal = EnergyUnit.kcal;
        W = watt = J.divide(s);
        C = J.divide(dK);
        Hz = cyc.divide(s);
        kHz = cyc.divide(ms);
        MHz = cyc.divide(mus);
        GHz = cyc.divide(ns);
        rpm = cyc.divide(min);
        coulomb = ChargeUnit.Coulomb;
        amp = coulomb.divide(s);
    }
}

