/*
 * Decompiled with CFR 0.152.
 */
package gw.util.science;

import gw.internal.gosu.runtime.GosuRuntimeMethods;
import gw.lang.reflect.IType;
import gw.lang.reflect.LazyTypeResolver;
import gw.lang.reflect.SimpleTypeLazyTypeResolver;
import gw.lang.reflect.gs.IGosuObject;
import gw.util.Rational;
import gw.util.science.AbstractQuotientUnit;
import gw.util.science.CurrentUnit;
import gw.util.science.EnergyUnit;
import gw.util.science.ForceUnit;
import gw.util.science.MetricScaleUnit;
import gw.util.science.PotentialUnit;
import gw.util.science.Power;
import gw.util.science.TimeUnit;
import gw.util.science.UnitCache;
import gw.util.science.VelocityUnit;
import manifold.internal.runtime.Bootstrap;

public final class PowerUnit
extends AbstractQuotientUnit<EnergyUnit, TimeUnit, Power, PowerUnit>
implements IGosuObject {
    static final UnitCache<PowerUnit> CACHE;
    public static PowerUnit pW;
    public static PowerUnit nW;
    public static PowerUnit uW;
    public static PowerUnit mW;
    public static PowerUnit W;
    public static PowerUnit kW;
    public static PowerUnit MW;
    public static PowerUnit GW;
    public static PowerUnit BASE;

    static {
        Bootstrap.init();
        CACHE = new UnitCache((LazyTypeResolver)new SimpleTypeLazyTypeResolver("gw.util.science.PowerUnit", "_default_"));
        pW = PowerUnit.get(EnergyUnit.BASE, TimeUnit.Second, MetricScaleUnit.p.postfixBind(Rational.ONE), "Picowatt", "pW");
        nW = PowerUnit.get(EnergyUnit.BASE, TimeUnit.Second, MetricScaleUnit.n.postfixBind(Rational.ONE), "Nanowatt", "nW");
        uW = PowerUnit.get(EnergyUnit.BASE, TimeUnit.Second, MetricScaleUnit.u.postfixBind(Rational.ONE), "Microwatt", "\u03bcW");
        mW = PowerUnit.get(EnergyUnit.BASE, TimeUnit.Second, MetricScaleUnit.m.postfixBind(Rational.ONE), "Milliwatt", "mW");
        W = PowerUnit.get(EnergyUnit.BASE, TimeUnit.Second, Rational.ONE, "Watt", "W");
        kW = PowerUnit.get(EnergyUnit.BASE, TimeUnit.Second, MetricScaleUnit.k.postfixBind(Rational.ONE), "Kilowatt", "kW");
        MW = PowerUnit.get(EnergyUnit.BASE, TimeUnit.Second, MetricScaleUnit.M.postfixBind(Rational.ONE), "Megawatt", "MW");
        GW = PowerUnit.get(EnergyUnit.BASE, TimeUnit.Second, MetricScaleUnit.G.postfixBind(Rational.ONE), "Gigawatt", "GW");
        BASE = W;
    }

    PowerUnit(EnergyUnit energyUnit, TimeUnit timeUnit, Rational factor, String name, String symbol) {
        super((LazyTypeResolver)new SimpleTypeLazyTypeResolver("gw.util.science.EnergyUnit", "_default_"), (LazyTypeResolver)new SimpleTypeLazyTypeResolver("gw.util.science.TimeUnit", "_default_"), (LazyTypeResolver)new SimpleTypeLazyTypeResolver("gw.util.science.Power", "_default_"), (LazyTypeResolver)new SimpleTypeLazyTypeResolver("gw.util.science.PowerUnit", "_default_"), energyUnit, timeUnit, factor, name, symbol);
    }

    public static PowerUnit get(EnergyUnit energyUnit, TimeUnit timeUnit, Rational factor, String name, String symbol) {
        PowerUnit unit = new PowerUnit(energyUnit, timeUnit, factor, name, symbol);
        return (PowerUnit)CACHE.get(unit);
    }

    public EnergyUnit getEnergyUnit() {
        return (EnergyUnit)this.getLeftUnit();
    }

    public TimeUnit getTimeUnit() {
        return (TimeUnit)this.getRightUnit();
    }

    public ForceUnit divide(VelocityUnit v) {
        return this.getEnergyUnit().getForceUnit();
    }

    public VelocityUnit divide(ForceUnit force) {
        return this.getEnergyUnit().getForceUnit().getAccUnit().getVelocityUnit();
    }

    public CurrentUnit divide(PotentialUnit potential) {
        return potential.getCurrentUnit();
    }

    public PotentialUnit divide(CurrentUnit current) {
        return PotentialUnit.get(this, current, null, null, null);
    }

    @Override
    public /* synthetic */ IType getIntrinsicType() {
        return GosuRuntimeMethods.getType((Object)this);
    }
}

