/*
 * Decompiled with CFR 0.152.
 */
package gw.util.science;

import gw.internal.gosu.runtime.GosuRuntimeMethods;
import gw.lang.reflect.IType;
import gw.lang.reflect.LazyTypeResolver;
import gw.lang.reflect.SimpleTypeLazyTypeResolver;
import gw.lang.reflect.gs.IGosuObject;
import gw.util.Rational;
import gw.util.science.AbstractProductUnit;
import gw.util.science.AccelerationUnit;
import gw.util.science.EnergyUnit;
import gw.util.science.Force;
import gw.util.science.LengthUnit;
import gw.util.science.MassUnit;
import gw.util.science.MomentumUnit;
import gw.util.science.PowerUnit;
import gw.util.science.TimeUnit;
import gw.util.science.UnitCache;
import gw.util.science.VelocityUnit;
import manifold.internal.runtime.Bootstrap;

public final class ForceUnit
extends AbstractProductUnit<MassUnit, AccelerationUnit, Force, ForceUnit>
implements IGosuObject {
    static final UnitCache<ForceUnit> CACHE;
    public static ForceUnit N;
    public static ForceUnit BASE;

    static {
        Bootstrap.init();
        CACHE = new UnitCache((LazyTypeResolver)new SimpleTypeLazyTypeResolver("gw.util.science.ForceUnit", "_default_"));
        BASE = N = ForceUnit.get(MassUnit.Kilogram, AccelerationUnit.BASE, Rational.ONE, "Newton", "N");
    }

    ForceUnit(MassUnit massUnit, AccelerationUnit accUnit, Rational factor, String name, String symbol) {
        super((LazyTypeResolver)new SimpleTypeLazyTypeResolver("gw.util.science.MassUnit", "_default_"), (LazyTypeResolver)new SimpleTypeLazyTypeResolver("gw.util.science.AccelerationUnit", "_default_"), (LazyTypeResolver)new SimpleTypeLazyTypeResolver("gw.util.science.Force", "_default_"), (LazyTypeResolver)new SimpleTypeLazyTypeResolver("gw.util.science.ForceUnit", "_default_"), massUnit, accUnit, factor, name, symbol);
    }

    public static ForceUnit get(MassUnit massUnit, AccelerationUnit accUnit, Rational factor, String name, String symbol) {
        ForceUnit unit = new ForceUnit(massUnit, accUnit, factor, name, symbol);
        return (ForceUnit)CACHE.get(unit);
    }

    public MassUnit getMassUnit() {
        return (MassUnit)this.getLeftUnit();
    }

    public AccelerationUnit getAccUnit() {
        return (AccelerationUnit)this.getRightUnit();
    }

    public PowerUnit multiply(VelocityUnit v) {
        return PowerUnit.get(this.multiply(v.getLengthUnit()), v.getTimeUnit(), null, null, null);
    }

    public EnergyUnit multiply(LengthUnit len) {
        return EnergyUnit.get(this, len, null, null, null);
    }

    public MomentumUnit multiply(TimeUnit t) {
        return MomentumUnit.get(this.getMassUnit(), VelocityUnit.get(this.getAccUnit().getVelocityUnit().getLengthUnit(), t, null, null, null), null, null, null);
    }

    public MassUnit divide(AccelerationUnit acc) {
        return this.getMassUnit();
    }

    @Override
    public /* synthetic */ IType getIntrinsicType() {
        return GosuRuntimeMethods.getType((Object)this);
    }
}

