/*
 * Decompiled with CFR 0.152.
 */
package gw.util.science;

import gw.internal.gosu.runtime.GosuRuntimeMethods;
import gw.lang.reflect.IEnumValue;
import gw.lang.reflect.IType;
import gw.lang.reflect.gs.IGosuObject;
import gw.util.Rational;
import gw.util.science.Angle;
import gw.util.science.DimensionlessConstants;
import gw.util.science.FrequencyUnit;
import gw.util.science.IUnit;
import gw.util.science.MetricScaleUnit;
import gw.util.science.TimeUnit;
import java.util.Arrays;
import java.util.List;
import manifold.internal.runtime.Bootstrap;

public final class AngleUnit
extends Enum<AngleUnit>
implements IEnumValue,
IUnit<Rational, Angle, AngleUnit>,
IGosuObject {
    Rational _rads;
    String _name;
    String _symbol;
    public static final AngleUnit Nano;
    public static final AngleUnit Milli;
    public static final AngleUnit Radian;
    public static final AngleUnit Degree;
    public static final AngleUnit MOA;
    public static final AngleUnit ArcSecond;
    public static final AngleUnit MilliArcSecond;
    public static final AngleUnit Turn;
    public static final AngleUnit Gradian;
    public static final AngleUnit Quadrant;
    private static final /* synthetic */ AngleUnit[] ENUM$VALUES;

    static {
        Bootstrap.init();
        Nano = new AngleUnit(MetricScaleUnit.n.postfixBind(Rational.ONE), "Nanoradian", "nrad");
        Milli = new AngleUnit(MetricScaleUnit.m.postfixBind(Rational.ONE), "Milliradian", "mrad");
        Radian = new AngleUnit(Rational.ONE, "Radian", "rad");
        AngleUnit[] angleUnitArray = DimensionlessConstants.pi;
        Rational rational = Rational.get((long)180L);
        AngleUnit[] angleUnitArray2 = angleUnitArray;
        Rational rational2 = rational;
        Degree = new AngleUnit(angleUnitArray2.divide(rational2), "Degree", "deg");
        angleUnitArray = DimensionlessConstants.pi;
        rational = Rational.get((long)10800L);
        angleUnitArray2 = angleUnitArray;
        rational2 = rational;
        MOA = new AngleUnit(angleUnitArray2.divide(rational2), "MinuteOfArc", "moa");
        angleUnitArray = DimensionlessConstants.pi;
        rational = MetricScaleUnit.k.postfixBind(Rational.get((long)648L));
        angleUnitArray2 = angleUnitArray;
        rational2 = rational;
        ArcSecond = new AngleUnit(angleUnitArray2.divide(rational2), "ArcSecond", "arcsec");
        angleUnitArray = DimensionlessConstants.pi;
        rational = MetricScaleUnit.M.postfixBind(Rational.get((long)648L));
        angleUnitArray2 = angleUnitArray;
        rational2 = rational;
        MilliArcSecond = new AngleUnit(angleUnitArray2.divide(rational2), "MilliArcSecond", "mas");
        angleUnitArray = Rational.get((long)2L);
        rational = DimensionlessConstants.pi;
        angleUnitArray2 = angleUnitArray;
        rational2 = rational;
        Turn = new AngleUnit(angleUnitArray2.multiply(rational2), "Turn", "cyc");
        angleUnitArray = DimensionlessConstants.pi;
        rational = Rational.get((long)200L);
        angleUnitArray2 = angleUnitArray;
        rational2 = rational;
        Gradian = new AngleUnit(angleUnitArray2.divide(rational2), "Gradian", "grad");
        angleUnitArray = DimensionlessConstants.pi;
        rational = Rational.get((long)2L);
        angleUnitArray2 = angleUnitArray;
        rational2 = rational;
        Quadrant = new AngleUnit(angleUnitArray2.divide(rational2), "Quadrant", "quad");
        angleUnitArray = new AngleUnit[]{Nano, Milli, Radian, Degree, MOA, ArcSecond, MilliArcSecond, Turn, Gradian, Quadrant};
        ENUM$VALUES = angleUnitArray;
    }

    AngleUnit(Rational rads, String name, String symbol) {
        this._rads = rads;
        this._name = name;
        this._symbol = symbol;
    }

    public static AngleUnit getBASE() {
        return Radian;
    }

    public Rational getRads() {
        return this._rads;
    }

    public void setRads(Rational rational) {
        this._rads = rational;
    }

    @Override
    public String getUnitName() {
        return this._name;
    }

    @Override
    public String getUnitSymbol() {
        return this._symbol;
    }

    public Rational toBaseUnits(Rational myUnits) {
        Rational rational = this.getRads();
        Rational rational2 = myUnits;
        Rational rational3 = rational;
        Rational rational4 = rational2;
        return rational3.multiply(rational4);
    }

    public Rational toNumber() {
        return this.getRads();
    }

    public Rational from(Angle angle) {
        Rational rational = angle.toBaseNumber();
        Rational rational2 = this.getRads();
        Rational rational3 = rational;
        Rational rational4 = rational2;
        return rational3.divide(rational4);
    }

    public FrequencyUnit divide(TimeUnit time) {
        return FrequencyUnit.get(this, time, null, null, null);
    }

    public TimeUnit divide(FrequencyUnit freq) {
        return freq.getTimeUnit();
    }

    public /* synthetic */ IType getIntrinsicType() {
        return GosuRuntimeMethods.getType((Object)this);
    }

    public static AngleUnit[] values() {
        AngleUnit[] angleUnitArray = new AngleUnit[10];
        System.arraycopy(ENUM$VALUES, 0, angleUnitArray, 0, 10);
        return angleUnitArray;
    }

    public static List getAllValues() {
        return Arrays.asList(AngleUnit.values());
    }

    public static AngleUnit valueOf(String string) {
        return Enum.valueOf(AngleUnit.class, string);
    }

    public final Object getValue() {
        return this;
    }

    public final String getCode() {
        return this.name();
    }

    public final int getOrdinal() {
        return this.ordinal();
    }

    public final String getDisplayName() {
        return this.toString();
    }

    public final String getName() {
        return this.name();
    }
}

