/*
 * Decompiled with CFR 0.152.
 */
package gw.util.science;

import gw.internal.gosu.runtime.GosuRuntimeMethods;
import gw.lang.reflect.IEnumValue;
import gw.lang.reflect.IType;
import gw.lang.reflect.gs.GosuClassPathThing;
import gw.lang.reflect.gs.IGosuObject;
import gw.util.Rational;
import gw.util.science.AccelerationUnit;
import gw.util.science.AngleUnit;
import gw.util.science.ChargeUnit;
import gw.util.science.CurrentUnit;
import gw.util.science.EnergyUnit;
import gw.util.science.ForceUnit;
import gw.util.science.FrequencyUnit;
import gw.util.science.IUnit;
import gw.util.science.LengthUnit;
import gw.util.science.MetricScaleUnit;
import gw.util.science.MomentumUnit;
import gw.util.science.PowerUnit;
import gw.util.science.Time;
import gw.util.science.VelocityUnit;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;

public final class TimeUnit
extends Enum<TimeUnit>
implements IEnumValue,
IUnit<Rational, Time, TimeUnit>,
IGosuObject {
    final Rational _sec;
    final String _name;
    final String _symbol;
    public static final TimeUnit Planck;
    public static final TimeUnit Femto;
    public static final TimeUnit Pico;
    public static final TimeUnit Nano;
    public static final TimeUnit Micro;
    public static final TimeUnit Milli;
    public static final TimeUnit Second;
    public static final TimeUnit Minute;
    public static final TimeUnit Hour;
    public static final TimeUnit Day;
    public static final TimeUnit Week;
    public static final TimeUnit Month;
    public static final TimeUnit Year;
    public static final TimeUnit Decade;
    public static final TimeUnit Century;
    public static final TimeUnit Millennium;
    public static final TimeUnit Era;
    public static final TimeUnit TrMonth;
    public static final TimeUnit TrYear;
    private static final /* synthetic */ TimeUnit[] ENUM$VALUES;

    static {
        GosuClassPathThing.init();
        Planck = new TimeUnit(Rational.get((BigInteger)new BigInteger("539056"), (BigInteger)new BigInteger("10000000000000000000000000000000000000000000000000")), "Planck-time", "tP");
        Femto = new TimeUnit(MetricScaleUnit.fe.postfixBind(Rational.ONE), "Femtosecond", "fs");
        Pico = new TimeUnit(MetricScaleUnit.p.postfixBind(Rational.ONE), "Picosecond", "ps");
        Nano = new TimeUnit(MetricScaleUnit.n.postfixBind(Rational.ONE), "Nanosecond", "ns");
        Micro = new TimeUnit(MetricScaleUnit.u.postfixBind(Rational.ONE), "Microsecond", "\u00b5s");
        Milli = new TimeUnit(MetricScaleUnit.m.postfixBind(Rational.ONE), "Millisecond", "ms");
        Second = new TimeUnit(Rational.ONE, "Second", "s");
        Minute = new TimeUnit(Rational.get((long)60L), "Minute", "min");
        TimeUnit[] timeUnitArray = Rational.get((long)60L);
        Rational rational = Rational.get((long)60L);
        TimeUnit[] timeUnitArray2 = timeUnitArray;
        Rational rational2 = rational;
        Hour = new TimeUnit(timeUnitArray2.multiply(rational2), "Hour", "hr");
        timeUnitArray = Rational.get((long)24L);
        rational = Rational.get((long)60L);
        timeUnitArray2 = timeUnitArray;
        rational2 = rational;
        timeUnitArray = timeUnitArray2.multiply(rational2);
        rational = Rational.get((long)60L);
        timeUnitArray2 = timeUnitArray;
        rational2 = rational;
        Day = new TimeUnit(timeUnitArray2.multiply(rational2), "Day", "day");
        timeUnitArray = Rational.get((long)7L);
        rational = Rational.get((long)24L);
        timeUnitArray2 = timeUnitArray;
        rational2 = rational;
        timeUnitArray = timeUnitArray2.multiply(rational2);
        rational = Rational.get((long)60L);
        timeUnitArray2 = timeUnitArray;
        rational2 = rational;
        timeUnitArray = timeUnitArray2.multiply(rational2);
        rational = Rational.get((long)60L);
        timeUnitArray2 = timeUnitArray;
        rational2 = rational;
        Week = new TimeUnit(timeUnitArray2.multiply(rational2), "Week", "wk");
        timeUnitArray = Rational.get((long)31556952L);
        rational = Rational.get((long)12L);
        timeUnitArray2 = timeUnitArray;
        rational2 = rational;
        Month = new TimeUnit(timeUnitArray2.divide(rational2), "Month", "mo");
        Year = new TimeUnit(Rational.get((long)31556952L), "Year", "yr");
        timeUnitArray = Rational.get((long)31556952L);
        rational = Rational.get((long)10L);
        timeUnitArray2 = timeUnitArray;
        rational2 = rational;
        Decade = new TimeUnit(timeUnitArray2.multiply(rational2), "Decade", "decade");
        timeUnitArray = Rational.get((long)31556952L);
        rational = Rational.get((long)100L);
        timeUnitArray2 = timeUnitArray;
        rational2 = rational;
        Century = new TimeUnit(timeUnitArray2.multiply(rational2), "Century", "century");
        Millennium = new TimeUnit(MetricScaleUnit.k.postfixBind(Rational.get((long)31556952L)), "Millennium", "millennium");
        Era = new TimeUnit(MetricScaleUnit.G.postfixBind(Rational.get((long)31556952L)), "Era", "era");
        timeUnitArray = Rational.get((long)31556925445L, (long)1000L);
        rational = Rational.get((long)12L);
        timeUnitArray2 = timeUnitArray;
        rational2 = rational;
        TrMonth = new TimeUnit(timeUnitArray2.divide(rational2), "Tropical Month", "tmo");
        TrYear = new TimeUnit(Rational.get((long)31556925445L, (long)1000L), "Tropical Year", "tyr");
        timeUnitArray = new TimeUnit[]{Planck, Femto, Pico, Nano, Micro, Milli, Second, Minute, Hour, Day, Week, Month, Year, Decade, Century, Millennium, Era, TrMonth, TrYear};
        ENUM$VALUES = timeUnitArray;
    }

    TimeUnit(Rational sec, String name, String symbol) {
        this._sec = sec;
        this._name = name;
        this._symbol = symbol;
    }

    public static TimeUnit getBASE() {
        return Second;
    }

    public Rational getSeconds() {
        return this._sec;
    }

    @Override
    public String getUnitName() {
        return this._name;
    }

    @Override
    public String getUnitSymbol() {
        return this._symbol;
    }

    public Rational toBaseUnits(Rational myUnits) {
        Rational rational = this.getSeconds();
        Rational rational2 = myUnits;
        Rational rational3 = rational;
        Rational rational4 = rational2;
        return rational3.multiply(rational4);
    }

    public Rational toNumber() {
        return this.getSeconds();
    }

    public Rational from(Time t) {
        Rational rational = t.toBaseNumber();
        Rational rational2 = this.getSeconds();
        Rational rational3 = rational;
        Rational rational4 = rational2;
        return rational3.divide(rational4);
    }

    public LengthUnit multiply(VelocityUnit v) {
        return v.getLengthUnit();
    }

    public VelocityUnit multiply(AccelerationUnit acc) {
        return acc.getVelocityUnit();
    }

    public ChargeUnit multiply(CurrentUnit current) {
        return ChargeUnit.Coulomb;
    }

    public AngleUnit multiply(FrequencyUnit frequency) {
        return frequency.getAngleUnit();
    }

    public EnergyUnit multiply(PowerUnit power) {
        return power.getEnergyUnit();
    }

    public MomentumUnit multiply(ForceUnit force) {
        return force.getMassUnit().multiply(force.getAccUnit().getVelocityUnit().getLengthUnit().divide(this));
    }

    public /* synthetic */ IType getIntrinsicType() {
        return GosuRuntimeMethods.getType((Object)this);
    }

    public static TimeUnit[] values() {
        TimeUnit[] timeUnitArray = new TimeUnit[19];
        System.arraycopy(ENUM$VALUES, 0, timeUnitArray, 0, 19);
        return timeUnitArray;
    }

    public static List getAllValues() {
        return Arrays.asList(TimeUnit.values());
    }

    public static TimeUnit valueOf(String string) {
        return Enum.valueOf(TimeUnit.class, string);
    }

    public final Object getValue() {
        return this;
    }

    public final String getCode() {
        return this.name();
    }

    public final int getOrdinal() {
        return this.ordinal();
    }

    public final String getDisplayName() {
        return this.toString();
    }

    public final String getName() {
        return this.name();
    }
}

