/*
 * Decompiled with CFR 0.152.
 */
package gw.util.science;

import gw.internal.gosu.runtime.GosuRuntimeMethods;
import gw.lang.reflect.IType;
import gw.lang.reflect.LazyTypeResolver;
import gw.lang.reflect.SimpleTypeLazyTypeResolver;
import gw.lang.reflect.gs.GosuClassPathThing;
import gw.lang.reflect.gs.IGosuObject;
import gw.util.Rational;
import gw.util.science.AbstractProductUnit;
import gw.util.science.EnergyUnit;
import gw.util.science.MassUnit;
import gw.util.science.Momentum;
import gw.util.science.UnitCache;
import gw.util.science.VelocityUnit;

public final class MomentumUnit
extends AbstractProductUnit<MassUnit, VelocityUnit, Momentum, MomentumUnit>
implements IGosuObject {
    static final UnitCache<MomentumUnit> CACHE;
    public static MomentumUnit BASE;

    static {
        GosuClassPathThing.init();
        CACHE = new UnitCache((LazyTypeResolver)new SimpleTypeLazyTypeResolver("gw.util.science.MomentumUnit", "_default_"));
        BASE = MomentumUnit.get(MassUnit.Kilogram, VelocityUnit.BASE, null, null, null);
    }

    MomentumUnit(MassUnit massUnit, VelocityUnit velocityUnit, Rational factor, String name, String symbol) {
        super((LazyTypeResolver)new SimpleTypeLazyTypeResolver("gw.util.science.MassUnit", "_default_"), (LazyTypeResolver)new SimpleTypeLazyTypeResolver("gw.util.science.VelocityUnit", "_default_"), (LazyTypeResolver)new SimpleTypeLazyTypeResolver("gw.util.science.Momentum", "_default_"), (LazyTypeResolver)new SimpleTypeLazyTypeResolver("gw.util.science.MomentumUnit", "_default_"), massUnit, velocityUnit, factor, name, symbol);
    }

    public static MomentumUnit get(MassUnit massUnit, VelocityUnit velocityUnit, Rational factor, String name, String symbol) {
        MomentumUnit unit = new MomentumUnit(massUnit, velocityUnit, factor, name, symbol);
        return (MomentumUnit)CACHE.get(unit);
    }

    public MassUnit getMassUnit() {
        return (MassUnit)this.getLeftUnit();
    }

    public VelocityUnit getVelocityUnit() {
        return (VelocityUnit)this.getRightUnit();
    }

    public EnergyUnit multiply(VelocityUnit v) {
        return EnergyUnit.get(this.getMassUnit().multiply(this.getVelocityUnit().divide(v.getTimeUnit())), v.getLengthUnit(), null, null, null);
    }

    public MassUnit divide(VelocityUnit w) {
        return this.getMassUnit();
    }

    @Override
    public /* synthetic */ IType getIntrinsicType() {
        return GosuRuntimeMethods.getType((Object)this);
    }
}

