/*
 * Decompiled with CFR 0.152.
 */
package gw.util.science;

import gw.internal.gosu.runtime.GosuRuntimeMethods;
import gw.lang.reflect.IEnumValue;
import gw.lang.reflect.IType;
import gw.lang.reflect.gs.GosuClassPathThing;
import gw.lang.reflect.gs.IGosuObject;
import gw.util.Rational;
import gw.util.science.AccelerationUnit;
import gw.util.science.AreaUnit;
import gw.util.science.DensityUnit;
import gw.util.science.ForceUnit;
import gw.util.science.IUnit;
import gw.util.science.Mass;
import gw.util.science.MetricScaleUnit;
import gw.util.science.MomentumUnit;
import gw.util.science.PressureUnit;
import gw.util.science.VelocityUnit;
import gw.util.science.VolumeUnit;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;

public final class MassUnit
extends Enum<MassUnit>
implements IEnumValue,
IUnit<Rational, Mass, MassUnit>,
IGosuObject {
    Rational _kilograms;
    String _name;
    String _symbol;
    public static final MassUnit AtomicMass;
    public static final MassUnit Nano;
    public static final MassUnit Micro;
    public static final MassUnit Milli;
    public static final MassUnit Gram;
    public static final MassUnit Kilogram;
    public static final MassUnit Tonne;
    public static final MassUnit Carat;
    public static final MassUnit Dram;
    public static final MassUnit Grain;
    public static final MassUnit Newton;
    public static final MassUnit Ounce;
    public static final MassUnit TroyOunce;
    public static final MassUnit Pound;
    public static final MassUnit Stone;
    public static final MassUnit Ton;
    public static final MassUnit TonUK;
    public static final MassUnit Solar;
    private static final /* synthetic */ MassUnit[] ENUM$VALUES;

    static {
        GosuClassPathThing.init();
        AtomicMass = new MassUnit(Rational.get((BigInteger)new BigInteger("16605402"), (BigInteger)new BigInteger("10000000000000000000000000000000000")), "AMU", "amu");
        Nano = new MassUnit(MetricScaleUnit.p.postfixBind(Rational.ONE), "Nanogram", "\u00b5g");
        Micro = new MassUnit(MetricScaleUnit.n.postfixBind(Rational.ONE), "Microgram", "\u00b5g");
        Milli = new MassUnit(MetricScaleUnit.u.postfixBind(Rational.ONE), "Milligram", "mg");
        Gram = new MassUnit(MetricScaleUnit.m.postfixBind(Rational.ONE), "Gram", "g");
        Kilogram = new MassUnit(Rational.ONE, "Kilogram", "kg");
        Tonne = new MassUnit(MetricScaleUnit.k.postfixBind(Rational.ONE), "Metric Ton", "tonne");
        Carat = new MassUnit(Rational.get((long)2L, (long)10000L), "Carat", "ct");
        Dram = new MassUnit(Rational.get((long)1771845195312L, (long)1000000000000000L), "Dram", "dr");
        Grain = new MassUnit(Rational.get((long)647989L, (long)10000000000L), "Grain", "gr");
        Newton = new MassUnit(Rational.get((long)101971621L, (long)1000000000L), "Newton", "N");
        Ounce = new MassUnit(Rational.get((long)283495L, (long)10000000L), "Ounce", "oz");
        TroyOunce = new MassUnit(Rational.get((long)311035L, (long)10000000L), "Troy Ounce", "ozt");
        Pound = new MassUnit(Rational.get((long)453592L, (long)1000000L), "Pound", "lb");
        Stone = new MassUnit(Rational.get((long)635029L, (long)100000L), "Stone", "st");
        Ton = new MassUnit(Rational.get((long)907185L, (long)1000L), "Ton (US, short)", "sht");
        TonUK = new MassUnit(Rational.get((long)101605L, (long)100L), "Ton (UK, long)", "lt");
        Solar = new MassUnit(Rational.get((BigInteger)new BigInteger("19889200011445836000000000000000"), (BigInteger)new BigInteger("10")), "Solar Masses", "M\u2609");
        MassUnit[] massUnitArray = new MassUnit[]{AtomicMass, Nano, Micro, Milli, Gram, Kilogram, Tonne, Carat, Dram, Grain, Newton, Ounce, TroyOunce, Pound, Stone, Ton, TonUK, Solar};
        ENUM$VALUES = massUnitArray;
    }

    MassUnit(Rational kilograms, String name, String symbol) {
        this._kilograms = kilograms;
        this._name = name;
        this._symbol = symbol;
    }

    public static MassUnit getBASE() {
        return Kilogram;
    }

    public Rational getKilograms() {
        return this._kilograms;
    }

    public void setKilograms(Rational rational) {
        this._kilograms = rational;
    }

    @Override
    public String getUnitName() {
        return this._name;
    }

    @Override
    public String getUnitSymbol() {
        return this._symbol;
    }

    public Rational toBaseUnits(Rational myUnits) {
        Rational rational = this.getKilograms();
        Rational rational2 = myUnits;
        Rational rational3 = rational;
        Rational rational4 = rational2;
        return rational3.multiply(rational4);
    }

    public Rational toNumber() {
        return this.getKilograms();
    }

    public Rational from(Mass w) {
        Rational rational = w.toBaseNumber();
        Rational rational2 = this.getKilograms();
        Rational rational3 = rational;
        Rational rational4 = rational2;
        return rational3.divide(rational4);
    }

    public MomentumUnit multiply(VelocityUnit velocity) {
        return MomentumUnit.get(this, velocity, null, null, null);
    }

    public ForceUnit multiply(AccelerationUnit acc) {
        return ForceUnit.get(this, acc, null, null, null);
    }

    public PressureUnit divide(AreaUnit area) {
        return PressureUnit.get(this, area, null, null, null);
    }

    public AreaUnit divide(PressureUnit pressure) {
        return pressure.getAreaUnit();
    }

    public DensityUnit divide(VolumeUnit volume) {
        return DensityUnit.get(this, volume, null, null, null);
    }

    public VolumeUnit divide(DensityUnit d) {
        return d.getVolumeUnit();
    }

    public /* synthetic */ IType getIntrinsicType() {
        return GosuRuntimeMethods.getType((Object)this);
    }

    public static MassUnit[] values() {
        MassUnit[] massUnitArray = new MassUnit[18];
        System.arraycopy(ENUM$VALUES, 0, massUnitArray, 0, 18);
        return massUnitArray;
    }

    public static List getAllValues() {
        return Arrays.asList(MassUnit.values());
    }

    public static MassUnit valueOf(String string) {
        return Enum.valueOf(MassUnit.class, string);
    }

    public final Object getValue() {
        return this;
    }

    public final String getCode() {
        return this.name();
    }

    public final int getOrdinal() {
        return this.ordinal();
    }

    public final String getDisplayName() {
        return this.toString();
    }

    public final String getName() {
        return this.name();
    }
}

