/*
 * Decompiled with CFR 0.152.
 */
package gw.util.money;

import gw.internal.gosu.ir.transform.expression.TypeAsTransformer;
import gw.internal.gosu.ir.transform.statement.ForEachStatementTransformer;
import gw.internal.gosu.runtime.GosuRuntimeMethods;
import gw.lang.IDimension;
import gw.lang.enhancements.CoreIterableEnhancement;
import gw.lang.enhancements.CoreMapEnhancement;
import gw.lang.function.Procedure2;
import gw.lang.ir.Internal;
import gw.lang.parser.ICoercer;
import gw.lang.parser.coercers.RuntimeCoercer;
import gw.lang.reflect.ClassLazyTypeResolver;
import gw.lang.reflect.IType;
import gw.lang.reflect.LazyTypeResolver;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.gs.IGosuObject;
import gw.util.Rational;
import gw.util.money.CoreCurrencyEnhancement;
import gw.util.money.CurrencyExchange;
import gw.util.money.IExchangeRate;
import gw.util.money.RateType;
import java.text.NumberFormat;
import java.util.Currency;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import manifold.internal.runtime.Bootstrap;

public final class Money
implements IDimension<Money, Rational>,
IGosuObject {
    final Map<Currency, Rational> _amount;

    static {
        Bootstrap.init();
    }

    public Money(Rational value, Currency currency) {
        HashMap<Currency, Rational> hashMap = new HashMap<Currency, Rational>();
        hashMap.put(currency, value);
        this._amount = hashMap;
    }

    @Internal
    Money(Map<Currency, Rational> amount) {
        this._amount = amount;
    }

    public Map<Currency, Rational> getAmount() {
        return this._amount;
    }

    public Rational getSingleValue() {
        if (this.getAmount().size() == 1) {
            Map<Currency, Rational> map = this.getAmount();
            if (map == null) {
                throw new NullPointerException();
            }
            map = CoreMapEnhancement.getValues(map);
            LazyTypeResolver lazyTypeResolver = new LazyTypeResolver(() -> TypeSystem.getByFullName((String)"gw.util.Rational", (String)"_default_"));
            if (map == null) {
                throw new NullPointerException();
            }
            return (Rational)CoreIterableEnhancement.first((Iterable)((Object)map), lazyTypeResolver);
        }
        throw new RuntimeException("Multiple currency amount");
    }

    public Currency getSingleUnit() {
        if (this.getAmount().size() == 1) {
            Map<Currency, Rational> map = this.getAmount();
            if (map == null) {
                throw new NullPointerException();
            }
            map = CoreMapEnhancement.getKeys(map);
            ClassLazyTypeResolver classLazyTypeResolver = new ClassLazyTypeResolver(Currency.class);
            if (map == null) {
                throw new NullPointerException();
            }
            return (Currency)CoreIterableEnhancement.first((Iterable)((Object)map), (LazyTypeResolver)classLazyTypeResolver);
        }
        throw new RuntimeException("Multiple currency amount");
    }

    public Money fromNumber(Rational value) {
        if (this.getAmount().size() == 1) {
            return new Money(value, this.getSingleUnit());
        }
        throw new RuntimeException("Multiple currency amount");
    }

    public Class<Rational> numberType() {
        return Rational.class;
    }

    public Rational toNumber() {
        return this.getSingleValue();
    }

    public String toString() {
        return this.toString(Locale.getDefault());
    }

    /*
     * WARNING - void declaration
     */
    public String toString(Locale locale) {
        void sb;
        void format;
        NumberFormat[] numberFormatArray = new NumberFormat[]{NumberFormat.getInstance(locale)};
        if (this.getAmount().size() == 1) {
            format[0].setMaximumFractionDigits(this.getSingleUnit().getDefaultFractionDigits());
            format[0].setGroupingUsed(true);
            return format[0].format(this.getSingleValue()) + " " + this.getSingleUnit().getCurrencyCode();
        }
        StringBuilder[] stringBuilderArray = new StringBuilder[]{new StringBuilder()};
        Map<Currency, Rational> map = this.getAmount();
        block_0_ block_0_2 = new block_0_(this, (NumberFormat[])format, (StringBuilder[])sb);
        if (map == null) {
            throw new NullPointerException();
        }
        CoreMapEnhancement.eachKeyAndValue(map, block_0_2);
        return sb[0].toString();
    }

    public int hashCode() {
        return this._amount.hashCode();
    }

    public boolean equals(Object o) {
        Map<Currency, Rational> map;
        Map<Currency, Rational> map2;
        return o instanceof Money && ((map2 = this._amount) == (map = ((map = o) instanceof Money || map == null ? (Money)((Object)map) : (Money)TypeAsTransformer.coerceValue(map, (IType)TypeSystem.getByFullName((String)"gw.util.money.Money", (String)"_default_"), (ICoercer)RuntimeCoercer.instance()))._amount) || map2 != null && map != null && ((Object)map2).equals(map));
    }

    public int compareTo(Money o) {
        Currency currency;
        Currency currency2;
        if (this._amount.size() == 1 && o._amount.size() == 1 && ((currency2 = this.getSingleUnit()) == (currency = o.getSingleUnit()) || currency2 != null && currency != null && currency2.equals(currency))) {
            return this.getSingleValue().compareTo(o.getSingleValue());
        }
        return this.exchange(CoreCurrencyEnhancement.getBASE(), RateType.Mid).compareTo(o.exchange(CoreCurrencyEnhancement.getBASE(), RateType.Mid));
    }

    /*
     * WARNING - void declaration
     */
    public Money exchange(Currency currency, RateType rateType) {
        void currency2;
        Currency[] currencyArray = new Currency[]{currency};
        RateType[] rateTypeArray = new RateType[]{rateType};
        RateType[] rateType2 = rateTypeArray;
        Map[] mapArray = new Map[]{CurrencyExchange.instance().getExchangeRatesService().getExchangeRatesTable((Currency)currency2[0])};
        Map[] rateTable = mapArray;
        Rational[] rationalArray = new Rational[]{Rational.ZERO};
        Rational[] total = rationalArray;
        Map<Currency, Rational> map = this.getAmount();
        block_1_ block_1_2 = new block_1_(this, rateType2, (Currency[])currency2, total, rateTable);
        if (map == null) {
            throw new NullPointerException();
        }
        CoreMapEnhancement.eachKeyAndValue(map, block_1_2);
        return new Money(total[0], (Currency)currency2[0]);
    }

    /*
     * WARNING - void declaration
     */
    public Money weightedExchange(Money money, RateType rateType) {
        void rateType2;
        void to;
        RateType[] rateTypeArray = new RateType[]{rateType};
        Map[] mapArray = new Map[]{CurrencyExchange.instance().getExchangeRatesService().getExchangeRatesTable(CoreCurrencyEnhancement.getBASE())};
        Map[] baseTable = mapArray;
        Money[] moneyArray = new Money[]{to.exchange(CoreCurrencyEnhancement.getBASE(), RateType.Mid)};
        Money[] totalTo = moneyArray;
        Money[] moneyArray2 = new Money[]{this.exchange(CoreCurrencyEnhancement.getBASE(), RateType.Mid)};
        Money[] totalFrom = moneyArray2;
        HashMap[] hashMapArray = new HashMap[]{new HashMap()};
        HashMap[] result = hashMapArray;
        Map<Currency, Rational> map = to.getAmount();
        block_2_ block_2_2 = new block_2_(this, result, (RateType[])rateType2, totalTo, baseTable, totalFrom);
        if (map == null) {
            throw new NullPointerException();
        }
        CoreMapEnhancement.eachKeyAndValue(map, block_2_2);
        return new Money(result[0]);
    }

    public Money add(Money money) {
        HashMap<Currency, Rational> sum = new HashMap<Currency, Rational>(this._amount);
        Iterator iterator = ForEachStatementTransformer.makeIterator(money._amount.entrySet(), (boolean)true);
        Object var4_4 = null;
        if (iterator != null) {
            while (iterator.hasNext()) {
                Object object;
                Rational rational;
                Map.Entry entrySet = (Map.Entry)iterator.next();
                Rational value = sum.get((Currency)entrySet.getKey());
                if (value == null) {
                    rational = (Rational)entrySet.getValue();
                } else {
                    object = value;
                    Rational rational2 = (Rational)entrySet.getValue();
                    Object object2 = object;
                    Rational rational3 = rational2;
                    rational = object2.add(rational3);
                }
                value = rational;
                object = sum;
                ((HashMap)object).put((Currency)entrySet.getKey(), value);
            }
        }
        return new Money(sum);
    }

    public Money subtract(Money money) {
        HashMap<Currency, Rational> sum = new HashMap<Currency, Rational>(this._amount);
        Iterator iterator = ForEachStatementTransformer.makeIterator(money._amount.entrySet(), (boolean)true);
        Object var4_4 = null;
        if (iterator != null) {
            while (iterator.hasNext()) {
                Object object;
                Rational rational;
                Map.Entry entrySet = (Map.Entry)iterator.next();
                Rational value = sum.get((Currency)entrySet.getKey());
                if (value == null) {
                    rational = (Rational)entrySet.getValue();
                } else {
                    object = value;
                    Rational rational2 = (Rational)entrySet.getValue();
                    Object object2 = object;
                    Rational rational3 = rational2;
                    rational = object2.subtract(rational3);
                }
                value = rational;
                object = sum;
                ((HashMap)object).put((Currency)entrySet.getKey(), value);
            }
        }
        return new Money(sum);
    }

    public Money multiply(Rational value) {
        HashMap<Currency, Rational> product = new HashMap<Currency, Rational>();
        Iterator iterator = ForEachStatementTransformer.makeIterator(this._amount.entrySet(), (boolean)true);
        Object var4_4 = null;
        if (iterator != null) {
            while (iterator.hasNext()) {
                Map.Entry entrySet = (Map.Entry)iterator.next();
                Rational rational = (Rational)entrySet.getValue();
                Object object = value;
                Rational rational2 = rational;
                Rational rational3 = object;
                Rational result = rational2.multiply(rational3);
                object = product;
                ((HashMap)object).put((Currency)entrySet.getKey(), result);
            }
        }
        return new Money(product);
    }

    public Money divide(Rational value) {
        HashMap<Currency, Rational> quotient = new HashMap<Currency, Rational>();
        Iterator iterator = ForEachStatementTransformer.makeIterator(this._amount.entrySet(), (boolean)true);
        Object var4_4 = null;
        if (iterator != null) {
            while (iterator.hasNext()) {
                Map.Entry entrySet = (Map.Entry)iterator.next();
                Rational rational = (Rational)entrySet.getValue();
                Object object = value;
                Rational rational2 = rational;
                Rational rational3 = object;
                Rational result = rational2.divide(rational3);
                object = quotient;
                ((HashMap)object).put((Currency)entrySet.getKey(), result);
            }
        }
        return new Money(quotient);
    }

    public Rational divide(Money money) {
        Currency currency;
        Currency currency2;
        if (this._amount.size() == 1 && money._amount.size() == 1 && ((currency2 = this.getSingleUnit()) == (currency = money.getSingleUnit()) || currency2 != null && currency != null && currency2.equals(currency))) {
            currency2 = this.getSingleValue();
            currency = money.getSingleValue();
            Currency currency3 = currency2;
            Currency currency4 = currency;
            return currency3.divide((Rational)currency4);
        }
        return this.exchange(CoreCurrencyEnhancement.getBASE(), RateType.Mid).divide(money.exchange(CoreCurrencyEnhancement.getBASE(), RateType.Mid));
    }

    public Money modulo(Rational value) {
        HashMap<Currency, Rational> mod = new HashMap<Currency, Rational>();
        Iterator iterator = ForEachStatementTransformer.makeIterator(this._amount.entrySet(), (boolean)true);
        Object var4_4 = null;
        if (iterator != null) {
            while (iterator.hasNext()) {
                Map.Entry entrySet = (Map.Entry)iterator.next();
                Rational rational = (Rational)entrySet.getValue();
                Object object = value;
                Rational rational2 = rational;
                Rational rational3 = object;
                Rational result = rational2.modulo(rational3);
                object = mod;
                ((HashMap)object).put((Currency)entrySet.getKey(), result);
            }
        }
        return new Money(mod);
    }

    public Rational modulo(Money money) {
        Currency currency;
        Currency currency2;
        if (this._amount.size() == 1 && money._amount.size() == 1 && ((currency2 = this.getSingleUnit()) == (currency = money.getSingleUnit()) || currency2 != null && currency != null && currency2.equals(currency))) {
            currency2 = this.getSingleValue();
            currency = money.getSingleValue();
            Currency currency3 = currency2;
            Currency currency4 = currency;
            return currency3.modulo((Rational)currency4);
        }
        return this.exchange(CoreCurrencyEnhancement.getBASE(), RateType.Mid).modulo(money.exchange(CoreCurrencyEnhancement.getBASE(), RateType.Mid));
    }

    public Money negate() {
        HashMap<Currency, Rational> negation = new HashMap<Currency, Rational>();
        Iterator iterator = ForEachStatementTransformer.makeIterator(this._amount.entrySet(), (boolean)true);
        Object var3_3 = null;
        if (iterator != null) {
            while (iterator.hasNext()) {
                Map.Entry entrySet = (Map.Entry)iterator.next();
                HashMap<Currency, Rational> hashMap = negation;
                hashMap.put((Currency)entrySet.getKey(), ((Rational)entrySet.getValue()).negate());
            }
        }
        return new Money(negation);
    }

    public /* synthetic */ IType getIntrinsicType() {
        return GosuRuntimeMethods.getType((Object)this);
    }

    public class block_0_
    extends Procedure2 {
        final /* synthetic */ Money this$0;
        private final /* synthetic */ NumberFormat[] val$format;
        private final /* synthetic */ StringBuilder[] val$sb;

        static {
            Bootstrap.init();
        }

        public block_0_(Money money, NumberFormat[] numberFormatArray, StringBuilder[] stringBuilderArray) {
            this.val$format = numberFormatArray;
            this.val$sb = stringBuilderArray;
            this.this$0 = money;
        }

        /*
         * WARNING - void declaration
         */
        public final void invoke(Object object, Object object2) {
            void k;
            Currency currency = (Currency)object;
            Rational v = (Rational)object2;
            this.val$format[0].setMaximumFractionDigits(k.getDefaultFractionDigits());
            this.val$format[0].setGroupingUsed(true);
            this.val$sb[0].append(this.val$format[0].format(v)).append(" ").append(k.getCurrencyCode()).append("\n");
        }

        static /* synthetic */ Money access$0(block_0_ block_0_2) {
            return block_0_2.this$0;
        }
    }

    public class block_1_
    extends Procedure2 {
        final /* synthetic */ Money this$0;
        private final /* synthetic */ RateType[] val$rateType;
        private final /* synthetic */ Currency[] val$currency;
        private final /* synthetic */ Rational[] val$total;
        private final /* synthetic */ Map[] val$rateTable;

        static {
            Bootstrap.init();
        }

        public block_1_(Money money, RateType[] rateTypeArray, Currency[] currencyArray, Rational[] rationalArray, Map[] mapArray) {
            this.val$rateType = rateTypeArray;
            this.val$currency = currencyArray;
            this.val$total = rationalArray;
            this.val$rateTable = mapArray;
            this.this$0 = money;
        }

        /*
         * WARNING - void declaration
         */
        public final void invoke(Object object, Object object2) {
            void k;
            Currency currency = (Currency)object;
            Rational v = (Rational)object2;
            Rational rational = k;
            Currency currency2 = this.val$currency[0];
            if (rational == currency2 || rational != null && currency2 != null && rational.equals(currency2)) {
                rational = this.val$total[0];
                currency2 = v;
                Rational rational2 = rational;
                Currency currency3 = currency2;
                this.val$total[0] = rational2.add((Rational)currency3);
            } else {
                rational = this.val$total[0];
                currency2 = v;
                Rational rational3 = ((IExchangeRate)this.val$rateTable[0].get(k)).get(this.val$rateType[0]);
                Currency currency4 = currency2;
                Rational rational4 = rational3;
                currency2 = currency4.divide(rational4);
                rational3 = rational;
                currency4 = currency2;
                this.val$total[0] = rational3.add((Rational)currency4);
            }
        }

        static /* synthetic */ Money access$0(block_1_ block_1_2) {
            return block_1_2.this$0;
        }
    }

    public class block_2_
    extends Procedure2 {
        final /* synthetic */ Money this$0;
        private final /* synthetic */ HashMap[] val$result;
        private final /* synthetic */ RateType[] val$rateType;
        private final /* synthetic */ Money[] val$totalTo;
        private final /* synthetic */ Map[] val$baseTable;
        private final /* synthetic */ Money[] val$totalFrom;

        static {
            Bootstrap.init();
        }

        public block_2_(Money money, HashMap[] hashMapArray, RateType[] rateTypeArray, Money[] moneyArray, Map[] mapArray, Money[] moneyArray2) {
            this.val$result = hashMapArray;
            this.val$rateType = rateTypeArray;
            this.val$totalTo = moneyArray;
            this.val$baseTable = mapArray;
            this.val$totalFrom = moneyArray2;
            this.this$0 = money;
        }

        /*
         * WARNING - void declaration
         */
        public final void invoke(Object object, Object object2) {
            void k;
            Currency currency = (Currency)object;
            Rational v = (Rational)object2;
            Rational rational = k;
            Currency currency2 = CoreCurrencyEnhancement.getBASE();
            if (rational == currency2 || rational != null && currency2 != null && rational.equals(currency2)) {
                rational = v;
                currency2 = this.val$totalTo[0].getSingleValue();
                Rational rational2 = rational;
                Currency currency3 = currency2;
                rational = rational2.divide((Rational)currency3);
                currency2 = this.val$totalFrom[0].getSingleValue();
                rational2 = rational;
                currency3 = currency2;
                this.val$result[0].put(k, rational2.multiply((Rational)currency3));
            } else {
                Map<Currency, IExchangeRate> rateTable = CurrencyExchange.instance().getExchangeRatesService().getExchangeRatesTable((Currency)k);
                currency2 = v;
                Rational rational3 = ((IExchangeRate)this.val$baseTable[0].get(k)).get(this.val$rateType[0]);
                Currency currency4 = currency2;
                Rational rational4 = rational3;
                currency2 = currency4.divide(rational4);
                rational3 = this.val$totalTo[0].getSingleValue();
                currency4 = currency2;
                rational4 = rational3;
                currency2 = currency4.divide(rational4);
                rational3 = this.val$totalFrom[0].getSingleValue();
                currency4 = currency2;
                rational4 = rational3;
                currency2 = currency4.multiply(rational4);
                rational3 = rateTable.get(CoreCurrencyEnhancement.getBASE()).get(this.val$rateType[0]);
                currency4 = currency2;
                rational4 = rational3;
                this.val$result[0].put(k, currency4.divide(rational4));
            }
        }

        static /* synthetic */ Money access$0(block_2_ block_2_2) {
            return block_2_2.this$0;
        }
    }
}

