/*
 * Decompiled with CFR 0.152.
 */
package gw.util.science;

import gw.internal.gosu.runtime.GosuRuntimeMethods;
import gw.lang.reflect.IType;
import gw.lang.reflect.LazyTypeResolver;
import gw.lang.reflect.SimpleTypeLazyTypeResolver;
import gw.lang.reflect.gs.GosuClassPathThing;
import gw.lang.reflect.gs.IGosuObject;
import gw.util.Rational;
import gw.util.science.AbstractQuotientUnit;
import gw.util.science.AccelerationUnit;
import gw.util.science.ForceUnit;
import gw.util.science.LengthUnit;
import gw.util.science.MassUnit;
import gw.util.science.MomentumUnit;
import gw.util.science.PowerUnit;
import gw.util.science.TimeUnit;
import gw.util.science.UnitCache;
import gw.util.science.Velocity;

public final class VelocityUnit
extends AbstractQuotientUnit<LengthUnit, TimeUnit, Velocity, VelocityUnit>
implements IGosuObject {
    static final UnitCache<VelocityUnit> CACHE;
    public static VelocityUnit BASE;
    public static VelocityUnit mph;

    static {
        GosuClassPathThing.init();
        CACHE = new UnitCache((LazyTypeResolver)new SimpleTypeLazyTypeResolver("gw.util.science.VelocityUnit", "_default_"));
        BASE = VelocityUnit.get(LengthUnit.Meter, TimeUnit.Second, null, null, null);
        mph = VelocityUnit.get(LengthUnit.Mile, TimeUnit.Hour, Rational.ONE, "MPH", "mph");
    }

    VelocityUnit(LengthUnit lengthUnit, TimeUnit timeUnit, Rational factor, String name, String symbol) {
        super((LazyTypeResolver)new SimpleTypeLazyTypeResolver("gw.util.science.LengthUnit", "_default_"), (LazyTypeResolver)new SimpleTypeLazyTypeResolver("gw.util.science.TimeUnit", "_default_"), (LazyTypeResolver)new SimpleTypeLazyTypeResolver("gw.util.science.Velocity", "_default_"), (LazyTypeResolver)new SimpleTypeLazyTypeResolver("gw.util.science.VelocityUnit", "_default_"), lengthUnit, timeUnit, factor, name, symbol);
    }

    public static VelocityUnit get(LengthUnit lengthUnit, TimeUnit timeUnit, Rational factor, String name, String symbol) {
        VelocityUnit unit = new VelocityUnit(lengthUnit, timeUnit, factor, name, symbol);
        return (VelocityUnit)CACHE.get(unit);
    }

    public LengthUnit getLengthUnit() {
        return (LengthUnit)this.getLeftUnit();
    }

    public TimeUnit getTimeUnit() {
        return (TimeUnit)this.getRightUnit();
    }

    public MomentumUnit postfixBind(MassUnit mass) {
        return this.multiply(mass);
    }

    public MomentumUnit multiply(MassUnit t) {
        return MomentumUnit.get(t, this, null, null, null);
    }

    public PowerUnit multiply(ForceUnit force) {
        return force.multiply(this.getLengthUnit()).divide(this.getTimeUnit());
    }

    public AccelerationUnit divide(TimeUnit t) {
        return AccelerationUnit.get(this, t, null, null, null);
    }

    @Override
    public /* synthetic */ IType getIntrinsicType() {
        return GosuRuntimeMethods.getType((Object)this);
    }
}

