/*
 * Decompiled with CFR 0.152.
 */
package gw.util.science;

import gw.internal.gosu.runtime.GosuRuntimeMethods;
import gw.lang.reflect.IEnumValue;
import gw.lang.reflect.IType;
import gw.lang.reflect.gs.GosuClassPathThing;
import gw.lang.reflect.gs.IGosuObject;
import gw.util.Rational;
import gw.util.science.AreaUnit;
import gw.util.science.EnergyUnit;
import gw.util.science.ForceUnit;
import gw.util.science.IUnit;
import gw.util.science.Length;
import gw.util.science.MetricScaleUnit;
import gw.util.science.TimeUnit;
import gw.util.science.VelocityUnit;
import gw.util.science.VolumeUnit;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;

public final class LengthUnit
extends Enum<LengthUnit>
implements IEnumValue,
IUnit<Rational, Length, LengthUnit>,
IGosuObject {
    final Rational _meters;
    final String _name;
    final String _symbol;
    public static final LengthUnit Planck;
    public static final LengthUnit Femto;
    public static final LengthUnit Pico;
    public static final LengthUnit Angstrom;
    public static final LengthUnit Nano;
    public static final LengthUnit Micro;
    public static final LengthUnit Milli;
    public static final LengthUnit Centi;
    public static final LengthUnit Deci;
    public static final LengthUnit Meter;
    public static final LengthUnit Kilometer;
    public static final LengthUnit Megameter;
    public static final LengthUnit Gigameter;
    public static final LengthUnit Terameter;
    public static final LengthUnit Cubit;
    public static final LengthUnit Caliber;
    public static final LengthUnit Inch;
    public static final LengthUnit Foot;
    public static final LengthUnit Yard;
    public static final LengthUnit Rod;
    public static final LengthUnit Chain;
    public static final LengthUnit Furlong;
    public static final LengthUnit Mile;
    public static final LengthUnit NauticalMile;
    public static final LengthUnit IAU;
    public static final LengthUnit LightYear;
    private static final /* synthetic */ LengthUnit[] ENUM$VALUES;

    static {
        GosuClassPathThing.init();
        Planck = new LengthUnit(Rational.get((BigInteger)new BigInteger("161605"), (BigInteger)new BigInteger("10000000000000000000000000000000000000000")), "Planck-length", "\u2113P");
        Femto = new LengthUnit(MetricScaleUnit.fe.postfixBind(Rational.ONE), "Femtometer", "fm");
        Pico = new LengthUnit(MetricScaleUnit.p.postfixBind(Rational.ONE), "Picometer", "pm");
        Angstrom = new LengthUnit(Rational.get((long)1L, (long)10000000000L), "Angstrom", "\u00c5");
        Nano = new LengthUnit(MetricScaleUnit.n.postfixBind(Rational.ONE), "Nanometer", "nm");
        Micro = new LengthUnit(MetricScaleUnit.u.postfixBind(Rational.ONE), "Micrometre", "\u00b5m");
        Milli = new LengthUnit(MetricScaleUnit.m.postfixBind(Rational.ONE), "Millimeter", "mm");
        Centi = new LengthUnit(MetricScaleUnit.c.postfixBind(Rational.ONE), "Centimeter", "cm");
        Deci = new LengthUnit(MetricScaleUnit.de.postfixBind(Rational.ONE), "Decimeter", "dm");
        Meter = new LengthUnit(Rational.ONE, "Meter", "m");
        Kilometer = new LengthUnit(MetricScaleUnit.k.postfixBind(Rational.ONE), "Kilometer", "km");
        Megameter = new LengthUnit(MetricScaleUnit.M.postfixBind(Rational.ONE), "Megameter", "Mm");
        Gigameter = new LengthUnit(MetricScaleUnit.G.postfixBind(Rational.ONE), "Gigameter", "Gm");
        Terameter = new LengthUnit(MetricScaleUnit.T.postfixBind(Rational.ONE), "Terameter", "Tm");
        Cubit = new LengthUnit(Rational.get((long)4572L, (long)10000L), "Cubit", "cbt");
        Caliber = new LengthUnit(Rational.get((long)254L, (long)1000000L), "Caliber", "cal.");
        Inch = new LengthUnit(Rational.get((long)254L, (long)10000L), "Inch", "in");
        LengthUnit[] lengthUnitArray = Rational.get((long)12L);
        Rational rational = Rational.get((long)254L, (long)10000L);
        LengthUnit[] lengthUnitArray2 = lengthUnitArray;
        Rational rational2 = rational;
        Foot = new LengthUnit(lengthUnitArray2.multiply(rational2), "Foot", "ft");
        lengthUnitArray = Rational.get((long)3L);
        rational = Rational.get((long)12L);
        lengthUnitArray2 = lengthUnitArray;
        rational2 = rational;
        lengthUnitArray = lengthUnitArray2.multiply(rational2);
        rational = Rational.get((long)254L, (long)10000L);
        lengthUnitArray2 = lengthUnitArray;
        rational2 = rational;
        Yard = new LengthUnit(lengthUnitArray2.multiply(rational2), "Yard", "yd");
        Rod = new LengthUnit(Rational.get((long)50292L, (long)10000L), "Rod", "rd");
        Chain = new LengthUnit(Rational.get((long)201168L, (long)10000L), "Chain", "ch");
        Furlong = new LengthUnit(Rational.get((long)201168L, (long)1000L), "Furlong", "fur");
        Mile = new LengthUnit(Rational.get((long)1609344L, (long)1000L), "Mile", "mi");
        NauticalMile = new LengthUnit(Rational.get((long)1852L), "NauticalMile", "n.m.");
        IAU = new LengthUnit(Rational.get((long)1495978700000L, (long)10L), "IAU-length", "au");
        LightYear = new LengthUnit(Rational.get((long)94607304730000000L, (long)10L), "LightYear", "ly");
        lengthUnitArray = new LengthUnit[]{Planck, Femto, Pico, Angstrom, Nano, Micro, Milli, Centi, Deci, Meter, Kilometer, Megameter, Gigameter, Terameter, Cubit, Caliber, Inch, Foot, Yard, Rod, Chain, Furlong, Mile, NauticalMile, IAU, LightYear};
        ENUM$VALUES = lengthUnitArray;
    }

    LengthUnit(Rational meters, String name, String symbol) {
        this._meters = meters;
        this._name = name;
        this._symbol = symbol;
    }

    public static LengthUnit getBASE() {
        return Meter;
    }

    public Rational getMeters() {
        return this._meters;
    }

    @Override
    public String getUnitName() {
        return this._name;
    }

    @Override
    public String getUnitSymbol() {
        return this._symbol;
    }

    public Rational toBaseUnits(Rational myUnits) {
        Rational rational = this.getMeters();
        Rational rational2 = myUnits;
        Rational rational3 = rational;
        Rational rational4 = rational2;
        return rational3.multiply(rational4);
    }

    public Rational toNumber() {
        return this.getMeters();
    }

    public Rational from(Length len) {
        Rational rational = len.toBaseNumber();
        Rational rational2 = this.getMeters();
        Rational rational3 = rational;
        Rational rational4 = rational2;
        return rational3.divide(rational4);
    }

    public EnergyUnit postfixBind(ForceUnit f) {
        return this.multiply(f);
    }

    public VelocityUnit divide(TimeUnit t) {
        return VelocityUnit.get(this, t, null, null, null);
    }

    public TimeUnit divide(VelocityUnit v) {
        return v.getTimeUnit();
    }

    public AreaUnit multiply(LengthUnit len) {
        return AreaUnit.get(this, len, null, null, null);
    }

    public VolumeUnit multiply(AreaUnit area) {
        return VolumeUnit.get(this, area, null, null, null);
    }

    public EnergyUnit multiply(ForceUnit f) {
        return EnergyUnit.get(f, this, null, null, null);
    }

    public /* synthetic */ IType getIntrinsicType() {
        return GosuRuntimeMethods.getType((Object)this);
    }

    public static LengthUnit[] values() {
        LengthUnit[] lengthUnitArray = new LengthUnit[26];
        System.arraycopy(ENUM$VALUES, 0, lengthUnitArray, 0, 26);
        return lengthUnitArray;
    }

    public static List getAllValues() {
        return Arrays.asList(LengthUnit.values());
    }

    public static LengthUnit valueOf(String string) {
        return Enum.valueOf(LengthUnit.class, string);
    }

    public final Object getValue() {
        return this;
    }

    public final String getCode() {
        return this.name();
    }

    public final int getOrdinal() {
        return this.ordinal();
    }

    public final String getDisplayName() {
        return this.toString();
    }

    public final String getName() {
        return this.name();
    }
}

