/*
 * Decompiled with CFR 0.152.
 */
package gw.util.science;

import gw.internal.gosu.runtime.GosuRuntimeMethods;
import gw.lang.reflect.IType;
import gw.lang.reflect.LazyTypeResolver;
import gw.lang.reflect.SimpleTypeLazyTypeResolver;
import gw.lang.reflect.gs.GosuClassPathThing;
import gw.lang.reflect.gs.IGosuObject;
import gw.util.Rational;
import gw.util.science.AbstractProductUnit;
import gw.util.science.CurrentUnit;
import gw.util.science.Energy;
import gw.util.science.ForceUnit;
import gw.util.science.HeatCapacityUnit;
import gw.util.science.LengthUnit;
import gw.util.science.MagneticFluxUnit;
import gw.util.science.MetricScaleUnit;
import gw.util.science.PowerUnit;
import gw.util.science.TemperatureUnit;
import gw.util.science.TimeUnit;
import gw.util.science.UnitCache;
import java.math.BigInteger;

public final class EnergyUnit
extends AbstractProductUnit<ForceUnit, LengthUnit, Energy, EnergyUnit>
implements IGosuObject {
    static final UnitCache<EnergyUnit> CACHE;
    public static EnergyUnit J;
    public static EnergyUnit kJ;
    public static EnergyUnit cal;
    public static EnergyUnit kcal;
    public static EnergyUnit eV;
    public static EnergyUnit BASE;

    static {
        GosuClassPathThing.init();
        CACHE = new UnitCache((LazyTypeResolver)new SimpleTypeLazyTypeResolver("gw.util.science.EnergyUnit", "_default_"));
        J = EnergyUnit.get(ForceUnit.BASE, LengthUnit.getBASE(), null, "Joule", "J");
        kJ = EnergyUnit.get(ForceUnit.BASE, LengthUnit.getBASE(), MetricScaleUnit.k.postfixBind(Rational.ONE), "Kilojoule", "kJ");
        cal = EnergyUnit.get(ForceUnit.BASE, LengthUnit.getBASE(), Rational.get((long)4184L, (long)1000L), "Calorie", "cal");
        kcal = EnergyUnit.get(ForceUnit.BASE, LengthUnit.getBASE(), Rational.get((long)4184L), "Kilocalorie", "kcal");
        eV = EnergyUnit.get(ForceUnit.BASE, LengthUnit.getBASE(), Rational.get((BigInteger)new BigInteger("160217733"), (BigInteger)new BigInteger("1000000000000000000000000000")), "Electronvolt", "eV");
        BASE = J;
    }

    EnergyUnit(ForceUnit forceUnit, LengthUnit lengthUnit, Rational factor, String name, String symbol) {
        super((LazyTypeResolver)new SimpleTypeLazyTypeResolver("gw.util.science.ForceUnit", "_default_"), (LazyTypeResolver)new SimpleTypeLazyTypeResolver("gw.util.science.LengthUnit", "_default_"), (LazyTypeResolver)new SimpleTypeLazyTypeResolver("gw.util.science.Energy", "_default_"), (LazyTypeResolver)new SimpleTypeLazyTypeResolver("gw.util.science.EnergyUnit", "_default_"), forceUnit, lengthUnit, factor, name, symbol);
    }

    public static EnergyUnit get(ForceUnit forceUnit, LengthUnit lengthUnit, Rational factor, String name, String symbol) {
        EnergyUnit unit = new EnergyUnit(forceUnit, lengthUnit, factor, name, symbol);
        return (EnergyUnit)CACHE.get(unit);
    }

    public ForceUnit getForceUnit() {
        return (ForceUnit)this.getLeftUnit();
    }

    public LengthUnit getLengthUnit() {
        return (LengthUnit)this.getRightUnit();
    }

    public ForceUnit divide(LengthUnit w) {
        return this.getForceUnit();
    }

    public PowerUnit divide(TimeUnit time) {
        return PowerUnit.get(this, time, null, null, null);
    }

    public TimeUnit divide(PowerUnit power) {
        return power.getTimeUnit();
    }

    public HeatCapacityUnit divide(TemperatureUnit temperature) {
        return HeatCapacityUnit.get(this, temperature, null, null, null);
    }

    public TemperatureUnit divide(HeatCapacityUnit c) {
        return c.getTemperatureUnit();
    }

    public MagneticFluxUnit divide(CurrentUnit i) {
        return MagneticFluxUnit.get(this, i, null, null, null);
    }

    public CurrentUnit divide(MagneticFluxUnit mf) {
        return mf.getCurrentUnit();
    }

    @Override
    public /* synthetic */ IType getIntrinsicType() {
        return GosuRuntimeMethods.getType((Object)this);
    }
}

