/*
 * Decompiled with CFR 0.152.
 */
package gw.util.science;

import gw.internal.gosu.runtime.GosuRuntimeMethods;
import gw.lang.reflect.IType;
import gw.lang.reflect.LazyTypeResolver;
import gw.lang.reflect.SimpleTypeLazyTypeResolver;
import gw.lang.reflect.gs.GosuClassPathThing;
import gw.lang.reflect.gs.IGosuObject;
import gw.util.Rational;
import gw.util.science.AbstractQuotientUnit;
import gw.util.science.AreaUnit;
import gw.util.science.LengthUnit;
import gw.util.science.MassUnit;
import gw.util.science.Pressure;
import gw.util.science.UnitCache;

public final class PressureUnit
extends AbstractQuotientUnit<MassUnit, AreaUnit, Pressure, PressureUnit>
implements IGosuObject {
    static final UnitCache<PressureUnit> CACHE;
    public static PressureUnit Pa;
    public static PressureUnit bar;
    public static PressureUnit at;
    public static PressureUnit atm;
    public static PressureUnit Torr;
    public static PressureUnit psi;
    public static PressureUnit BASE;

    static {
        GosuClassPathThing.init();
        CACHE = new UnitCache((LazyTypeResolver)new SimpleTypeLazyTypeResolver("gw.util.science.PressureUnit", "_default_"));
        Pa = PressureUnit.get(MassUnit.Kilogram, AreaUnit.BASE, Rational.ONE, "Pascal", "Pa");
        bar = PressureUnit.get(MassUnit.Kilogram, AreaUnit.BASE, Rational.get((long)1000000L, (long)10L), "Bar", "bar");
        at = PressureUnit.get(MassUnit.Kilogram, AreaUnit.BASE, Rational.get((long)980665L, (long)10L), "TechnicalAtm", "at");
        atm = PressureUnit.get(MassUnit.Kilogram, AreaUnit.BASE, Rational.get((long)1013250L, (long)10L), "StandardAtm", "atm");
        Torr = PressureUnit.get(MassUnit.Kilogram, AreaUnit.BASE, Rational.get((long)1333224L, (long)10000L), "Torr", "Torr");
        psi = PressureUnit.get(MassUnit.Pound, AreaUnit.get(LengthUnit.Inch, null, null, null, null), Rational.ONE, "Psi", "psi");
        BASE = Pa;
    }

    PressureUnit(MassUnit massUnit, AreaUnit areaUnit, Rational factor, String name, String symbol) {
        super((LazyTypeResolver)new SimpleTypeLazyTypeResolver("gw.util.science.MassUnit", "_default_"), (LazyTypeResolver)new SimpleTypeLazyTypeResolver("gw.util.science.AreaUnit", "_default_"), (LazyTypeResolver)new SimpleTypeLazyTypeResolver("gw.util.science.Pressure", "_default_"), (LazyTypeResolver)new SimpleTypeLazyTypeResolver("gw.util.science.PressureUnit", "_default_"), massUnit, areaUnit, factor, name, symbol);
    }

    public static PressureUnit get(MassUnit massUnit, AreaUnit areaUnit, Rational factor, String name, String symbol) {
        PressureUnit unit = new PressureUnit(massUnit, areaUnit, factor, name, symbol);
        return (PressureUnit)CACHE.get(unit);
    }

    public MassUnit getMassUnit() {
        return (MassUnit)this.getLeftUnit();
    }

    public AreaUnit getAreaUnit() {
        return (AreaUnit)this.getRightUnit();
    }

    @Override
    public /* synthetic */ IType getIntrinsicType() {
        return GosuRuntimeMethods.getType((Object)this);
    }
}

