/*
 * Decompiled with CFR 0.152.
 */
package gosu.tools.ant;

import gosu.tools.ant.GosuMatchingTask;
import gosu.tools.ant.util.AntLoggingHelper;
import gw.lang.gosuc.GosucUtil;
import gw.lang.gosuc.simple.GosuCompiler;
import gw.lang.gosuc.simple.ICompilerDriver;
import gw.lang.gosuc.simple.SoutCompilerDriver;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import manifold.util.JreUtil;
import manifold.util.NecessaryEvilUtil;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.GlobPatternMapper;
import org.apache.tools.ant.util.SourceFileScanner;

public class Gosuc
extends GosuMatchingTask {
    private final AntLoggingHelper log = new AntLoggingHelper((Task)this);
    private Path _src;
    private File _destDir;
    private Path _compileClasspath;
    private boolean _failOnError = true;
    private boolean _checkedArithmetic = false;
    private boolean _force = true;
    private String _projectName = "";
    private Set<String> _scriptExtensions = new HashSet<String>(Arrays.asList("gs", "gsx", "gst", "gsp"));
    protected List<File> compileList = new ArrayList<File>();

    public Path createSrc() {
        if (this._src == null) {
            this._src = new Path(this.getProject());
        }
        return this._src.createPath();
    }

    protected Path recreateSrc() {
        this._src = null;
        return this.createSrc();
    }

    public void setSrcdir(Path srcDir) {
        if (this._src == null) {
            this._src = srcDir;
        } else {
            this._src.append(srcDir);
        }
    }

    public Path getSrcdir() {
        return this._src;
    }

    public void setDestdir(File destDir) {
        this._destDir = destDir;
    }

    public File getDestdir() {
        return this._destDir;
    }

    public Path createClasspath() {
        if (this._compileClasspath == null) {
            this._compileClasspath = new Path(this.getProject());
        }
        return this._compileClasspath.createPath();
    }

    public void setClasspathRef(Reference ref) {
        this.createClasspath().setRefid(ref);
    }

    private Set<String> getScriptExtensions() {
        return this._scriptExtensions;
    }

    public void setAdditionalScriptExtensions(String extensions) {
        this._scriptExtensions.addAll(Arrays.asList(extensions.split(",\\s*")));
    }

    public void setFailOnError(boolean fail) {
        this._failOnError = fail;
    }

    public boolean getFailOnError() {
        return this._failOnError;
    }

    public boolean isCheckedArithmetic() {
        return this._checkedArithmetic;
    }

    public void setCheckedArithmetic(boolean checkedArithmetic) {
        this._checkedArithmetic = checkedArithmetic;
    }

    public boolean isForce() {
        return this._force;
    }

    public void setForce(boolean force) {
        this._force = force;
    }

    public String getProjectName() {
        return this._projectName;
    }

    public void setProjectName(String projectName) {
        this._projectName = projectName;
    }

    protected void scanDir(File srcDir, File destDir, String[] files) {
        GlobPatternMapper m = new GlobPatternMapper();
        SourceFileScanner sfs = new SourceFileScanner((Task)this);
        if (!this.isForce()) {
            this.log.warn("Relying on ant's SourceFileScanner, which only looks at timestamps.  If broken references result, try setting option 'force' to true.");
        }
        for (String extension : this.getScriptExtensions()) {
            m.setFrom("*." + extension);
            m.setTo("*.class");
            this.log.debug("Scanning for *." + extension + " files...");
            List<File> newFiles = this.isForce() ? this.asFiles(srcDir, files, (FileNameMapper)m) : Arrays.asList(sfs.restrictAsFiles(files, srcDir, destDir, (FileNameMapper)m));
            this.log.debug("Found these files:");
            for (File newFile : newFiles) {
                this.log.debug('\t' + newFile.getAbsolutePath());
            }
            this.compileList.addAll(newFiles);
        }
    }

    private List<File> asFiles(File srcDir, String[] files, FileNameMapper m) {
        ArrayList<File> newFiles = new ArrayList<File>();
        for (String file : files) {
            boolean hasMatchingExtension;
            boolean bl = hasMatchingExtension = m.mapFileName(file) != null;
            if (!hasMatchingExtension) continue;
            newFiles.add(new File(srcDir, file));
        }
        return newFiles;
    }

    public List<File> getFileList() {
        return this.compileList;
    }

    public void execute() throws BuildException {
        this.log.debug("projectname=" + this.getProjectName());
        this.log.debug("src/srcdir=" + this.getSrcdir());
        this.log.debug("destdir=" + this.getDestdir());
        this.log.debug("failOnError=" + this.getFailOnError());
        this.log.debug("checkedArithmetic=" + this.isCheckedArithmetic());
        this.log.debug("scriptExtensions=" + this.getScriptExtensions());
        this.log.debug("_compileClasspath=" + this._compileClasspath);
        NecessaryEvilUtil.bypassJava9Security();
        if (this.isCheckedArithmetic()) {
            System.setProperty("checkedArithmetic", "true");
        }
        SoutCompilerDriver driver = new SoutCompilerDriver();
        GosuCompiler gosuc = new GosuCompiler();
        ArrayList<String> classpath = new ArrayList<String>(Arrays.asList(this._compileClasspath.list()));
        classpath.add(GosucUtil.getClassLocation((String)"manifold.api.host.IManifoldHost"));
        classpath.add(GosucUtil.getClassLocation((String)"manifold.util.ReflectUtil"));
        if (JreUtil.isJava8()) {
            classpath.addAll(GosucUtil.getJreJars());
        }
        String startupMsg = "Initializing Gosu compiler";
        if (!this.getProjectName().isEmpty()) {
            startupMsg = startupMsg + " for " + this.getProjectName();
        }
        this.log.info(startupMsg);
        this.log.debug("\tsourceFolders:" + Arrays.asList(this.getSrcdir().list()));
        this.log.debug("\tclasspath:" + classpath);
        this.log.debug("\toutputPath:" + this.getDestdir().getAbsolutePath());
        List<String> sourceRoots = Arrays.asList(this.getSrcdir().list());
        for (String sourceRootName : sourceRoots) {
            File sourceRoot = this.getProject().resolveFile(sourceRootName);
            if (!sourceRoot.exists()) {
                throw new BuildException("srcdir \"" + sourceRoot.getPath() + "\" does not exist!", this.getLocation());
            }
            DirectoryScanner ds = this.getDirectoryScanner(sourceRoot);
            String[] files = ds.getIncludedFiles();
            if (this.hasSelectors()) {
                for (String relativeFilename : files) {
                    this.compileList.add(new File(sourceRoot, relativeFilename));
                }
                continue;
            }
            this.scanDir(sourceRoot, this._destDir != null ? this._destDir : sourceRoot, files);
        }
        gosuc.initializeGosu(sourceRoots, classpath, this.getDestdir().getAbsolutePath());
        this.log.debug("About to compile these files:");
        for (File file : this.compileList) {
            this.log.debug("\t" + file.getAbsolutePath());
        }
        for (File file : this.compileList) {
            try {
                gosuc.compile(file, (ICompilerDriver)driver);
            }
            catch (Exception e) {
                this.log.error(e.getMessage());
                throw new BuildException((Throwable)e);
            }
        }
        gosuc.uninitializeGosu();
        List warnings = driver.getWarnings();
        boolean errorsInCompilation = driver.hasErrors();
        List errors = driver.getErrors();
        ArrayList warningMessages = new ArrayList();
        ArrayList errorMessages = new ArrayList();
        warnings.forEach(warning -> warningMessages.add("[WARNING] " + warning));
        int numWarnings = warningMessages.size();
        int numErrors = 0;
        if (errorsInCompilation) {
            errors.forEach(error -> errorMessages.add("[ERROR] " + error));
            numErrors = errorMessages.size();
        }
        boolean hasWarningsOrErrors = numWarnings > 0 || errorsInCompilation;
        StringBuilder sb = new StringBuilder();
        sb.append(this.getProjectName().isEmpty() ? "Gosu compilation" : this.getProjectName());
        sb.append(" completed");
        if (hasWarningsOrErrors) {
            sb.append(" with ");
            if (numWarnings > 0) {
                sb.append(numWarnings).append(" warning").append(numWarnings == 1 ? "" : Character.valueOf('s'));
            }
            if (errorsInCompilation) {
                sb.append(numWarnings > 0 ? " and " : "");
                sb.append(numErrors).append(" error").append(numErrors == 1 ? "" : Character.valueOf('s'));
            }
        } else {
            sb.append(" successfully.");
        }
        if (hasWarningsOrErrors) {
            this.log.warn(sb.toString());
        } else {
            this.log.info(sb.toString());
        }
        warningMessages.subList(0, Math.min(warningMessages.size(), 100)).forEach(this.log::info);
        errorMessages.subList(0, Math.min(errorMessages.size(), 100)).forEach(this.log::error);
        if (errorsInCompilation) {
            if (this.getFailOnError()) {
                this.buildError("Gosu compilation failed with errors; see compiler output for details.");
            } else {
                this.log.warn("Gosu Compiler: Ignoring compilation failure(s) as 'failOnError' was set to false");
            }
        }
    }
}

