/*
 * Decompiled with CFR 0.152.
 */
package org.gomoob.model.translation;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gomoob.model.AbstractEntity;
import org.gomoob.model.ITranslatableEntity;
import org.gomoob.model.ITranslation;
import org.gomoob.model.translation.Translation;

public abstract class AbstractTranslatableEntity<IDT extends Serializable>
extends AbstractEntity<IDT>
implements ITranslatableEntity<IDT> {
    private String defaultLanguageCode;
    private String translationLanguageCode;
    private Map<String, ITranslation> translations;

    @Override
    public void applyTranslation(String languageCode) {
        String previousTranslationLanguageCode = this.getDefaultLanguageCode();
        if (this.getTranslationLanguageCode() != null) {
            previousTranslationLanguageCode = this.getTranslationLanguageCode();
        }
        if (previousTranslationLanguageCode != languageCode) {
            if (this.translations == null) {
                throw new IllegalStateException("No translations associated to the entity !");
            }
            if (!this.translations.containsKey(languageCode)) {
                throw new IllegalStateException("No translation with the language code '" + languageCode + "' is registered !");
            }
            ITranslation translationToApply = this.translations.get(languageCode);
            Translation previousTranslation = new Translation();
            previousTranslation.setLanguageCode(previousTranslationLanguageCode);
            for (Map.Entry<String, String> entry : translationToApply.getAttributeTranslations().entrySet()) {
                String attributeName = entry.getKey();
                Field field = null;
                try {
                    field = this.getClass().getDeclaredField(attributeName);
                }
                catch (NoSuchFieldException | SecurityException e) {
                    throw new RuntimeException("Fail to get value of property '" + attributeName + "' !", e);
                }
                if (!field.getType().equals(String.class)) {
                    throw new IllegalStateException("Translation attribute values must be of type 'String' !");
                }
                previousTranslation.setAttributeTranslation(attributeName, (String)this.get(attributeName));
                String attributeValue = entry.getValue();
                this.set(attributeName, attributeValue);
            }
            this.setTranslationLanguageCode(null);
            this.deleteTranslation(languageCode);
            this.setTranslation(previousTranslation);
            if (languageCode != this.getDefaultLanguageCode()) {
                this.setTranslationLanguageCode(languageCode);
            }
        }
    }

    @Override
    public void deleteTranslation(String languageCode) {
        if (this.translations != null) {
            if (!this.translations.containsKey(languageCode)) {
                throw new IllegalStateException("No translation with the language code '" + languageCode + "' is registered !");
            }
            this.translations.remove(languageCode);
        }
    }

    @Override
    public void deleteTranslations(List<String> languageCodes) {
        if (languageCodes == null) {
            this.translations = null;
        } else {
            for (String languageCode : languageCodes) {
                if (this.translations.containsKey(languageCode)) continue;
                throw new IllegalStateException("No translation with the language code '" + languageCode + "' is registered !");
            }
            for (String languageCode : languageCodes) {
                this.translations.remove(languageCode);
            }
        }
    }

    @Override
    public String getDefaultLanguageCode() {
        return this.defaultLanguageCode;
    }

    @Override
    public ITranslation getTranslation(String languageCode) {
        if (this.translations == null || !this.translations.containsKey(languageCode)) {
            throw new IllegalStateException("No translation with the language code '" + languageCode + "' is registered !");
        }
        return this.translations.get(languageCode);
    }

    @Override
    public String getTranslationLanguageCode() {
        return this.translationLanguageCode;
    }

    @Override
    public Map<String, ITranslation> getTranslations() {
        return this.translations;
    }

    @Override
    public Boolean isTranslated() {
        return this.translationLanguageCode != null || this.translations != null && !this.translations.isEmpty();
    }

    @Override
    public void setDefaultLanguageCode(String defaultLanguageCode) {
        this.defaultLanguageCode = defaultLanguageCode;
    }

    @Override
    public void setTranslationLanguageCode(String translationLanguageCode) {
        this.translationLanguageCode = translationLanguageCode;
    }

    @Override
    public void setTranslation(ITranslation translation) {
        if (this.translationLanguageCode != null) {
            throw new IllegalStateException("Cannot add a translation for an entity which is already using the 'one language mode' !");
        }
        if (this.translations == null) {
            this.translations = new HashMap<String, ITranslation>();
        }
        this.translations.put(translation.getLanguageCode(), translation);
    }

    @Override
    public void setTranslations(Map<String, ITranslation> translations) {
        this.translations = translations;
    }
}

