/*
 * Decompiled with CFR 0.152.
 */
package org.gomoob.model;

import java.io.Serializable;
import java.lang.reflect.Field;
import org.gomoob.model.IEntity;

public abstract class AbstractEntity<IDT extends Serializable>
implements IEntity<IDT> {
    protected IDT id = null;

    @Override
    public Object get(String attributeName) {
        String errorMessage = "Fail to get value of property '" + attributeName + "' !";
        Field field = null;
        try {
            field = this.getClass().getDeclaredField(attributeName);
        }
        catch (NoSuchFieldException nsfex) {
            throw new RuntimeException(errorMessage, nsfex);
        }
        boolean accessible = field.isAccessible();
        field.setAccessible(true);
        Object attributeValue = null;
        try {
            attributeValue = field.get(this);
        }
        catch (IllegalArgumentException iaex) {
            throw new RuntimeException(errorMessage, iaex);
        }
        catch (IllegalAccessException iaccex) {
            throw new RuntimeException(errorMessage, iaccex);
        }
        field.setAccessible(accessible);
        return attributeValue;
    }

    @Override
    public IDT getId() {
        return this.id;
    }

    @Override
    public void set(String attributeName, Object attributeValue) {
        String errorMessage = "Fail to set value of property '" + attributeName + "' !";
        Field field = null;
        try {
            field = this.getClass().getDeclaredField(attributeName);
        }
        catch (NoSuchFieldException nsfex) {
            throw new RuntimeException(errorMessage, nsfex);
        }
        boolean accessible = field.isAccessible();
        field.setAccessible(true);
        try {
            field.set(this, attributeValue);
        }
        catch (IllegalArgumentException iaex) {
            throw new RuntimeException(errorMessage, iaex);
        }
        catch (IllegalAccessException iaccex) {
            throw new RuntimeException(errorMessage, iaccex);
        }
        field.setAccessible(accessible);
    }

    @Override
    public void setId(IDT id) {
        this.id = id;
    }
}

