/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.map.georss;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.vfny.geoserver.global.WMS;
import org.vfny.geoserver.wms.GetMapProducer;
import org.vfny.geoserver.wms.GetMapProducerFactorySpi;
import org.vfny.geoserver.wms.responses.map.georss.AtomGeoRSSMapProducer;
import org.vfny.geoserver.wms.responses.map.georss.RSSGeoRSSMapProducer;

public class GeoRSSMapProducerFactory
implements GetMapProducerFactorySpi {
    static Set formats = new HashSet();
    static Set aliases = new HashSet();

    public boolean canProduce(String mapFormat) {
        return formats.contains(mapFormat) || aliases.contains(mapFormat);
    }

    public GetMapProducer createMapProducer(String mapFormat, WMS wms) throws IllegalArgumentException {
        if (AtomGeoRSSMapProducer.MIME_TYPE.equals(mapFormat) || AtomGeoRSSMapProducer.FORMATS.contains(mapFormat)) {
            return new AtomGeoRSSMapProducer();
        }
        if (RSSGeoRSSMapProducer.MIME_TYPE.equals(mapFormat) || RSSGeoRSSMapProducer.FORMATS.contains(mapFormat)) {
            return new RSSGeoRSSMapProducer();
        }
        return null;
    }

    public String getName() {
        return "GeoRSS";
    }

    public Set getSupportedFormats() {
        return formats;
    }

    public boolean isAvailable() {
        return true;
    }

    public Map getImplementationHints() {
        return null;
    }

    static {
        formats.add(AtomGeoRSSMapProducer.MIME_TYPE);
        formats.add(RSSGeoRSSMapProducer.MIME_TYPE);
        aliases.addAll(AtomGeoRSSMapProducer.FORMATS);
        aliases.addAll(RSSGeoRSSMapProducer.FORMATS);
    }
}

