/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.helpers;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageOutputStream;
import org.geotools.util.logging.Logging;

public final class JAISupport {
    private static final Logger LOGGER = Logging.getLogger((String)(class$org$vfny$geoserver$wms$responses$helpers$JAISupport == null ? (class$org$vfny$geoserver$wms$responses$helpers$JAISupport = JAISupport.class$("org.vfny.geoserver.wms.responses.helpers.JAISupport")) : class$org$vfny$geoserver$wms$responses$helpers$JAISupport).getPackage().getName());
    static ArrayList testedFormats = new ArrayList();
    private static Set supportedFormats;
    static /* synthetic */ Class class$org$vfny$geoserver$wms$responses$helpers$JAISupport;

    public static Set getSupportedFormats() {
        if (supportedFormats == null) {
            String[] mimeTypes = null;
            try {
                mimeTypes = ImageIO.getWriterMIMETypes();
            }
            catch (NoClassDefFoundError ncdfe) {
                supportedFormats = Collections.EMPTY_SET;
                LOGGER.warning("could not find jai: " + ncdfe);
            }
            if (mimeTypes == null) {
                LOGGER.info("Jai not found? Should be always there");
                supportedFormats = Collections.EMPTY_SET;
            } else {
                supportedFormats = new HashSet();
                List<String> formatsList = Arrays.asList(mimeTypes);
                Iterator<String> it = formatsList.iterator();
                while (it.hasNext()) {
                    String curFormat = it.next().toString();
                    if (curFormat.equals("") || !testedFormats.contains(curFormat)) continue;
                    supportedFormats.add(curFormat);
                }
                if (LOGGER.isLoggable(Level.CONFIG)) {
                    StringBuffer sb = new StringBuffer("Supported JAIMapResponse's MIME Types: [");
                    Iterator it2 = supportedFormats.iterator();
                    while (it2.hasNext()) {
                        sb.append(it2.next());
                        if (!it2.hasNext()) continue;
                        sb.append(", ");
                    }
                    sb.append("]");
                    LOGGER.config(sb.toString());
                }
            }
        }
        return supportedFormats;
    }

    public static boolean isJaiAvailable() {
        return JAISupport.getSupportedFormats().size() > 0;
    }

    public static void encode(String format, BufferedImage image, OutputStream outStream) throws IOException {
        Iterator<ImageWriter> it;
        if (format.equalsIgnoreCase("jpeg")) {
            format = "image/jpeg";
        }
        if (!(it = ImageIO.getImageWritersByMIMEType(format)).hasNext()) {
            throw new IllegalArgumentException("Format not supported: " + format);
        }
        ImageWriter writer = it.next();
        ImageOutputStream ioutstream = null;
        IIOMetadata meta = writer.getDefaultStreamMetadata(writer.getDefaultWriteParam());
        ImageWriteParam param = writer.getDefaultWriteParam();
        if (format.equalsIgnoreCase("image/jpeg")) {
            param.setCompressionMode(2);
            param.setCompressionQuality(0.9f);
            meta = writer.getDefaultStreamMetadata(param);
            BufferedImage curImage = new BufferedImage(image.getWidth(), image.getHeight(), 5);
            Graphics2D g = curImage.createGraphics();
            g.drawImage((Image)image, 0, 0, null);
            image = curImage;
            ioutstream = ImageIO.createImageOutputStream(outStream);
            writer.setOutput(ioutstream);
            writer.write(image);
            ioutstream.close();
            writer.dispose();
            return;
        }
        ioutstream = ImageIO.createImageOutputStream(outStream);
        writer.setOutput(ioutstream);
        writer.write(meta, new IIOImage(image, null, meta), param);
        ioutstream.close();
        writer.dispose();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        testedFormats.add("image/jpeg");
    }
}

