/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.featureInfo;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.data.DataUtilities;
import org.geotools.data.DefaultQuery;
import org.geotools.data.Query;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.feature.AttributeType;
import org.geotools.feature.AttributeTypeFactory;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureType;
import org.geotools.feature.FeatureTypes;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.SchemaException;
import org.geotools.filter.IllegalFilterException;
import org.geotools.geometry.DirectPosition2D;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.CRS;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.PointOutsideCoverageException;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.spatial.Intersects;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.vfny.geoserver.ServiceException;
import org.vfny.geoserver.global.CoverageInfo;
import org.vfny.geoserver.global.Data;
import org.vfny.geoserver.global.FeatureTypeInfo;
import org.vfny.geoserver.global.GeoServer;
import org.vfny.geoserver.global.MapLayerInfo;
import org.vfny.geoserver.wms.WmsException;
import org.vfny.geoserver.wms.requests.GetFeatureInfoRequest;
import org.vfny.geoserver.wms.requests.GetMapRequest;
import org.vfny.geoserver.wms.responses.featureInfo.GetFeatureInfoDelegate;

public abstract class AbstractFeatureInfoResponse
extends GetFeatureInfoDelegate {
    protected static final Logger LOGGER = Logging.getLogger((String)"org.vfny.geoserver.responses.wms.featureinfo");
    protected List supportedFormats = null;
    protected List results;
    protected List metas;
    protected String format = null;
    static /* synthetic */ Class class$java$lang$Double;

    public String getContentEncoding() {
        return null;
    }

    public abstract void writeTo(OutputStream var1) throws ServiceException, IOException;

    public List getSupportedFormats() {
        return this.supportedFormats;
    }

    public void abort(GeoServer gs) {
    }

    public String getContentType(GeoServer gs) {
        if (this.format == null) {
            throw new IllegalStateException("Content type unknown since execute() has not been called yet");
        }
        return this.format + ";charset=" + gs.getCharSet().name();
    }

    protected void execute(MapLayerInfo[] requestedLayers, Filter[] filters, int x, int y) throws WmsException {
        Coordinate[] coords;
        GetFeatureInfoRequest request = this.getRequest();
        this.format = request.getInfoFormat();
        GetMapRequest getMapReq = request.getGetMapRequest();
        CoordinateReferenceSystem requestedCRS = getMapReq.getCrs();
        int width = getMapReq.getWidth();
        int height = getMapReq.getHeight();
        Envelope bbox = getMapReq.getBbox();
        Coordinate upperLeft = this.pixelToWorld(x - 2, y - 2, bbox, width, height);
        Coordinate middle = this.pixelToWorld(x, y, bbox, width, height);
        Coordinate lowerRight = this.pixelToWorld(x + 2, y + 2, bbox, width, height);
        coords = new Coordinate[]{upperLeft, new Coordinate(lowerRight.x, upperLeft.y), lowerRight, new Coordinate(upperLeft.x, lowerRight.y), coords[0]};
        GeometryFactory geomFac = new GeometryFactory();
        LinearRing boundary = geomFac.createLinearRing(coords);
        FilterFactory2 filterFac = CommonFactoryFinder.getFilterFactory2((Hints)GeoTools.getDefaultHints());
        int layerCount = requestedLayers.length;
        this.results = new ArrayList(layerCount);
        this.metas = new ArrayList(layerCount);
        try {
            for (int i = 0; i < layerCount; ++i) {
                if (requestedLayers[i].getType() == Data.TYPE_VECTOR.intValue()) {
                    FeatureTypeInfo finfo = requestedLayers[i].getFeature();
                    CoordinateReferenceSystem dataCRS = finfo.getFeatureType().getDefaultGeometry().getCoordinateSystem();
                    Polygon pixelRect = geomFac.createPolygon(boundary, null);
                    if (requestedCRS != null && !CRS.equalsIgnoreMetadata((Object)dataCRS, (Object)requestedCRS)) {
                        try {
                            MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)requestedCRS, (CoordinateReferenceSystem)dataCRS, (boolean)true);
                            pixelRect = (Polygon)JTS.transform((Geometry)pixelRect, (MathTransform)transform);
                        }
                        catch (MismatchedDimensionException e) {
                            LOGGER.severe(e.getLocalizedMessage());
                        }
                        catch (TransformException e) {
                            LOGGER.severe(e.getLocalizedMessage());
                        }
                        catch (FactoryException e) {
                            LOGGER.severe(e.getLocalizedMessage());
                        }
                    }
                    Intersects getFInfoFilter = null;
                    try {
                        getFInfoFilter = filterFac.intersects((Expression)filterFac.property(finfo.getFeatureType().getDefaultGeometry().getLocalName()), (Expression)filterFac.literal((Object)pixelRect));
                    }
                    catch (IllegalFilterException e) {
                        e.printStackTrace();
                        throw new WmsException(null, "Internal error : " + e.getMessage());
                    }
                    if (filters[i] != null) {
                        getFInfoFilter = filterFac.and((Filter)getFInfoFilter, filters[i]);
                    }
                    DefaultQuery q = new DefaultQuery(finfo.getTypeName(), null, (Filter)getFInfoFilter, request.getFeatureCount(), Query.ALL_NAMES, null);
                    FeatureCollection match = finfo.getFeatureSource().getFeatures((Query)q);
                    this.results.add(match);
                    this.metas.add(requestedLayers[i]);
                    continue;
                }
                CoverageInfo cinfo = requestedLayers[i].getCoverage();
                GridCoverage2D coverage = ((GridCoverage2D)cinfo.getCoverage()).geophysics(true);
                DirectPosition2D position = new DirectPosition2D(requestedCRS, middle.x, middle.y);
                try {
                    double[] pixelValues = coverage.evaluate((DirectPosition)position, (double[])null);
                    FeatureCollection pixel = this.wrapPixelInFeatureCollection(coverage, pixelValues, cinfo.getName());
                    this.metas.add(requestedLayers[i]);
                    this.results.add(pixel);
                    continue;
                }
                catch (PointOutsideCoverageException e) {
                    // empty catch block
                }
            }
        }
        catch (Exception e) {
            throw new WmsException(null, "Internal error occurred", e);
        }
    }

    private FeatureCollection wrapPixelInFeatureCollection(GridCoverage2D coverage, double[] pixelValues, String coverageName) throws SchemaException, IllegalAttributeException {
        int i;
        FeatureType gridType;
        GridSampleDimension[] sampleDimensions = coverage.getSampleDimensions();
        AttributeType[] types = new AttributeType[sampleDimensions.length];
        try {
            for (int i2 = 0; i2 < types.length; ++i2) {
                types[i2] = AttributeTypeFactory.newAttributeType((String)sampleDimensions[i2].getDescription().toString(), (Class)(class$java$lang$Double == null ? AbstractFeatureInfoResponse.class$("java.lang.Double") : class$java$lang$Double));
            }
            gridType = FeatureTypes.newFeatureType((AttributeType[])types, (String)coverageName);
        }
        catch (Exception e) {
            for (i = 0; i < types.length; ++i) {
                types[i] = AttributeTypeFactory.newAttributeType((String)("Band " + (i + 1)), (Class)(class$java$lang$Double == null ? AbstractFeatureInfoResponse.class$("java.lang.Double") : class$java$lang$Double));
            }
            gridType = FeatureTypes.newFeatureType((AttributeType[])types, (String)coverageName);
        }
        Object[] values = new Double[pixelValues.length];
        for (i = 0; i < values.length; ++i) {
            values[i] = new Double(pixelValues[i]);
        }
        return DataUtilities.collection((Feature)gridType.create(values, ""));
    }

    private Coordinate pixelToWorld(int x, int y, Envelope map, int width, int height) {
        AffineTransform at = this.worldToScreenTransform(map, width, height);
        Point2D result = null;
        try {
            result = at.inverseTransform(new Point2D.Double(x, y), new Point2D.Double());
        }
        catch (NoninvertibleTransformException e) {
            throw new RuntimeException(e);
        }
        Coordinate c = new Coordinate(result.getX(), result.getY());
        return c;
    }

    private AffineTransform worldToScreenTransform(Envelope mapExtent, int width, int height) {
        double scaleX = (double)width / mapExtent.getWidth();
        double scaleY = (double)height / mapExtent.getHeight();
        double tx = -mapExtent.getMinX() * scaleX;
        double ty = mapExtent.getMinY() * scaleY + (double)height;
        AffineTransform at = new AffineTransform(scaleX, 0.0, 0.0, -scaleY, tx, ty);
        return at;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

