/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.map.metatile;

import com.vividsolutions.jts.geom.Envelope;
import java.awt.Point;
import java.awt.geom.Point2D;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.vfny.geoserver.wms.responses.map.metatile.QuickTileCache;

public class QuickTileCacheTest
extends TestCase {
    QuickTileCache cache = new QuickTileCache();

    public void testMetaCoordinates() {
        Point orig = new Point(0, 0);
        Assert.assertEquals((Object)orig, (Object)this.cache.getMetaTileCoordinates(orig));
        Point t10 = new Point(1, 0);
        Assert.assertEquals((Object)orig, (Object)this.cache.getMetaTileCoordinates(t10));
        Point t01 = new Point(1, 0);
        Assert.assertEquals((Object)orig, (Object)this.cache.getMetaTileCoordinates(t01));
        Point t33 = new Point(3, 3);
        Assert.assertEquals((Object)new Point(3, 3), (Object)this.cache.getMetaTileCoordinates(t33));
        Point tm1m1 = new Point(-1, -1);
        Assert.assertEquals((Object)new Point(-3, -3), (Object)this.cache.getMetaTileCoordinates(tm1m1));
        Point tm3m3 = new Point(-3, -3);
        Assert.assertEquals((Object)new Point(-3, -3), (Object)this.cache.getMetaTileCoordinates(tm3m3));
        Point tm4m4 = new Point(-4, -4);
        Assert.assertEquals((Object)new Point(-6, -6), (Object)this.cache.getMetaTileCoordinates(tm4m4));
        Point t4m4 = new Point(4, -4);
        Assert.assertEquals((Object)new Point(3, -6), (Object)this.cache.getMetaTileCoordinates(t4m4));
        Point tm44 = new Point(-4, 4);
        Assert.assertEquals((Object)new Point(-6, 3), (Object)this.cache.getMetaTileCoordinates(tm44));
    }

    public void testTileCoordinatesNaturalOrigin() {
        Point2D.Double origin = new Point2D.Double(0.0, 0.0);
        Envelope env = new Envelope(30.0, 60.0, 30.0, 60.0);
        Point tc = this.cache.getTileCoordinates(env, (Point2D)origin);
        Assert.assertEquals((Object)new Point(1, 1), (Object)tc);
        env = new Envelope(-30.0, 0.0, -30.0, 0.0);
        tc = this.cache.getTileCoordinates(env, (Point2D)origin);
        Assert.assertEquals((Object)new Point(-1, -1), (Object)tc);
    }
}

