/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.map.kml;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.zip.ZipFile;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.geoserver.data.test.MockData;
import org.geoserver.wms.WMSTestSupport;
import org.vfny.geoserver.wms.WMSMapContext;
import org.vfny.geoserver.wms.requests.GetMapRequest;
import org.vfny.geoserver.wms.responses.map.kml.KMZMapProducer;
import org.vfny.geoserver.wms.responses.map.kml.KMZMapProducerFactory;

public class KMZMapProducerTest
extends WMSTestSupport {
    KMZMapProducer mapProducer;

    protected void setUp() throws Exception {
        super.setUp();
        WMSMapContext mapContext = new WMSMapContext();
        mapContext.addLayer(this.createMapLayer(MockData.BASIC_POLYGONS));
        mapContext.addLayer(this.createMapLayer(MockData.BUILDINGS));
        mapContext.setMapHeight(256);
        mapContext.setMapWidth(256);
        GetMapRequest getMapRequest = this.createGetMapRequest(new QName[]{MockData.BASIC_POLYGONS, MockData.BUILDINGS});
        mapContext.setRequest(getMapRequest);
        this.mapProducer = (KMZMapProducer)new KMZMapProducerFactory().createMapProducer("application/vnd.google-earth.kmz", this.getWMS());
        this.mapProducer.setMapContext(mapContext);
        this.mapProducer.produceMap();
    }

    public void test() throws Exception {
        File temp = File.createTempFile("test", "kmz");
        temp.delete();
        temp.mkdir();
        temp.deleteOnExit();
        File zip = new File(temp, "kmz.zip");
        zip.deleteOnExit();
        FileOutputStream output = new FileOutputStream(zip);
        this.mapProducer.writeTo((OutputStream)output);
        output.flush();
        output.close();
        Assert.assertTrue((boolean)zip.exists());
        ZipFile zipFile = new ZipFile(zip);
        Assert.assertNotNull((Object)zipFile.getEntry("wms.kml"));
        Assert.assertNotNull((Object)zipFile.getEntry("layer_0.png"));
        Assert.assertNotNull((Object)zipFile.getEntry("layer_1.png"));
        zipFile.close();
    }
}

