/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.map.kml;

import com.vividsolutions.jts.geom.Envelope;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import junit.framework.Assert;
import org.geoserver.data.test.MockData;
import org.geoserver.wms.WMSTestSupport;
import org.geotools.data.FeatureSource;
import org.geotools.map.MapLayer;
import org.vfny.geoserver.wms.WMSMapContext;
import org.vfny.geoserver.wms.responses.map.kml.KMLRasterTransformer;
import org.vfny.geoserver.wms.responses.map.kml.KMLSuperOverlayTransformer;
import org.vfny.geoserver.wms.responses.map.kml.KMLTransformer;
import org.vfny.geoserver.wms.responses.map.kml.KMLVectorTransformer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class KMLTransformerTest
extends WMSTestSupport {
    WMSMapContext mapContext;
    MapLayer mapLayer;

    protected void setUp() throws Exception {
        super.setUp();
        this.mapLayer = this.createMapLayer(MockData.BASIC_POLYGONS);
        this.mapContext = new WMSMapContext(this.createGetMapRequest(MockData.BASIC_POLYGONS));
        this.mapContext.addLayer(this.mapLayer);
    }

    public void testVectorTransformer() throws Exception {
        KMLVectorTransformer transformer = new KMLVectorTransformer(this.mapContext, this.mapLayer);
        transformer.setIndentation(2);
        FeatureSource featureSource = this.mapLayer.getFeatureSource();
        int nfeatures = featureSource.getFeatures().size();
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        transformer.transform((Object)featureSource.getFeatures(), (OutputStream)output);
        DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document document = docBuilder.parse(new ByteArrayInputStream(output.toByteArray()));
        Element element = document.getDocumentElement();
        Assert.assertEquals((String)"kml", (String)element.getNodeName());
        Assert.assertEquals((int)nfeatures, (int)element.getElementsByTagName("Style").getLength());
        Assert.assertEquals((int)nfeatures, (int)element.getElementsByTagName("Placemark").getLength());
    }

    public void testRasterTransformerInline() throws Exception {
        KMLRasterTransformer transformer = new KMLRasterTransformer(this.mapContext);
        transformer.setInline(true);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        transformer.transform((Object)this.mapLayer, (OutputStream)output);
        DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document document = docBuilder.parse(new ByteArrayInputStream(output.toByteArray()));
        Assert.assertEquals((String)"kml", (String)document.getDocumentElement().getNodeName());
        Assert.assertEquals((int)this.mapContext.getLayerCount(), (int)document.getElementsByTagName("Folder").getLength());
        Assert.assertEquals((int)this.mapContext.getLayerCount(), (int)document.getElementsByTagName("GroundOverlay").getLength());
        Assert.assertEquals((int)this.mapContext.getLayerCount(), (int)document.getElementsByTagName("href").getLength());
        Element href = (Element)document.getElementsByTagName("href").item(0);
        Assert.assertEquals((String)"layer_0.png", (String)href.getFirstChild().getNodeValue());
    }

    public void testRasterTransformerNotInline() throws Exception {
        KMLRasterTransformer transformer = new KMLRasterTransformer(this.mapContext);
        transformer.setInline(false);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        transformer.transform((Object)this.mapLayer, (OutputStream)output);
        DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document document = docBuilder.parse(new ByteArrayInputStream(output.toByteArray()));
        Assert.assertEquals((String)"kml", (String)document.getDocumentElement().getNodeName());
        Assert.assertEquals((int)this.mapContext.getLayerCount(), (int)document.getElementsByTagName("Folder").getLength());
        Assert.assertEquals((int)this.mapContext.getLayerCount(), (int)document.getElementsByTagName("GroundOverlay").getLength());
        Assert.assertEquals((int)this.mapContext.getLayerCount(), (int)document.getElementsByTagName("href").getLength());
        Element href = (Element)document.getElementsByTagName("href").item(0);
        Assert.assertTrue((boolean)href.getFirstChild().getNodeValue().startsWith("http://localhost"));
    }

    public void testSuperOverlayTransformer() throws Exception {
        KMLSuperOverlayTransformer transformer = new KMLSuperOverlayTransformer(this.mapContext);
        transformer.setIndentation(2);
        this.mapContext.setAreaOfInterest(new Envelope(-180.0, 180.0, -90.0, 90.0));
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        transformer.transform((Object)this.mapLayer, (OutputStream)output);
        DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document document = docBuilder.parse(new ByteArrayInputStream(output.toByteArray()));
        Assert.assertEquals((String)"kml", (String)document.getDocumentElement().getNodeName());
        Assert.assertEquals((int)3, (int)document.getElementsByTagName("Region").getLength());
        Assert.assertEquals((int)2, (int)document.getElementsByTagName("NetworkLink").getLength());
        Assert.assertEquals((int)2, (int)document.getElementsByTagName("GroundOverlay").getLength());
    }

    public void testTransformer() throws Exception {
        KMLTransformer transformer = new KMLTransformer();
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        transformer.transform((Object)this.mapContext, (OutputStream)output);
        DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document document = docBuilder.parse(new ByteArrayInputStream(output.toByteArray()));
        Assert.assertEquals((String)"kml", (String)document.getDocumentElement().getNodeName());
    }
}

