/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.map.kml;

import junit.framework.Assert;
import org.geoserver.data.test.MockData;
import org.geoserver.wms.RemoteOWSTestSupport;
import org.geoserver.wms.WMSTestSupport;
import org.w3c.dom.Document;

public class KMLTest
extends WMSTestSupport {
    public void testVector() throws Exception {
        Document doc = this.getAsDOM("wms?request=getmap&service=wms&version=1.1.1&format=application/vnd.google-earth.kml+xml&layers=" + MockData.BASIC_POLYGONS.getPrefix() + ":" + MockData.BASIC_POLYGONS.getLocalPart() + "&styles=" + MockData.BASIC_POLYGONS.getLocalPart() + "&height=1024&width=1024&bbox=-180,-90,180,90&srs=EPSG:4326");
        Assert.assertEquals((int)this.getFeatureSource(MockData.BASIC_POLYGONS).getFeatures().size(), (int)doc.getElementsByTagName("Placemark").getLength());
    }

    public void testVectorWithFeatureId() throws Exception {
        Document doc = this.getAsDOM("wms?request=getmap&service=wms&version=1.1.1&format=application/vnd.google-earth.kml+xml&layers=" + MockData.BASIC_POLYGONS.getPrefix() + ":" + MockData.BASIC_POLYGONS.getLocalPart() + "&styles=" + MockData.BASIC_POLYGONS.getLocalPart() + "&height=1024&width=1024&bbox=-180,-90,180,90&srs=EPSG:4326" + "&featureid=BasicPolygons.1107531493643");
        Assert.assertEquals((int)1, (int)doc.getElementsByTagName("Placemark").getLength());
    }

    public void testVectorWithRemoteLayer() throws Exception {
        if (!RemoteOWSTestSupport.isRemoteStatesAvailable()) {
            return;
        }
        Document doc = this.getAsDOM("wms?request=getmap&service=wms&version=1.1.1&format=application/vnd.google-earth.kml+xml&layers=topp:states&styles=Default&height=1024&width=1024&bbox=-180,-90,180,90&srs=EPSG:4326&remote_ows_type=wfs&remote_ows_url=http://sigma.openplans.org:8080/geoserver/wfs?&featureid=states.1");
        Assert.assertEquals((int)1, (int)doc.getElementsByTagName("Placemark").getLength());
    }
}

