/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.map.georss;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import junit.framework.Assert;
import org.geoserver.data.test.MockData;
import org.geoserver.wms.WMSTestSupport;
import org.geotools.data.DefaultQuery;
import org.geotools.data.Query;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.map.MapLayer;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.expression.Expression;
import org.vfny.geoserver.wms.WMSMapContext;
import org.vfny.geoserver.wms.responses.map.georss.GeoRSSTransformerBase;
import org.vfny.geoserver.wms.responses.map.georss.RSSGeoRSSTransformer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class RSSGeoRSSTransformerTest
extends WMSTestSupport {
    FilterFactory ff = CommonFactoryFinder.getFilterFactory((Hints)GeoTools.getDefaultHints());

    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testLatLong() throws Exception {
        WMSMapContext map = new WMSMapContext(this.createGetMapRequest(MockData.BASIC_POLYGONS));
        map.addLayer(this.createMapLayer(MockData.BASIC_POLYGONS));
        Document document = this.getRSSResponse(map, GeoRSSTransformerBase.GeometryEncoding.LATLONG);
        Element element = document.getDocumentElement();
        Assert.assertEquals((String)"rss", (String)element.getNodeName());
        NodeList items = element.getElementsByTagName("item");
        int n = this.getFeatureSource(MockData.BASIC_POLYGONS).getCount(Query.ALL);
        Assert.assertEquals((int)n, (int)items.getLength());
        for (int i = 0; i < items.getLength(); ++i) {
            Element item = (Element)items.item(i);
            Assert.assertEquals((int)1, (int)item.getElementsByTagName("geo:lat").getLength());
            Assert.assertEquals((int)1, (int)item.getElementsByTagName("geo:long").getLength());
        }
    }

    public void testFilter() throws Exception {
        WMSMapContext map = new WMSMapContext(this.createGetMapRequest(MockData.BUILDINGS));
        MapLayer layer = this.createMapLayer(MockData.BUILDINGS);
        PropertyIsEqualTo f = this.ff.equals((Expression)this.ff.property("ADDRESS"), (Expression)this.ff.literal((Object)"215 Main Street"));
        layer.setQuery((Query)new DefaultQuery(MockData.BUILDINGS.getLocalPart(), (Filter)f));
        map.addLayer(layer);
        Document document = this.getRSSResponse(map, GeoRSSTransformerBase.GeometryEncoding.LATLONG);
        NodeList items = document.getDocumentElement().getElementsByTagName("item");
        Assert.assertEquals((int)1, (int)items.getLength());
    }

    public void testReproject() throws Exception {
        WMSMapContext map = new WMSMapContext(this.createGetMapRequest(MockData.LINES));
        map.addLayer(this.createMapLayer(MockData.LINES));
        Document document = this.getRSSResponse(map, GeoRSSTransformerBase.GeometryEncoding.LATLONG);
        NodeList items = document.getDocumentElement().getElementsByTagName("item");
        Assert.assertEquals((int)1, (int)items.getLength());
        for (int i = 0; i < items.getLength(); ++i) {
            Element item = (Element)items.item(i);
            double lat = Double.parseDouble(this.getOrdinate(item, "geo:lat"));
            double lon = Double.parseDouble(this.getOrdinate(item, "geo:long"));
            Assert.assertTrue((lat >= -90.0 && lat <= 90.0 ? 1 : 0) != 0);
            Assert.assertTrue((lon >= -180.0 && lon <= 180.0 ? 1 : 0) != 0);
        }
    }

    String getOrdinate(Element item, String ordinate) {
        return item.getElementsByTagName(ordinate).item(0).getChildNodes().item(0).getNodeValue();
    }

    Document getRSSResponse(WMSMapContext map, GeoRSSTransformerBase.GeometryEncoding encoding) throws TransformerException, ParserConfigurationException, FactoryConfigurationError, SAXException, IOException {
        RSSGeoRSSTransformer tx = new RSSGeoRSSTransformer();
        tx.setGeometryEncoding(encoding);
        tx.setIndentation(2);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        tx.transform((Object)map, (OutputStream)output);
        DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document document = docBuilder.parse(new ByteArrayInputStream(output.toByteArray()));
        return document;
    }
}

