/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.map.georss;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import junit.framework.Assert;
import org.geoserver.data.test.MockData;
import org.geoserver.wms.WMSTestSupport;
import org.geotools.data.Query;
import org.vfny.geoserver.wms.WMSMapContext;
import org.vfny.geoserver.wms.responses.map.georss.AtomGeoRSSTransformer;
import org.vfny.geoserver.wms.responses.map.georss.GeoRSSTransformerBase;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class AtomGeoRSSTransformerTest
extends WMSTestSupport {
    WMSMapContext map;

    protected void setUp() throws Exception {
        super.setUp();
        this.map = new WMSMapContext(this.createGetMapRequest(MockData.BASIC_POLYGONS));
        this.map.addLayer(this.createMapLayer(MockData.BASIC_POLYGONS));
    }

    public void testLatLong() throws Exception {
        AtomGeoRSSTransformer tx = new AtomGeoRSSTransformer();
        tx.setGeometryEncoding(GeoRSSTransformerBase.GeometryEncoding.LATLONG);
        tx.setIndentation(2);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        tx.transform((Object)this.map, (OutputStream)output);
        DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document document = docBuilder.parse(new ByteArrayInputStream(output.toByteArray()));
        Element element = document.getDocumentElement();
        Assert.assertEquals((String)"feed", (String)element.getNodeName());
        NodeList entries = element.getElementsByTagName("entry");
        int n = this.getFeatureSource(MockData.BASIC_POLYGONS).getCount(Query.ALL);
        Assert.assertEquals((int)n, (int)entries.getLength());
        for (int i = 0; i < entries.getLength(); ++i) {
            Element entry = (Element)entries.item(i);
            Assert.assertEquals((int)1, (int)entry.getElementsByTagName("geo:lat").getLength());
            Assert.assertEquals((int)1, (int)entry.getElementsByTagName("geo:long").getLength());
        }
    }

    public void testSimple() throws Exception {
        AtomGeoRSSTransformer tx = new AtomGeoRSSTransformer();
        tx.setGeometryEncoding(GeoRSSTransformerBase.GeometryEncoding.SIMPLE);
        tx.setIndentation(2);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        tx.transform((Object)this.map, (OutputStream)output);
        DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document document = docBuilder.parse(new ByteArrayInputStream(output.toByteArray()));
        Element element = document.getDocumentElement();
        Assert.assertEquals((String)"feed", (String)element.getNodeName());
        NodeList entries = element.getElementsByTagName("entry");
        int n = this.getFeatureSource(MockData.BASIC_POLYGONS).getCount(Query.ALL);
        Assert.assertEquals((int)n, (int)entries.getLength());
        for (int i = 0; i < entries.getLength(); ++i) {
            Element entry = (Element)entries.item(i);
            Assert.assertEquals((int)1, (int)entry.getElementsByTagName("georss:where").getLength());
            Assert.assertEquals((int)1, (int)entry.getElementsByTagName("georss:polygon").getLength());
        }
    }
}

