/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.featureinfo;

import junit.framework.Assert;
import org.geoserver.data.test.MockData;
import org.geoserver.wms.WMSTestSupport;
import org.geotools.data.FeatureSource;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.vfny.geoserver.wms.responses.featureInfo.FeatureTimeTemplate;

public class FeatureTimeTemplateTest
extends WMSTestSupport {
    Feature feature;

    protected void setUp() throws Exception {
        super.setUp();
        FeatureSource source = this.getFeatureSource(MockData.PRIMITIVEGEOFEATURE);
        FeatureCollection features = source.getFeatures();
        FeatureIterator iterator = features.features();
        while (iterator.hasNext()) {
            Feature f = iterator.next();
            if (f.getAttribute("dateProperty") == null) continue;
            this.feature = f;
            break;
        }
        features.close(iterator);
    }

    public void testEmpty() throws Exception {
        FeatureTimeTemplate template = new FeatureTimeTemplate();
        String[] result = template.execute(this.feature);
        Assert.assertEquals((int)0, (int)result.length);
    }

    public void testTimestamp() throws Exception {
        this.setupTemplate(MockData.PRIMITIVEGEOFEATURE, "time.ftl", "${dateProperty.value}");
        FeatureTimeTemplate template = new FeatureTimeTemplate();
        String[] result = template.execute(this.feature);
        Assert.assertEquals((int)1, (int)result.length);
        Assert.assertNotNull((Object)result[0]);
    }

    public void testTimeSpan() throws Exception {
        this.setupTemplate(MockData.PRIMITIVEGEOFEATURE, "time.ftl", "${dateProperty.value}||${dateProperty.value}");
        FeatureTimeTemplate template = new FeatureTimeTemplate();
        String[] result = template.execute(this.feature);
        Assert.assertEquals((int)2, (int)result.length);
        Assert.assertNotNull((Object)result[0]);
        Assert.assertNotNull((Object)result[1]);
    }

    public void testTimeSpanOpenEndedStart() throws Exception {
        this.setupTemplate(MockData.PRIMITIVEGEOFEATURE, "time.ftl", "||${dateProperty.value}");
        FeatureTimeTemplate template = new FeatureTimeTemplate();
        String[] result = template.execute(this.feature);
        Assert.assertEquals((int)2, (int)result.length);
        Assert.assertNull((Object)result[0]);
        Assert.assertNotNull((Object)result[1]);
    }

    public void testTimeSpanOpenEndedEnd() throws Exception {
        this.setupTemplate(MockData.PRIMITIVEGEOFEATURE, "time.ftl", "${dateProperty.value}||");
        FeatureTimeTemplate template = new FeatureTimeTemplate();
        String[] result = template.execute(this.feature);
        Assert.assertEquals((int)2, (int)result.length);
        Assert.assertNotNull((Object)result[0]);
        Assert.assertNull((Object)result[1]);
    }
}

