/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.kvp;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.net.URL;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import junit.framework.Assert;
import org.geoserver.data.test.MockData;
import org.geoserver.ows.Dispatcher;
import org.geoserver.test.GeoServerTestSupport;
import org.geoserver.test.ows.KvpRequestReaderTestSupport;
import org.geoserver.wms.RemoteOWSTestSupport;
import org.geoserver.wms.kvp.GetMapKvpRequestReader;
import org.geotools.styling.Style;
import org.opengis.filter.Id;
import org.opengis.filter.PropertyIsEqualTo;
import org.vfny.geoserver.config.PaletteManager;
import org.vfny.geoserver.global.MapLayerInfo;
import org.vfny.geoserver.global.WMS;
import org.vfny.geoserver.wms.WmsException;
import org.vfny.geoserver.wms.requests.GetMapRequest;
import org.vfny.geoserver.wms.servlets.GetMap;

public class GetMapKvpRequestReaderTest
extends KvpRequestReaderTestSupport {
    GetMapKvpRequestReader reader;
    Dispatcher dispatcher;
    static /* synthetic */ Class class$org$geoserver$wms$kvp$GetMapKvpRequestReader;

    protected void setUp() throws Exception {
        super.setUp();
        GetMap getMap = (GetMap)((GeoServerTestSupport)this).applicationContext.getBean("wmsGetMap");
        this.dispatcher = (Dispatcher)((GeoServerTestSupport)this).applicationContext.getBean("dispatcher");
        WMS wms = (WMS)((GeoServerTestSupport)this).applicationContext.getBean("wms");
        this.reader = new GetMapKvpRequestReader(getMap, wms);
    }

    public void testCreateRequest() throws Exception {
        GetMapRequest request = (GetMapRequest)this.reader.createRequest();
        Assert.assertNotNull((Object)request);
    }

    public void testReadMandatory() throws Exception {
        HashMap<String, String> raw = new HashMap<String, String>();
        raw.put("layers", MockData.BASIC_POLYGONS.getPrefix() + ":" + MockData.BASIC_POLYGONS.getLocalPart());
        raw.put("styles", MockData.BASIC_POLYGONS.getLocalPart());
        raw.put("format", "image/jpeg");
        raw.put("srs", "epsg:3003");
        raw.put("bbox", "-10,-10,10,10");
        raw.put("height", "600");
        raw.put("width", "800");
        GetMapRequest request = (GetMapRequest)this.reader.createRequest();
        request = (GetMapRequest)this.reader.read((Object)request, this.parseKvp(raw), raw);
        String layer = MockData.BASIC_POLYGONS.getLocalPart();
        Assert.assertEquals((int)1, (int)request.getLayers().length);
        Assert.assertTrue((boolean)request.getLayers()[0].getName().endsWith(layer));
        Assert.assertEquals((int)1, (int)request.getStyles().size());
        Assert.assertEquals((Object)this.getCatalog().getStyle(layer), request.getStyles().get(0));
        Assert.assertEquals((String)"image/jpeg", (String)request.getFormat());
        Assert.assertEquals((int)600, (int)request.getHeight());
        Assert.assertEquals((int)800, (int)request.getWidth());
        Assert.assertNotNull((Object)request.getBbox());
        Assert.assertEquals((double)-10.0, (double)request.getBbox().getMinX(), (double)0.0);
        Assert.assertEquals((double)-10.0, (double)request.getBbox().getMinY(), (double)0.0);
        Assert.assertEquals((double)10.0, (double)request.getBbox().getMaxX(), (double)0.0);
        Assert.assertEquals((double)10.0, (double)request.getBbox().getMaxY(), (double)0.0);
        Assert.assertEquals((String)"epsg:3003", (String)request.getSRS());
    }

    public void testReadOptional() throws Exception {
        HashMap<String, String> kvp = new HashMap<String, String>();
        kvp.put("bgcolor", "000000");
        kvp.put("transparent", "true");
        kvp.put("tiled", "true");
        kvp.put("tilesorigin", "1.2,3.4");
        kvp.put("buffer", "1");
        kvp.put("palette", "SAFE");
        kvp.put("time", "2006-02-27T22:08:12Z");
        kvp.put("elevation", "4");
        GetMapRequest request = (GetMapRequest)this.reader.createRequest();
        request = (GetMapRequest)this.reader.read((Object)request, this.parseKvp(kvp), kvp);
        Assert.assertEquals((Object)Color.BLACK, (Object)request.getBgColor());
        Assert.assertTrue((boolean)request.isTransparent());
        Assert.assertTrue((boolean)request.isTiled());
        Assert.assertEquals((Object)new Point2D.Double(1.2, 3.4), (Object)request.getTilesOrigin());
        Assert.assertEquals((int)1, (int)request.getBuffer());
        Assert.assertEquals((Object)PaletteManager.safePalette, (Object)request.getPalette().getIcm());
        Assert.assertEquals((Object)new Integer(4), (Object)request.getElevation());
        Calendar cal = Calendar.getInstance();
        cal.set(2006, 1, 27, 22, 8, 12);
        List times = request.getTime();
        Assert.assertEquals((int)1, (int)request.getTime().size());
        Assert.assertEquals((String)cal.getTime().toString(), (String)times.get(0).toString());
    }

    public void testDefaultStyle() throws Exception {
        HashMap<String, String> raw = new HashMap<String, String>();
        raw.put("layers", MockData.BASIC_POLYGONS.getPrefix() + ":" + MockData.BASIC_POLYGONS.getLocalPart() + "," + MockData.BUILDINGS.getPrefix() + ":" + MockData.BUILDINGS.getLocalPart());
        raw.put("styles", ",");
        raw.put("format", "image/jpeg");
        raw.put("srs", "epsg:3003");
        raw.put("bbox", "-10,-10,10,10");
        raw.put("height", "600");
        raw.put("width", "800");
        GetMapRequest request = (GetMapRequest)this.reader.createRequest();
        request = (GetMapRequest)this.reader.read((Object)request, this.parseKvp(raw), raw);
        Assert.assertEquals((int)2, (int)request.getStyles().size());
    }

    public void testFilter() throws Exception {
        HashMap<String, String> kvp = new HashMap<String, String>();
        kvp.put("filter", "<Filter><FeatureId id=\"foo\"/></Filter>");
        GetMapRequest request = (GetMapRequest)this.reader.createRequest();
        request = (GetMapRequest)this.reader.read((Object)request, this.parseKvp(kvp), kvp);
        Assert.assertNotNull((Object)request.getFilter());
        Assert.assertEquals((int)1, (int)request.getFilter().size());
        Id fid = (Id)request.getFilter().get(0);
        Assert.assertEquals((int)1, (int)fid.getIDs().size());
        Assert.assertEquals((Object)"foo", fid.getIDs().iterator().next());
    }

    public void testCQLFilter() throws Exception {
        HashMap<String, String> kvp = new HashMap<String, String>();
        kvp.put("cql_filter", "foo = bar");
        GetMapRequest request = (GetMapRequest)this.reader.createRequest();
        request = (GetMapRequest)this.reader.read((Object)request, this.parseKvp(kvp), kvp);
        Assert.assertNotNull((Object)request.getCQLFilter());
        Assert.assertEquals((int)1, (int)request.getCQLFilter().size());
        PropertyIsEqualTo filter = (PropertyIsEqualTo)request.getCQLFilter().get(0);
    }

    public void testFeatureId() throws Exception {
        HashMap<String, String> kvp = new HashMap<String, String>();
        kvp.put("featureid", "foo");
        GetMapRequest request = (GetMapRequest)this.reader.createRequest();
        request = (GetMapRequest)this.reader.read((Object)request, this.parseKvp(kvp), kvp);
        Assert.assertNotNull((Object)request.getFeatureId());
        Assert.assertEquals((int)1, (int)request.getFeatureId().size());
        Assert.assertEquals((Object)"foo", request.getFeatureId().get(0));
    }

    public void testSldNoDefault() throws Exception {
        HashMap<String, String> kvp = new HashMap<String, String>();
        URL url = (class$org$geoserver$wms$kvp$GetMapKvpRequestReader == null ? (class$org$geoserver$wms$kvp$GetMapKvpRequestReader = GetMapKvpRequestReaderTest.class$("org.geoserver.wms.kvp.GetMapKvpRequestReader")) : class$org$geoserver$wms$kvp$GetMapKvpRequestReader).getResource("BasicPolygonsLibraryNoDefault.sld");
        kvp.put("sld", url.toString());
        kvp.put("layers", MockData.BASIC_POLYGONS.getPrefix() + ":" + MockData.BASIC_POLYGONS.getLocalPart());
        GetMapRequest request = (GetMapRequest)this.reader.createRequest();
        this.reader.setLaxStyleMatchAllowed(false);
        request = (GetMapRequest)this.reader.read((Object)request, this.parseKvp(kvp), kvp);
        Assert.assertNotNull((Object)request.getSld());
        Assert.assertEquals((Object)url, (Object)request.getSld());
        Style style = (Style)request.getStyles().get(0);
        Assert.assertNotNull((Object)style);
        Assert.assertEquals((String)"BasicPolygons", (String)style.getName());
    }

    public void testSldDefault() throws Exception {
        HashMap<String, String> kvp = new HashMap<String, String>();
        URL url = (class$org$geoserver$wms$kvp$GetMapKvpRequestReader == null ? (class$org$geoserver$wms$kvp$GetMapKvpRequestReader = GetMapKvpRequestReaderTest.class$("org.geoserver.wms.kvp.GetMapKvpRequestReader")) : class$org$geoserver$wms$kvp$GetMapKvpRequestReader).getResource("BasicPolygonsLibraryDefault.sld");
        kvp.put("sld", url.toString());
        kvp.put("layers", MockData.BASIC_POLYGONS.getPrefix() + ":" + MockData.BASIC_POLYGONS.getLocalPart());
        GetMapRequest request = (GetMapRequest)this.reader.createRequest();
        request = (GetMapRequest)this.reader.read((Object)request, this.parseKvp(kvp), kvp);
        Assert.assertNotNull((Object)request.getSld());
        Assert.assertEquals((Object)url, (Object)request.getSld());
        Style style = (Style)request.getStyles().get(0);
        Assert.assertNotNull((Object)style);
        Assert.assertEquals((String)"TheLibraryModeStyle", (String)style.getName());
    }

    public void testSldNamed() throws Exception {
        HashMap<String, String> kvp = new HashMap<String, String>();
        URL url = (class$org$geoserver$wms$kvp$GetMapKvpRequestReader == null ? (class$org$geoserver$wms$kvp$GetMapKvpRequestReader = GetMapKvpRequestReaderTest.class$("org.geoserver.wms.kvp.GetMapKvpRequestReader")) : class$org$geoserver$wms$kvp$GetMapKvpRequestReader).getResource("BasicPolygonsLibraryNoDefault.sld");
        kvp.put("sld", url.toString());
        kvp.put("layers", MockData.BASIC_POLYGONS.getPrefix() + ":" + MockData.BASIC_POLYGONS.getLocalPart());
        kvp.put("styles", "TheLibraryModeStyle");
        GetMapRequest request = (GetMapRequest)this.reader.createRequest();
        request = (GetMapRequest)this.reader.read((Object)request, this.parseKvp(kvp), kvp);
        Assert.assertNotNull((Object)request.getSld());
        Assert.assertEquals((Object)url, (Object)request.getSld());
        Style style = (Style)request.getStyles().get(0);
        Assert.assertNotNull((Object)style);
        Assert.assertEquals((String)"TheLibraryModeStyle", (String)style.getName());
    }

    public void testSldFailLookup() throws Exception {
        HashMap<String, String> kvp = new HashMap<String, String>();
        URL url = (class$org$geoserver$wms$kvp$GetMapKvpRequestReader == null ? (class$org$geoserver$wms$kvp$GetMapKvpRequestReader = GetMapKvpRequestReaderTest.class$("org.geoserver.wms.kvp.GetMapKvpRequestReader")) : class$org$geoserver$wms$kvp$GetMapKvpRequestReader).getResource("BasicPolygonsLibraryNoDefault.sld");
        kvp.put("sld", url.toString());
        kvp.put("layers", MockData.BASIC_POLYGONS.getPrefix() + ":" + MockData.BASIC_POLYGONS.getLocalPart());
        kvp.put("styles", "ThisStyleDoesNotExists");
        GetMapRequest request = (GetMapRequest)this.reader.createRequest();
        try {
            this.reader.setLaxStyleMatchAllowed(false);
            request = (GetMapRequest)this.reader.read((Object)request, this.parseKvp(kvp), kvp);
            Assert.fail((String)"The style looked up, 'ThisStyleDoesNotExists', should not have been found");
        }
        catch (WmsException e) {
            System.out.println((Object)e);
        }
    }

    public void testWmtVer() throws Exception {
        this.dispatcher.setCiteCompliant(true);
        String request = "wms?SERVICE=WMS&&WiDtH=200&FoRmAt=image/png&LaYeRs=cite:Lakes&StYlEs=&BbOx=0,-0.0020,0.0040,0&ReQuEsT=GetMap&HeIgHt=100&SrS=EPSG:4326&WmTvEr=1.1.1";
        Assert.assertEquals((String)"image/png", (String)this.getAsServletResponse(request).getContentType());
    }

    public void testRemoteWFS() throws Exception {
        if (!RemoteOWSTestSupport.isRemoteStatesAvailable()) {
            return;
        }
        HashMap<String, String> raw = new HashMap<String, String>();
        raw.put("layers", "topp:states");
        raw.put("styles", MockData.BASIC_POLYGONS.getLocalPart());
        raw.put("format", "image/png");
        raw.put("srs", "epsg:4326");
        raw.put("bbox", "-100,20,-60,50");
        raw.put("height", "300");
        raw.put("width", "300");
        raw.put("remote_ows_type", "WFS");
        raw.put("remote_ows_url", "http://sigma.openplans.org:8080/geoserver/wfs?");
        GetMapRequest request = (GetMapRequest)this.reader.createRequest();
        request = (GetMapRequest)this.reader.read((Object)request, this.parseKvp(raw), raw);
        Assert.assertEquals((String)"WFS", (String)request.getRemoteOwsType());
        Assert.assertEquals((Object)new URL("http://sigma.openplans.org:8080/geoserver/wfs?"), (Object)request.getRemoteOwsURL());
        Assert.assertEquals((int)1, (int)request.getLayers().length);
        Assert.assertEquals((int)MapLayerInfo.TYPE_REMOTE_VECTOR, (int)request.getLayers()[0].getType());
        Assert.assertEquals((String)"topp:states", (String)request.getLayers()[0].getRemoteFeatureSource().getSchema().getTypeName());
    }

    public void testRemoteWFSNoStyle() throws Exception {
        if (!RemoteOWSTestSupport.isRemoteStatesAvailable()) {
            return;
        }
        HashMap<String, String> raw = new HashMap<String, String>();
        raw.put("layers", "topp:states");
        raw.put("format", "image/png");
        raw.put("srs", "epsg:4326");
        raw.put("bbox", "-100,20,-60,50");
        raw.put("height", "300");
        raw.put("width", "300");
        raw.put("remote_ows_type", "WFS");
        raw.put("remote_ows_url", "http://sigma.openplans.org:8080/geoserver/wfs?");
        GetMapRequest request = (GetMapRequest)this.reader.createRequest();
        try {
            request = (GetMapRequest)this.reader.read((Object)request, this.parseKvp(raw), raw);
            Assert.fail((String)"This should have thrown an exception because of the missing style");
        }
        catch (WmsException e) {
            Assert.assertEquals((String)"NoDefaultStyle", (String)e.getCode());
        }
    }

    public void testRemoteWFSInvalidURL() throws Exception {
        if (!RemoteOWSTestSupport.isRemoteStatesAvailable()) {
            return;
        }
        HashMap<String, String> raw = new HashMap<String, String>();
        raw.put("layers", "topp:states");
        raw.put("format", "image/png");
        raw.put("srs", "epsg:4326");
        raw.put("bbox", "-100,20,-60,50");
        raw.put("height", "300");
        raw.put("width", "300");
        raw.put("remote_ows_type", "WFS");
        raw.put("remote_ows_url", "http://phantom.openplans.org:8080/crapserver/wfs?");
        GetMapRequest request = (GetMapRequest)this.reader.createRequest();
        try {
            request = (GetMapRequest)this.reader.read((Object)request, this.parseKvp(raw), raw);
            Assert.fail((String)"This should have thrown an exception because of the non existent layer");
        }
        catch (WmsException e) {
            e.printStackTrace();
            Assert.assertEquals((String)"RemoteOWSFailure", (String)e.getCode());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

