/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.xml.namespace.QName;
import org.geoserver.test.GeoServerTestSupport;
import org.geotools.map.DefaultMapLayer;
import org.geotools.map.MapLayer;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.styling.Style;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.vfny.geoserver.global.FeatureTypeInfo;
import org.vfny.geoserver.global.MapLayerInfo;
import org.vfny.geoserver.global.WMS;
import org.vfny.geoserver.wms.requests.GetMapRequest;
import org.vfny.geoserver.wms.servlets.GetMap;
import org.vfny.geoserver.wms.servlets.WMService;

public class WMSTestSupport
extends GeoServerTestSupport {
    protected WMS getWMS() {
        return (WMS)this.applicationContext.getBean("wms");
    }

    protected MapLayer createMapLayer(QName layerName) throws IOException {
        FeatureTypeInfo info = this.getCatalog().getFeatureTypeInfo(layerName);
        Style style = info.getDefaultStyle();
        DefaultMapLayer layer = new DefaultMapLayer(info.getFeatureSource(), style);
        layer.setTitle(info.getTypeName());
        return layer;
    }

    protected GetMapRequest createGetMapRequest(QName layerName) {
        return this.createGetMapRequest(new QName[]{layerName});
    }

    protected GetMapRequest createGetMapRequest(QName[] layerNames) {
        GetMapRequest request = new GetMapRequest((WMService)new GetMap(this.getWMS()));
        request.setHttpServletRequest((HttpServletRequest)this.createRequest("wms"));
        MapLayerInfo[] layers = new MapLayerInfo[layerNames.length];
        ArrayList<Style> styles = new ArrayList<Style>();
        for (int i = 0; i < layerNames.length; ++i) {
            FeatureTypeInfo ftInfo = this.getCatalog().getFeatureTypeInfo(layerNames[i]);
            styles.add(ftInfo.getDefaultStyle());
            layers[i] = new MapLayerInfo(ftInfo);
        }
        request.setLayers(layers);
        request.setStyles(styles);
        request.setBbox(new Envelope(-180.0, -90.0, 180.0, 90.0));
        request.setCrs((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        request.setSRS("EPSG:4326");
        request.setRawKvp(new HashMap());
        return request;
    }
}

