/* Copyright (c) 2001 - 2007 TOPP - www.openplans.org.  All rights reserved.
 * This code is licensed under the GPL 2.0 license, availible at the root
 * application directory.
 */
package org.vfny.geoserver.wms.servlets;

import org.vfny.geoserver.Response;
import org.vfny.geoserver.global.WMS;
import org.vfny.geoserver.util.requests.readers.KvpRequestReader;
import org.vfny.geoserver.util.requests.readers.XmlRequestReader;
import org.vfny.geoserver.wms.requests.CapabilitiesKvpReader;
import org.vfny.geoserver.wms.requests.CapabilitiesXmlReader;
import org.vfny.geoserver.wms.responses.GetMapResponse;
import org.vfny.geoserver.wms.responses.WMSCapabilitiesResponse;
import java.util.Map;
import java.util.Set;


/**
 * DOCUMENT ME!
 *
 * @author Gabriel Rold?n
 * @version $Id: Capabilities.java 6527 2007-04-19 14:52:21Z aaime $
 */
public class Capabilities extends WMService {
    public Capabilities(WMS wms) {
        super("GetCapabilities", wms);
    }

    /**
     * Protected constructor which allows subclass to "alias" request id.
     */
    protected Capabilities(String request, WMS wms) {
        super(request, wms);
    }

    /**
     * DOCUMENT ME!
     *
     * @param params DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    protected KvpRequestReader getKvpReader(Map params) {
        return new CapabilitiesKvpReader(params, this);
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    protected XmlRequestReader getXmlRequestReader() {
        return new CapabilitiesXmlReader(this);
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    protected Response getResponseHandler() {
        Set wmsGetMapFormats = GetMapResponse.loadImageFormats(getApplicationContext());

        return new WMSCapabilitiesResponse(wmsGetMapFormats, getApplicationContext());
    }
}
