/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.map.kml;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineSegment;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.jai.util.Range;
import javax.servlet.http.HttpServletRequest;
import org.geoserver.ows.util.RequestUtils;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.FeatureType;
import org.geotools.feature.type.DateUtil;
import org.geotools.map.MapLayer;
import org.geotools.renderer.style.LineStyle2D;
import org.geotools.renderer.style.MarkStyle2D;
import org.geotools.renderer.style.PolygonStyle2D;
import org.geotools.renderer.style.SLDStyleFactory;
import org.geotools.renderer.style.Style2D;
import org.geotools.renderer.style.TextStyle2D;
import org.geotools.styling.ExternalGraphic;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Fill;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.Mark;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.SLD;
import org.geotools.styling.Stroke;
import org.geotools.styling.Style;
import org.geotools.styling.Symbolizer;
import org.geotools.styling.TextSymbolizer;
import org.geotools.util.NumberRange;
import org.geotools.util.logging.Logging;
import org.geotools.xml.transform.Translator;
import org.geotools.xs.bindings.XSDateTimeBinding;
import org.opengis.filter.Filter;
import org.opengis.filter.expression.Expression;
import org.vfny.geoserver.global.GeoServer;
import org.vfny.geoserver.wms.WMSMapContext;
import org.vfny.geoserver.wms.responses.featureInfo.FeatureTemplate;
import org.vfny.geoserver.wms.responses.featureInfo.FeatureTimeTemplate;
import org.vfny.geoserver.wms.responses.map.kml.KMLGeometryTransformer;
import org.vfny.geoserver.wms.responses.map.kml.KMLTransformerBase;
import org.vfny.geoserver.wms.responses.map.kml.KMLUtils;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class KMLVectorTransformer
extends KMLTransformerBase {
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver.kml");
    static final double TOLERANCE = 1.0E-6;
    protected final WMSMapContext mapContext;
    protected final MapLayer mapLayer;
    double scaleDenominator = 1.0;
    NumberRange scaleRange = new NumberRange(this.scaleDenominator, this.scaleDenominator);
    SLDStyleFactory styleFactory = new SLDStyleFactory();
    FeatureTemplate template = new FeatureTemplate();
    static List dtformats = new ArrayList();
    static List dformats = new ArrayList();
    static List tformats = new ArrayList();

    static void addFormats(List formats, String pattern) {
        formats.add(new SimpleDateFormat(pattern.replaceAll("%", "-")));
        formats.add(new SimpleDateFormat(pattern.replaceAll("%", "/")));
        formats.add(new SimpleDateFormat(pattern.replaceAll("%", ".")));
        formats.add(new SimpleDateFormat(pattern.replaceAll("%", " ")));
        formats.add(new SimpleDateFormat(pattern.replaceAll("%", ",")));
    }

    public KMLVectorTransformer(WMSMapContext mapContext, MapLayer mapLayer) {
        this.mapContext = mapContext;
        this.mapLayer = mapLayer;
        this.setNamespaceDeclarationEnabled(false);
    }

    public void setScaleDenominator(double scaleDenominator) {
        this.scaleDenominator = scaleDenominator;
    }

    public Translator createTranslator(ContentHandler handler) {
        return new KMLTranslator(handler);
    }

    static {
        dtformats.add(FeatureTemplate.DATETIME_FORMAT);
        KMLVectorTransformer.addFormats(dtformats, "dd%MM%yy hh:mm:ss");
        KMLVectorTransformer.addFormats(dtformats, "MM%dd%yy hh:mm:ss");
        KMLVectorTransformer.addFormats(dtformats, "dd%MMM%yy hh:mm:ss");
        KMLVectorTransformer.addFormats(dtformats, "MMM%dd%yy hh:mm:ss");
        KMLVectorTransformer.addFormats(dtformats, "dd%MM%yy hh:mm");
        KMLVectorTransformer.addFormats(dtformats, "MM%dd%yy hh:mm");
        KMLVectorTransformer.addFormats(dtformats, "dd%MMM%yy hh:mm");
        KMLVectorTransformer.addFormats(dtformats, "MMM%dd%yy hh:mm");
        dformats.add(FeatureTemplate.DATE_FORMAT);
        KMLVectorTransformer.addFormats(dformats, "dd%MM%yy");
        KMLVectorTransformer.addFormats(dformats, "MM%dd%yy");
        KMLVectorTransformer.addFormats(dformats, "dd%MMM%yy");
        KMLVectorTransformer.addFormats(dformats, "MMM%dd%yy");
        tformats.add(FeatureTemplate.TIME_FORMAT);
    }

    protected class KMLTranslator
    extends KMLTransformerBase.KMLTranslatorSupport {
        Translator geometryTranslator;

        public KMLTranslator(ContentHandler contentHandler) {
            super(KMLVectorTransformer.this, contentHandler);
            KMLGeometryTransformer geometryTransformer = new KMLGeometryTransformer();
            geometryTransformer.setOmitXMLDeclaration(true);
            geometryTransformer.setNamespaceDeclarationEnabled(true);
            GeoServer config = KMLVectorTransformer.this.mapContext.getRequest().getGeoServer();
            geometryTransformer.setNumDecimals(config.getNumDecimals());
            this.geometryTranslator = geometryTransformer.createTranslator(contentHandler);
        }

        public void encode(Object o) throws IllegalArgumentException {
            FeatureCollection features = (FeatureCollection)o;
            FeatureType featureType = features.getSchema();
            if (KMLVectorTransformer.this.isStandAlone()) {
                this.start("kml");
            }
            this.start("Document");
            this.element("name", KMLVectorTransformer.this.mapLayer.getTitle());
            FeatureTypeStyle[] featureTypeStyles = this.filterFeatureTypeStyles(KMLVectorTransformer.this.mapLayer.getStyle(), featureType);
            this.encodeSchemas(features);
            this.encode(features, featureTypeStyles);
            this.end("Document");
            if (KMLVectorTransformer.this.isStandAlone()) {
                this.end("kml");
            }
        }

        protected void encodeSchemas(FeatureCollection featureTypeStyles) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void encode(FeatureCollection features, FeatureTypeStyle[] styles) {
            block8: {
                FeatureIterator reader = features.features();
                block5: while (true) {
                    while (reader.hasNext()) {
                        Feature feature = reader.next();
                        try {
                            this.encode(feature, styles);
                            continue block5;
                        }
                        catch (RuntimeException t) {
                            if (t.getCause() instanceof SAXException) {
                                throw t;
                            }
                            LOGGER.log(Level.WARNING, "Failure tranforming feature to KML:" + feature.getID(), t);
                        }
                    }
                    break block8;
                    {
                        continue block5;
                        break;
                    }
                    break;
                }
                finally {
                    features.close(reader);
                }
            }
        }

        protected void encode(Feature feature, FeatureTypeStyle[] styles) {
            String featureId = this.featureId(feature);
            if (this.encodeStyle(feature, styles)) {
                this.encodePlacemark(feature, styles);
            }
        }

        protected boolean encodeStyle(Feature feature, FeatureTypeStyle[] styles) {
            ArrayList<Symbolizer> symbolizerList = new ArrayList<Symbolizer>();
            for (int j = 0; j < styles.length; ++j) {
                Rule[] rules = this.filterRules(styles[j], feature);
                for (int i = 0; i < rules.length; ++i) {
                    symbolizerList.addAll(Arrays.asList(rules[i].getSymbolizers()));
                }
            }
            if (!symbolizerList.isEmpty()) {
                this.start("Style", KMLUtils.attributes(new String[]{"id", "GeoServerStyle" + feature.getID()}));
                this.encodeIconStyle(feature, styles);
                Symbolizer[] symbolizers = symbolizerList.toArray(new Symbolizer[symbolizerList.size()]);
                this.encodeStyle(feature, symbolizers);
                this.end("Style");
                return true;
            }
            return false;
        }

        protected void encodeIconStyle(Feature feature, FeatureTypeStyle[] styles) {
            boolean poly;
            this.start("IconStyle");
            if (!KMLVectorTransformer.this.mapContext.getRequest().getKMattr()) {
                this.encodeColor("00ffffff");
            }
            boolean line = feature.getDefaultGeometry() != null && (feature.getDefaultGeometry() instanceof LineString || feature.getDefaultGeometry() instanceof MultiLineString);
            boolean bl = poly = feature.getDefaultGeometry() != null && (feature.getDefaultGeometry() instanceof Polygon || feature.getDefaultGeometry() instanceof MultiPolygon);
            if (line || poly) {
                this.element("scale", "0.4");
            }
            this.start("Icon");
            if (line || poly) {
                String imageURL;
                try {
                    URL requestURL = new URL(KMLVectorTransformer.this.mapContext.getRequest().getBaseUrl());
                    imageURL = requestURL.getProtocol() + "://" + requestURL.getHost() + ":" + requestURL.getPort();
                    imageURL = imageURL + "/geoserver/" + (poly ? "icon-poly.png" : "icon-line.png");
                }
                catch (MalformedURLException mue) {
                    imageURL = "http://maps.google.com/mapfiles/kml/pal3/icon61.png";
                }
                this.element("href", imageURL);
            }
            this.end("Icon");
            this.end("IconStyle");
        }

        protected void encodeStyle(Feature feature, Symbolizer[] symbolizers) {
            int i;
            boolean forceOutline = false;
            for (i = 0; i < symbolizers.length; ++i) {
                if (!(symbolizers[i] instanceof LineSymbolizer)) continue;
                forceOutline = true;
                break;
            }
            for (i = 0; i < symbolizers.length; ++i) {
                Symbolizer symbolizer = symbolizers[i];
                LOGGER.finer("Applying symbolizer " + symbolizer);
                Style2D style = KMLVectorTransformer.this.styleFactory.createStyle((Object)feature, symbolizer, (Range)KMLVectorTransformer.this.scaleRange);
                if (symbolizer instanceof TextSymbolizer) {
                    this.encodeTextStyle((TextStyle2D)style, (TextSymbolizer)symbolizer);
                }
                if (symbolizer instanceof PolygonSymbolizer) {
                    this.encodePolygonStyle((PolygonStyle2D)style, (PolygonSymbolizer)symbolizer, forceOutline);
                }
                if (symbolizer instanceof LineSymbolizer) {
                    this.encodeLineStyle((LineStyle2D)style, (LineSymbolizer)symbolizer);
                }
                if (!(symbolizer instanceof PointSymbolizer)) continue;
                this.encodePointStyle(style, (PointSymbolizer)symbolizer);
            }
        }

        protected void encodePolygonStyle(PolygonStyle2D style, PolygonSymbolizer symbolizer, boolean forceOutline) {
            double opacity;
            this.start("PolyStyle");
            if (symbolizer.getFill() != null) {
                opacity = SLD.opacity((Fill)symbolizer.getFill());
                if (Double.isNaN(opacity)) {
                    opacity = 1.0;
                }
                this.encodeColor(SLD.color((Fill)symbolizer.getFill()), opacity);
            } else {
                this.encodeColor("00aaaaaa");
            }
            if (symbolizer.getStroke() != null || forceOutline) {
                this.element("outline", "1");
            } else {
                this.element("outline", "0");
            }
            this.end("PolyStyle");
            if (symbolizer.getStroke() != null) {
                this.start("LineStyle");
                opacity = SLD.opacity((Stroke)symbolizer.getStroke());
                if (Double.isNaN(opacity)) {
                    opacity = 1.0;
                }
                this.encodeColor(this.colorToHex((Color)style.getContour(), opacity));
                int width = SLD.width((Stroke)symbolizer.getStroke());
                if (width != -1) {
                    this.element("width", Integer.toString(width));
                }
                this.end("LineStyle");
            }
        }

        protected void encodeLineStyle(LineStyle2D style, LineSymbolizer symbolizer) {
            this.start("LineStyle");
            if (symbolizer.getStroke() != null) {
                double opacity = SLD.opacity((Stroke)symbolizer.getStroke());
                if (Double.isNaN(opacity)) {
                    opacity = 1.0;
                }
                this.encodeColor((Color)style.getContour(), opacity);
                int width = SLD.width((Stroke)symbolizer.getStroke());
                if (width != -1) {
                    this.element("width", Integer.toString(width));
                }
            } else {
                this.encodeColor("ffaaaaaa");
                this.element("width", "1");
            }
            this.end("LineStyle");
        }

        protected void encodePointStyle(Style2D style, PointSymbolizer symbolizer) {
            this.start("IconStyle");
            if (style instanceof MarkStyle2D) {
                Mark mark = SLD.mark((PointSymbolizer)symbolizer);
                if (mark != null) {
                    double opacity = SLD.opacity((Fill)mark.getFill());
                    if (Double.isNaN(opacity)) {
                        opacity = 1.0;
                    }
                    if (mark.getFill() != null) {
                        Color color = SLD.color((Fill)mark.getFill());
                        this.encodeColor(color, opacity);
                    }
                } else {
                    this.encodeColor("ffaaaaaa");
                }
            } else {
                this.encodeColor("ffaaaaaa");
            }
            this.element("colorMode", "normal");
            String iconHref = null;
            if (symbolizer.getGraphic() != null && symbolizer.getGraphic().getExternalGraphics() != null && symbolizer.getGraphic().getExternalGraphics().length > 0) {
                ExternalGraphic graphic = symbolizer.getGraphic().getExternalGraphics()[0];
                try {
                    if ("file".equals(graphic.getLocation().getProtocol())) {
                        File file = new File(graphic.getLocation().getFile());
                        iconHref = RequestUtils.baseURL((HttpServletRequest)KMLVectorTransformer.this.mapContext.getRequest().getHttpServletRequest()) + "styles/" + file.getName();
                    } else if ("http".equals(graphic.getLocation().getProtocol())) {
                        iconHref = graphic.getLocation().toString();
                    }
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "Error processing external graphic:" + graphic, e);
                }
            }
            if (iconHref == null) {
                iconHref = "http://maps.google.com/mapfiles/kml/pal4/icon25.png";
            }
            this.start("Icon");
            this.element("href", iconHref);
            this.end("Icon");
            this.end("IconStyle");
        }

        protected void encodeTextStyle(TextStyle2D style, TextSymbolizer symbolizer) {
            this.start("LabelStyle");
            if (symbolizer.getFill() != null) {
                double opacity = SLD.opacity((Fill)symbolizer.getFill());
                if (Double.isNaN(opacity)) {
                    opacity = 1.0;
                }
                this.encodeColor(SLD.color((Fill)symbolizer.getFill()), opacity);
            } else {
                this.encodeColor("ffffffff");
            }
            this.end("LabelStyle");
        }

        protected void encodePlacemark(Feature feature, FeatureTypeStyle[] styles) {
            String msg;
            Geometry geometry = this.featureGeometry(feature);
            Coordinate centroid = this.geometryCentroid(geometry);
            this.start("Placemark", KMLUtils.attributes(new String[]{"id", feature.getID()}));
            if (KMLVectorTransformer.this.mapContext.getRequest().getKMattr()) {
                try {
                    this.encodePlacemarkName(feature, styles);
                }
                catch (Exception e) {
                    msg = "Error occured processing 'title' template.";
                    LOGGER.log(Level.WARNING, msg, e);
                }
                try {
                    this.encodePlacemarkDescription(feature);
                }
                catch (Exception e) {
                    msg = "Error occured processing 'description' template.";
                    LOGGER.log(Level.WARNING, msg, e);
                }
            }
            this.encodePlacemarkLookAt(centroid);
            try {
                this.encodePlacemarkTime(feature);
            }
            catch (Exception e) {
                msg = "Error occured processing 'time' template: " + e.getMessage();
                LOGGER.log(Level.WARNING, msg);
                LOGGER.log(Level.FINE, "", e);
            }
            this.element("styleUrl", "#GeoServerStyle" + feature.getID());
            this.encodeExtendedData(feature);
            this.encodePlacemarkGeometry(geometry, centroid);
            this.end("Placemark");
        }

        protected void encodeExtendedData(Feature feature) {
        }

        protected void encodePlacemarkName(Feature feature, FeatureTypeStyle[] styles) throws IOException {
            String title = KMLVectorTransformer.this.template.title(feature);
            if (title == null || "".equals(title) || feature.getID().equals(title)) {
                StringBuffer label = new StringBuffer();
                for (int i = 0; i < styles.length; ++i) {
                    Rule[] rules = this.filterRules(styles[i], feature);
                    for (int j = 0; j < rules.length; ++j) {
                        Symbolizer[] syms = rules[j].getSymbolizers();
                        for (int k = 0; k < syms.length; ++k) {
                            if (!(syms[k] instanceof TextSymbolizer)) continue;
                            Expression e = SLD.textLabel((TextSymbolizer)((TextSymbolizer)syms[k]));
                            Object object = e.evaluate((Object)feature);
                            String value = null;
                            if (object instanceof String) {
                                value = (String)object;
                            } else if (object != null) {
                                value = object.toString();
                            }
                            if (value == null || "".equals(value.trim())) continue;
                            label.append(value);
                        }
                    }
                }
                title = label.length() > 0 ? label.toString() : null;
            }
            if (title != null) {
                this.start("name");
                this.cdata(title);
                this.end("name");
            }
        }

        protected void encodePlacemarkDescription(Feature feature) throws IOException {
            String description = KMLVectorTransformer.this.template.description(feature);
            if (description != null) {
                this.start("description");
                this.cdata(description);
                this.end("description");
            }
        }

        protected void encodePlacemarkLookAt(Coordinate centroid) {
            this.start("LookAt");
            this.element("longitude", Double.toString(centroid.x));
            this.element("latitude", Double.toString(centroid.y));
            this.element("range", "700");
            this.element("tilt", "10.0");
            this.element("heading", "10.0");
            this.end("LookAt");
        }

        protected void encodePlacemarkTime(Feature feature) throws IOException {
            try {
                String[] time = new FeatureTimeTemplate(KMLVectorTransformer.this.template).execute(feature);
                if (time.length == 0) {
                    return;
                }
                if (time.length == 1) {
                    String datetime = this.encodeDateTime(time[0]);
                    if (datetime != null) {
                        this.start("TimeStamp");
                        this.element("when", datetime);
                        this.end("TimeStamp");
                    }
                } else {
                    String begin = this.encodeDateTime(time[0]);
                    String end = this.encodeDateTime(time[1]);
                    if (begin != null || end != null) {
                        this.start("TimeSpan");
                        if (begin != null) {
                            this.element("begin", begin);
                        }
                        if (end != null) {
                            this.element("end", end);
                        }
                        this.end("TimeSpan");
                    }
                }
            }
            catch (Exception e) {
                throw (IOException)new IOException().initCause(e);
            }
        }

        protected String encodeDateTime(String date) throws Exception {
            Date d = this.parseDate(dtformats, date);
            if (d == null) {
                d = this.parseDate(dformats, date);
            }
            if (d == null) {
                d = this.parseDate(tformats, date);
            }
            if (d == null) {
                try {
                    d = DateUtil.deserializeDateTime((String)date);
                }
                catch (Exception e1) {
                    try {
                        d = DateUtil.deserializeDate((String)date);
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                }
            }
            if (d != null) {
                Calendar c = Calendar.getInstance();
                c.setTime(d);
                return new XSDateTimeBinding().encode((Object)c, null);
            }
            LOGGER.warning("Could not parse date: " + date);
            return null;
        }

        protected Date parseDate(List formats, String date) {
            Iterator f = formats.iterator();
            while (f.hasNext()) {
                SimpleDateFormat format = (SimpleDateFormat)f.next();
                Date d = null;
                try {
                    d = format.parse(date);
                }
                catch (ParseException e) {
                    // empty catch block
                }
                if (d == null) continue;
                return d;
            }
            return null;
        }

        protected void encodePlacemarkGeometry(Geometry geometry, Coordinate centroid) {
            if (geometry instanceof Point || geometry instanceof MultiPoint && ((MultiPoint)geometry).getNumPoints() == 1) {
                this.encodeGeometry(geometry);
            } else {
                this.start("MultiGeometry");
                this.start("Point");
                if (!Double.isNaN(centroid.z)) {
                    this.element("coordinates", centroid.x + "," + centroid.y + "," + centroid.z);
                } else {
                    this.element("coordinates", centroid.x + "," + centroid.y);
                }
                this.end("Point");
                this.encodeGeometry(geometry);
                this.end("MultiGeometry");
            }
        }

        protected void encodeGeometry(Geometry geometry) {
            if (geometry instanceof GeometryCollection) {
                GeometryCollection collection = (GeometryCollection)geometry;
                for (int i = 0; i < collection.getNumGeometries(); ++i) {
                    this.encodeGeometry(collection.getGeometryN(i));
                }
            } else {
                this.geometryTranslator.encode((Object)geometry);
            }
        }

        void encodeColor(Color color, double opacity) {
            this.encodeColor(this.colorToHex(color, opacity));
        }

        void encodeColor(String hex) {
            this.element("color", hex);
        }

        boolean isWithInScale(Rule r) {
            return r.getMinScaleDenominator() - 1.0E-6 <= KMLVectorTransformer.this.scaleDenominator && r.getMaxScaleDenominator() + 1.0E-6 > KMLVectorTransformer.this.scaleDenominator;
        }

        String featureId(Feature feature) {
            String id = feature.getID();
            id = id.replaceAll("&", "");
            id = id.replaceAll(">", "");
            id = id.replaceAll("<", "");
            id = id.replaceAll("%", "");
            return id;
        }

        Geometry featureGeometry(Feature f) {
            Geometry geom = f.getDefaultGeometry();
            return geom;
        }

        Coordinate geometryCentroid(Geometry g) {
            if (g instanceof GeometryCollection) {
                GeometryCollection gc = (GeometryCollection)g;
                if (gc.getNumGeometries() == 1) {
                    g = gc.getGeometryN(0);
                } else {
                    Coordinate[] pts = new Coordinate[gc.getNumGeometries()];
                    for (int t = 0; t < gc.getNumGeometries(); ++t) {
                        pts[t] = gc.getGeometryN(t).getCentroid().getCoordinate();
                    }
                    return g.getFactory().createMultiPoint(pts).getCoordinates()[0];
                }
            }
            if (g instanceof Point) {
                return g.getCoordinate();
            }
            if (g instanceof LineString) {
                double tol = 1.0E-6;
                double mid = g.getLength() / 2.0;
                Coordinate[] coords = g.getCoordinates();
                double len = 0.0;
                for (int i = 1; i < coords.length; ++i) {
                    LineSegment line = new LineSegment(coords[i - 1], coords[i]);
                    if (Math.abs((len += line.getLength()) - mid) < tol) {
                        return line.getCoordinate(1);
                    }
                    if (!(len > mid)) continue;
                    return line.pointAlong(1.0 - (len - mid) / line.getLength());
                }
                return g.getCentroid().getCoordinate();
            }
            return g.getCentroid().getCoordinate();
        }

        String intToHex(int i) {
            String prelim = Integer.toHexString(i);
            if (prelim.length() < 2) {
                prelim = "0" + prelim;
            }
            return prelim;
        }

        String colorToHex(Color c, double opacity) {
            return this.intToHex(new Float(255.0 * opacity).intValue()) + this.intToHex(c.getBlue()) + this.intToHex(c.getGreen()) + this.intToHex(c.getRed());
        }

        protected FeatureTypeStyle[] filterFeatureTypeStyles(Style style, FeatureType featureType) {
            FeatureTypeStyle[] featureTypeStyles = style.getFeatureTypeStyles();
            if (featureTypeStyles == null || featureTypeStyles.length == 0) {
                return new FeatureTypeStyle[0];
            }
            ArrayList<FeatureTypeStyle> filtered = new ArrayList<FeatureTypeStyle>(featureTypeStyles.length);
            for (int i = 0; i < featureTypeStyles.length; ++i) {
                FeatureTypeStyle featureTypeStyle = featureTypeStyles[i];
                String featureTypeName = featureTypeStyle.getFeatureTypeName();
                if (featureTypeStyle.getRules() == null || featureTypeStyle.getRules().length == 0 || !featureType.getTypeName().equalsIgnoreCase(featureTypeName) && !featureType.isDescendedFrom(null, featureTypeName)) continue;
                filtered.add(featureTypeStyle);
            }
            return filtered.toArray(new FeatureTypeStyle[filtered.size()]);
        }

        Rule[] filterRules(FeatureTypeStyle featureTypeStyle, Feature feature) {
            Rule rule;
            int i;
            Rule[] rules = featureTypeStyle.getRules();
            if (rules == null || rules.length == 0) {
                return new Rule[0];
            }
            ArrayList<Rule> filtered = new ArrayList<Rule>(rules.length);
            boolean match = false;
            boolean hasElseFilter = false;
            for (i = 0; i < rules.length; ++i) {
                Filter filter;
                rule = rules[i];
                LOGGER.finer("Applying rule: " + rule.toString());
                if (rule.hasElseFilter()) {
                    hasElseFilter = true;
                    continue;
                }
                if (!this.isWithInScale(rule) || (filter = rule.getFilter()) != null && !filter.evaluate((Object)feature)) continue;
                match = true;
                filtered.add(rule);
            }
            if (!match && hasElseFilter) {
                for (i = 0; i < rules.length; ++i) {
                    rule = rules[i];
                    if (!this.isWithInScale(rule) || !rule.hasElseFilter()) continue;
                    filtered.add(rule);
                }
            }
            return filtered.toArray(new Rule[filtered.size()]);
        }
    }
}

